module Treetop
  module Compiler
    AUTOGENERATED = "# Autogenerated from a Treetop grammar. Edits may be lost.\n"
    class GrammarCompiler
      def compile(source_path, target_path = source_path.gsub(/\.(treetop|tt)\Z/, '.rb'))
        File.open(target_path, 'w') do |target_file|
          ruby = ruby_source(source_path)
          if ruby =~ /\A#.*\n/
            ruby.sub!(/\n/, "\n"+AUTOGENERATED+"\n\n")
          else
            ruby = AUTOGENERATED+"\n\n"+ruby
          end
          target_file.write(ruby)
        end
      end

      # compile a treetop file into ruby
      def ruby_source(source_path)
        ruby_source_from_string(File.read(source_path))
      end

      # compile a string containing treetop source into ruby
      def ruby_source_from_string(s)
        parser = MetagrammarParser.new
        result = parser.parse(s)
        unless result
          raise RuntimeError.new(parser.failure_reason)
        end
        result.compile
      end
    end
  end

  # compile a treetop source file and load it
  def self.load(path)
    unless path =~ Treetop::Polyglot::VALID_GRAMMAR_EXT_REGEXP
      ext = Treetop::Polyglot::VALID_GRAMMAR_EXT.select {|ext| File.exist?(path+".#{ext}")}.shift
      path += ".#{ext}" unless ext.nil?
    end
    File.open(path) do |source_file|
      source = source_file.read
      source.gsub!(/\b__FILE__\b/, %Q{"#{path}"})
      load_from_string(source)
    end
  end

  # compile a treetop source string and load it
  def self.load_from_string(s)
    compiler = Treetop::Compiler::GrammarCompiler.new
    Object.class_eval(compiler.ruby_source_from_string(s))
  end
end
