/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import sun.awt.image.MultiResolutionImage;

public class MultiResolutionBufferedImage
extends BufferedImage
implements MultiResolutionImage {
    Image[] resolutionVariants;
    int baseIndex;

    public MultiResolutionBufferedImage(int imageType, int baseIndex, Image ... images) {
        super(images[baseIndex].getWidth(null), images[baseIndex].getHeight(null), imageType);
        this.baseIndex = baseIndex;
        this.resolutionVariants = images;
        Graphics g = this.getGraphics();
        g.drawImage(images[baseIndex], 0, 0, null);
        g.dispose();
        images[baseIndex] = this;
    }

    @Override
    public Image getResolutionVariant(int width, int height) {
        for (Image image : this.resolutionVariants) {
            if (width > image.getWidth(null) || height > image.getHeight(null)) continue;
            return image;
        }
        return this;
    }

    @Override
    public List<Image> getResolutionVariants() {
        return Arrays.asList(this.resolutionVariants);
    }

    public MultiResolutionBufferedImage map(ImageMapper mapper) {
        Image[] images = new Image[this.resolutionVariants.length];
        for (int index = 0; index < this.resolutionVariants.length; ++index) {
            images[index] = mapper.mapImage(this.resolutionVariants[index]);
        }
        return new MultiResolutionBufferedImage(this.getType(), this.baseIndex, images);
    }

    public static interface ImageMapper {
        public Image mapImage(Image var1);
    }
}

