/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership.cloud;

import java.io.IOException;
import javax.management.ObjectName;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipProvider;
import org.apache.catalina.tribes.jmx.JmxRegistry;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.MembershipServiceBase;
import org.apache.catalina.tribes.membership.cloud.CloudMembershipServiceMBean;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CloudMembershipService
extends MembershipServiceBase
implements CloudMembershipServiceMBean {
    private static final Log log = LogFactory.getLog(CloudMembershipService.class);
    protected static final StringManager sm = StringManager.getManager(CloudMembershipService.class);
    public static final String MEMBERSHIP_PROVIDER_CLASS_NAME = "membershipProviderClassName";
    private static final String KUBE = "kubernetes";
    private static final String DNS = "dns";
    private static final String KUBE_PROVIDER_CLASS = "org.apache.catalina.tribes.membership.cloud.KubernetesMembershipProvider";
    private static final String DNS_PROVIDER_CLASS = "org.apache.catalina.tribes.membership.cloud.DNSMembershipProvider";
    protected static final byte[] INITIAL_ID = new byte[16];
    private MembershipProvider membershipProvider;
    private MemberImpl localMember;
    private byte[] payload;
    private byte[] domain;
    private ObjectName oname = null;

    public Object getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public boolean setProperty(String string, String string2) {
        return this.properties.setProperty(string, string2) == null;
    }

    public String getMembershipProviderClassName() {
        return this.properties.getProperty(MEMBERSHIP_PROVIDER_CLASS_NAME);
    }

    public void setMembershipProviderClassName(String string) {
        this.properties.setProperty(MEMBERSHIP_PROVIDER_CLASS_NAME, string);
    }

    @Override
    public void start(int n) throws Exception {
        Object object;
        if ((n & 4) == 0) {
            return;
        }
        this.createOrUpdateLocalMember();
        this.localMember.setServiceStartTime(System.currentTimeMillis());
        this.localMember.setMemberAliveTime(100L);
        this.localMember.setPayload(this.payload);
        this.localMember.setDomain(this.domain);
        if (this.membershipProvider == null) {
            object = this.getMembershipProviderClassName();
            if (object == null || KUBE.equals(object)) {
                object = KUBE_PROVIDER_CLASS;
            } else if (DNS.equals(object)) {
                object = DNS_PROVIDER_CLASS;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using membershipProvider: " + (String)object));
            }
            this.membershipProvider = (MembershipProvider)Class.forName((String)object).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.membershipProvider.setMembershipListener(this);
            this.membershipProvider.setMembershipService(this);
            this.membershipProvider.init(this.properties);
        }
        this.membershipProvider.start(n);
        object = JmxRegistry.getRegistry(this.channel);
        if (object != null) {
            this.oname = ((JmxRegistry)object).registerJmx(",component=Membership", this);
        }
    }

    @Override
    public void stop(int n) {
        try {
            if (this.membershipProvider != null && this.membershipProvider.stop(n)) {
                if (this.oname != null) {
                    JmxRegistry.getRegistry(this.channel).unregisterJmx(this.oname);
                    this.oname = null;
                }
                this.membershipProvider = null;
                this.channel = null;
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("cloudMembershipService.stopFail", n), (Throwable)exception);
        }
    }

    @Override
    public Member getLocalMember(boolean bl) {
        if (bl && this.localMember != null) {
            this.localMember.setMemberAliveTime(System.currentTimeMillis() - this.localMember.getServiceStartTime());
        }
        return this.localMember;
    }

    @Override
    public void setLocalMemberProperties(String string, int n, int n2, int n3) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("setLocalMemberProperties(%s, %d, %d, %d)", string, n, n2, n3));
        }
        this.properties.setProperty("tcpListenHost", string);
        this.properties.setProperty("tcpListenPort", String.valueOf(n));
        this.properties.setProperty("udpListenPort", String.valueOf(n3));
        this.properties.setProperty("tcpSecurePort", String.valueOf(n2));
        try {
            this.createOrUpdateLocalMember();
            this.localMember.setPayload(this.payload);
            this.localMember.setDomain(this.domain);
            this.localMember.getData(true, true);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    private void createOrUpdateLocalMember() throws IOException {
        String string = this.properties.getProperty("tcpListenHost");
        int n = Integer.parseInt(this.properties.getProperty("tcpListenPort"));
        int n2 = Integer.parseInt(this.properties.getProperty("tcpSecurePort"));
        int n3 = Integer.parseInt(this.properties.getProperty("udpListenPort"));
        if (this.localMember == null) {
            this.localMember = new MemberImpl();
            this.localMember.setUniqueId(INITIAL_ID);
            this.localMember.setLocal(true);
        }
        this.localMember.setHostname(string);
        this.localMember.setPort(n);
        this.localMember.setSecurePort(n2);
        this.localMember.setUdpPort(n3);
        this.localMember.getData(true, true);
    }

    @Override
    public void setPayload(byte[] byArray) {
        this.payload = byArray;
        if (this.localMember != null) {
            this.localMember.setPayload(byArray);
        }
    }

    @Override
    public void setDomain(byte[] byArray) {
        this.domain = byArray;
        if (this.localMember != null) {
            this.localMember.setDomain(byArray);
        }
    }

    @Override
    public MembershipProvider getMembershipProvider() {
        return this.membershipProvider;
    }

    public void setMembershipProvider(MembershipProvider membershipProvider) {
        this.membershipProvider = membershipProvider;
    }

    @Override
    public int getConnectTimeout() {
        return Integer.parseInt(this.properties.getProperty("connectTimeout", "1000"));
    }

    public void setConnectTimeout(int n) {
        this.properties.setProperty("connectTimeout", String.valueOf(n));
    }

    @Override
    public int getReadTimeout() {
        return Integer.parseInt(this.properties.getProperty("readTimeout", "1000"));
    }

    public void setReadTimeout(int n) {
        this.properties.setProperty("readTimeout", String.valueOf(n));
    }

    @Override
    public long getExpirationTime() {
        return Long.parseLong(this.properties.getProperty("expirationTime", "5000"));
    }

    public void setExpirationTime(long l) {
        this.properties.setProperty("expirationTime", String.valueOf(l));
    }
}

