/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXServiceURL;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.HeapHistogram;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasupport.DataRemovedListener;
import org.graalvm.visualvm.jmx.impl.JmxApplication;
import org.graalvm.visualvm.jmx.impl.JmxSupport;
import org.graalvm.visualvm.jmx.impl.ProxyClient;
import org.graalvm.visualvm.tools.attach.AttachModelFactory;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModel;
import org.graalvm.visualvm.tools.jvmstat.JvmJvmstatModelFactory;
import org.graalvm.visualvm.tools.jvmstat.JvmstatModel;

class JmxModelImpl
extends JmxModel {
    private static final Logger LOGGER = Logger.getLogger(JmxModelImpl.class.getName());
    private ProxyClient client;
    private ApplicationRemovedListener removedListener;
    private ApplicationAvailabilityListener availabilityListener;
    private JmxSupport jmxSupport;
    private final Object jmxSupportLock = new Object();

    JmxModelImpl(Application application, JvmstatModel jvmstat) {
        try {
            JvmJvmstatModel jvmstatModel = JvmJvmstatModelFactory.getJvmstatModelFor((Application)application);
            ProxyClient proxyClient = null;
            if (Application.CURRENT_APPLICATION.equals((Object)application)) {
                proxyClient = new ProxyClient(application);
            } else if (application.isLocalApplication()) {
                String connectorAddress = jvmstat.findByName("sun.management.JMXConnectorServer.address");
                String javaHome = jvmstat.findByName("java.property.java.home");
                LocalVirtualMachine lvm = new LocalVirtualMachine(application.getPid(), AttachModelFactory.getAttachFor((Application)application) != null, connectorAddress, javaHome);
                if (!lvm.isManageable()) {
                    if (lvm.isAttachable()) {
                        proxyClient = new ProxyClient(application, lvm);
                    } else if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("The JMX management agent cannot be enabled in this application (pid " + application.getPid() + ")");
                    }
                } else {
                    proxyClient = new ProxyClient(application, lvm);
                }
            }
            if (proxyClient == null) {
                List urls = jvmstat.findByPattern("sun.management.JMXConnectorServer.[0-9]+.remoteAddress");
                if (!urls.isEmpty()) {
                    List auths = jvmstat.findByPattern("sun.management.JMXConnectorServer.[0-9]+.authenticate");
                    proxyClient = new ProxyClient(application, (String)urls.get(0));
                    if ("true".equals(auths.get(0))) {
                        proxyClient.supplyCredentials();
                    }
                } else {
                    String jvmArgs = jvmstatModel.getJvmArgs();
                    StringTokenizer st = new StringTokenizer(jvmArgs);
                    int port = -1;
                    boolean authenticate = false;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (token.startsWith("-Dcom.sun.management.jmxremote.port=")) {
                            port = Integer.parseInt(token.substring(token.indexOf("=") + 1));
                            continue;
                        }
                        if (!token.equals("-Dcom.sun.management.jmxremote.authenticate=true")) continue;
                        authenticate = true;
                    }
                    if (port != -1) {
                        proxyClient = new ProxyClient(application, port);
                        if (authenticate) {
                            proxyClient.supplyCredentials();
                        }
                    }
                }
            }
            if (proxyClient != null) {
                this.client = proxyClient;
                this.removedListener = new ApplicationRemovedListener();
                this.availabilityListener = new ApplicationAvailabilityListener();
                proxyClient.connect();
                proxyClient.addConnectionStateListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        JmxModelImpl.this.propertyChangeSupport.firePropertyChange("connectionState", evt.getOldValue(), evt.getNewValue());
                    }
                });
                application.notifyWhenRemoved((DataRemovedListener)this.removedListener);
                if (this.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
                    application.addPropertyChangeListener("prop_state", (PropertyChangeListener)this.availabilityListener);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failed to create JmxModelImpl", e);
            this.client = null;
        }
    }

    JmxModelImpl(JmxApplication application) {
        try {
            this.client = application.getProxyClient();
            this.removedListener = new ApplicationRemovedListener();
            this.availabilityListener = new ApplicationAvailabilityListener();
            if (this.client == null) {
                this.client = new ProxyClient(application);
                this.client.connect();
            }
            this.client.addConnectionStateListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    JmxModelImpl.this.propertyChangeSupport.firePropertyChange("connectionState", evt.getOldValue(), evt.getNewValue());
                }
            });
            application.notifyWhenRemoved(this.removedListener);
            if (this.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
                application.addPropertyChangeListener("prop_state", this.availabilityListener);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failed to create JmxModelImpl", e);
            this.client = null;
        }
    }

    public JmxModel.ConnectionState getConnectionState() {
        if (this.client != null) {
            return this.client.getConnectionState();
        }
        return JmxModel.ConnectionState.DISCONNECTED;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        if (this.client != null) {
            return this.client.getMBeanServerConnection();
        }
        return null;
    }

    public JMXServiceURL getJMXServiceURL() {
        if (this.client != null) {
            return this.client.getUrl();
        }
        return null;
    }

    public Properties getSystemProperties() {
        return this.getJmxSupport().getSystemProperties();
    }

    public boolean takeHeapDump(String fileName) {
        return this.getJmxSupport().takeHeapDump(fileName);
    }

    public String takeThreadDump() {
        return this.getJmxSupport().takeThreadDump();
    }

    public String takeThreadDump(long[] threadIds) {
        return this.getJmxSupport().takeThreadDump(threadIds);
    }

    public HeapHistogram takeHeapHistogram() {
        return this.getJmxSupport().takeHeapHistogram();
    }

    public String getFlagValue(String name) {
        return this.getJmxSupport().getFlagValue(name);
    }

    public void setFlagValue(String name, String value) {
        this.getJmxSupport().setFlagValue(name, value);
    }

    public boolean isTakeHeapDumpSupported() {
        JmxSupport support = this.getJmxSupport();
        return support.getHotSpotDiagnostic() != null && !support.isReadOnlyConnection();
    }

    public boolean isTakeThreadDumpSupported() {
        JmxSupport support = this.getJmxSupport();
        return support.getThreadBean() != null && !support.isReadOnlyConnection();
    }

    public boolean isJfrAvailable() {
        JmxSupport support = this.getJmxSupport();
        if (support.isReadOnlyConnection()) {
            return false;
        }
        return support.isJfrAvailable();
    }

    public List<Long> jfrCheck() {
        JmxSupport support = this.getJmxSupport();
        if (support.isReadOnlyConnection()) {
            return Collections.EMPTY_LIST;
        }
        return support.jfrCheck();
    }

    public String takeJfrDump(long recording, String fileName) {
        JmxSupport support = this.getJmxSupport();
        if (support.isReadOnlyConnection()) {
            return null;
        }
        return support.takeJfrDump(recording, fileName);
    }

    public boolean startJfrRecording(String name, String[] settings, String delay, String duration, Boolean disk, String path, String maxAge, String maxSize, Boolean dumpOnExit) {
        JmxSupport support = this.getJmxSupport();
        if (support.isReadOnlyConnection()) {
            return false;
        }
        return support.startJfrRecording(name, settings, delay, duration, disk, path, maxAge, maxSize, dumpOnExit);
    }

    public boolean stopJfrRecording() {
        JmxSupport support = this.getJmxSupport();
        if (support.isReadOnlyConnection()) {
            return false;
        }
        return support.stopJfrRecording();
    }

    public String getCommandLine() {
        JmxSupport support = this.getJmxSupport();
        if (support.isReadOnlyConnection()) {
            return null;
        }
        return support.getCommandLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JmxSupport getJmxSupport() {
        Object object = this.jmxSupportLock;
        synchronized (object) {
            if (this.jmxSupport == null) {
                this.jmxSupport = new JmxSupport(this);
            }
            return this.jmxSupport;
        }
    }

    static class LocalVirtualMachine {
        private int vmid;
        private boolean isAttachSupported;
        private String javaHome;
        private volatile String address;
        private static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";

        LocalVirtualMachine(int vmid, boolean canAttach, String connectorAddress, String home) {
            this.vmid = vmid;
            this.address = connectorAddress;
            this.isAttachSupported = canAttach;
            this.javaHome = home;
        }

        public int vmid() {
            return this.vmid;
        }

        public synchronized boolean isManageable() {
            return this.address != null;
        }

        public boolean isAttachable() {
            return this.isAttachSupported;
        }

        public synchronized void startManagementAgent() throws IOException {
            if (this.address != null) {
                return;
            }
            if (!this.isAttachable()) {
                throw new IOException("This virtual machine \"" + this.vmid + "\" does not support dynamic attach.");
            }
            this.loadManagementAgent();
            if (this.address == null) {
                throw new IOException("Fails to find connector address");
            }
        }

        public synchronized String connectorAddress() {
            return this.address;
        }

        private synchronized void loadManagementAgent() throws IOException {
            VirtualMachine vm = null;
            String name = String.valueOf(this.vmid);
            try {
                vm = VirtualMachine.attach(name);
            }
            catch (AttachNotSupportedException x) {
                throw new IOException(x);
            }
            this.address = this.loadManagementAgentViaJcmd(vm);
            if (this.address == null) {
                this.loadManagementAgentViaJar(vm);
                Properties agentProps = vm.getAgentProperties();
                this.address = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
            }
            vm.detach();
        }

        private void loadManagementAgentViaJar(VirtualMachine vm) throws IOException {
            String agent = this.javaHome + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
            File f = new File(agent);
            if (!f.exists() && !(f = new File(agent = this.javaHome + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
                throw new IOException("Management agent not found");
            }
            agent = f.getCanonicalPath();
            try {
                vm.loadAgent(agent, "com.sun.management.jmxremote");
            }
            catch (AgentLoadException x) {
                throw new IOException(x);
            }
            catch (AgentInitializationException x) {
                throw new IOException(x);
            }
        }

        private String loadManagementAgentViaJcmd(VirtualMachine vm) {
            try {
                return vm.startLocalManagementAgent();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "startLocalManagementAgent for PID " + this.vmid + " failed", ex);
                return null;
            }
        }
    }

    private static class CheckerInvocationHandler
    implements InvocationHandler {
        private final MBeanServerConnection conn;

        CheckerInvocationHandler(MBeanServerConnection conn) {
            this.conn = conn;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (LOGGER.isLoggable(Level.FINE) && EventQueue.isDispatchThread()) {
                Throwable thrwbl = new Throwable();
                LOGGER.log(Level.FINE, this.createTracedMessage("MBeanServerConnection call performed on Event Dispatch Thread!", thrwbl));
            }
            try {
                return method.invoke((Object)this.conn, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private String createTracedMessage(String message, Throwable thrwbl) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            pw.println(message);
            thrwbl.printStackTrace(pw);
            pw.flush();
            return baos.toString();
        }
    }

    static class Checker {
        private Checker() {
        }

        public static MBeanServerConnection newChecker(ProxyClient client, MBeanServerConnection mbsc) {
            CheckerInvocationHandler ih = new CheckerInvocationHandler(mbsc);
            return (MBeanServerConnection)Proxy.newProxyInstance(Checker.class.getClassLoader(), new Class[]{MBeanServerConnection.class}, (InvocationHandler)ih);
        }
    }

    private class ApplicationAvailabilityListener
    implements PropertyChangeListener {
        private ApplicationAvailabilityListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getNewValue().equals(1)) {
                ((Application)evt.getSource()).removePropertyChangeListener("prop_state", (PropertyChangeListener)this);
                JmxModelImpl.this.client.disconnectImpl(false);
                JmxModelImpl.this.availabilityListener = null;
            }
        }
    }

    private class ApplicationRemovedListener
    implements DataRemovedListener<Application> {
        private ApplicationRemovedListener() {
        }

        public void dataRemoved(Application application) {
            VisualVM.getInstance().runTask(new Runnable(){

                @Override
                public void run() {
                    JmxModelImpl.this.client.markAsDead();
                    JmxModelImpl.this.removedListener = null;
                }
            });
        }
    }
}

