/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.VMOption;
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.graalvm.visualvm.application.jvm.HeapHistogram;
import org.graalvm.visualvm.jmx.impl.HeapHistogramImpl;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JvmMXBeans;
import org.graalvm.visualvm.tools.jmx.JvmMXBeansFactory;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;

public class JmxSupport {
    private static final Logger LOGGER = Logger.getLogger(JmxSupport.class.getName());
    private static final String HOTSPOT_DIAGNOSTIC_MXBEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final String DIAGNOSTIC_COMMAND_MXBEAN_NAME = "com.sun.management:type=DiagnosticCommand";
    private static final String ALL_OBJECTS_OPTION = "-all";
    private static final String HISTOGRAM_COMMAND = "gcClassHistogram";
    private static final String CMDLINE_COMMAND = "vmCommandLine";
    private static final String CMDLINE_PREFIX = "java_command: ";
    private static final String JCMD_JFR_DUMP = "jfrDump";
    private static final String JCMD_JFR_DUMP_FILENAME = "filename";
    private static final String JCMD_JFR_DUMP_RECORDING = "recording";
    private static final String JCMD_JFR_DUMP_NAME = "name";
    private static final String JCMD_JFR_CHECK = "jfrCheck";
    private static final String JCMD_JFR_CHECK_RECORDING_ID = "recording=";
    private static final String JCMD_JFR_CHECK_RECORDING_ID1 = "Recording ";
    private static final String JCMD_JFR_CHECK_HELP_OPTIONS_ID = "Options: ";
    private static final String JCMD_JFR_CHECK_HELP_RECORDING_ID = "recording : ";
    private static final String JCMD_JFR_START = "jfrStart";
    private static final String JCMD_JFR_START_NAME = "name";
    private static final String JCMD_JFR_START_SETTINGS = "settings";
    private static final String JCMD_JFR_START_DELAY = "delay";
    private static final String JCMD_JFR_START_DURATION = "duration";
    private static final String JCMD_JFR_START_DISK = "disk";
    private static final String JCMD_JFR_START_FILENAME = "filename";
    private static final String JCMD_JFR_START_MAXAGE = "maxage";
    private static final String JCMD_JFR_START_MAXSIZE = "maxsize";
    private static final String JCMD_JFR_START_DUMPONEXIT = "dumponexit";
    private static final String JCMD_JFR_STOP = "jfrStop";
    private static final String JCMD_JFR_STOP_NAME = "name";
    private static final String JCMD_JFR_UNLOCK_ID = "Use VM.unlock_commercial_features to enable";
    private static final String JCMD_UNLOCK_CF = "vmUnlockCommercialFeatures";
    private static final String JCMD_HELP = "help";
    private static final String JCMD_CF_ID = " unlocked.";
    private static final Map EMPTY_PARS = Collections.singletonMap("", null);
    private JvmMXBeans mxbeans;
    private JmxModel jmxModel;
    private boolean hotspotDiagnosticInitialized;
    private final Object hotspotDiagnosticLock = new Object();
    private HotSpotDiagnosticMXBean hotspotDiagnosticMXBean;
    private final Object readOnlyConnectionLock = new Object();
    private Boolean readOnlyConnection;
    private Boolean hasDumpAllThreads;
    private final Object hasDumpAllThreadsLock = new Object();
    private Boolean jfrAvailable;
    private Boolean oldJFR;
    private String commandLine;
    private final Object commandLineLock = new Object();

    JmxSupport(JmxModel jmx) {
        this.jmxModel = jmx;
    }

    private RuntimeMXBean getRuntime() {
        JvmMXBeans jmx = this.getJvmMXBeans();
        if (jmx != null) {
            return jmx.getRuntimeMXBean();
        }
        return null;
    }

    private synchronized JvmMXBeans getJvmMXBeans() {
        if (this.mxbeans == null && this.jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
            this.mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)this.jmxModel);
        }
        return this.mxbeans;
    }

    Properties getSystemProperties() {
        try {
            RuntimeMXBean runtime = this.getRuntime();
            if (runtime != null) {
                Properties prop = new Properties();
                prop.putAll(runtime.getSystemProperties());
                return prop;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "getSystemProperties", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean isReadOnlyConnection() {
        Object object = this.readOnlyConnectionLock;
        synchronized (object) {
            if (this.readOnlyConnection == null) {
                this.readOnlyConnection = Boolean.FALSE;
                ThreadMXBean threads = this.getThreadBean();
                if (threads != null) {
                    try {
                        threads.getThreadInfo(1L);
                    }
                    catch (SecurityException ex) {
                        this.readOnlyConnection = Boolean.TRUE;
                    }
                }
            }
            return this.readOnlyConnection;
        }
    }

    ThreadMXBean getThreadBean() {
        JvmMXBeans jmx = this.getJvmMXBeans();
        if (jmx != null) {
            return jmx.getThreadMXBean();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HotSpotDiagnosticMXBean getHotSpotDiagnostic() {
        Object object = this.hotspotDiagnosticLock;
        synchronized (object) {
            if (this.hotspotDiagnosticInitialized) {
                return this.hotspotDiagnosticMXBean;
            }
            JvmMXBeans jmx = this.getJvmMXBeans();
            if (jmx != null) {
                try {
                    this.hotspotDiagnosticMXBean = (HotSpotDiagnosticMXBean)jmx.getMXBean(ObjectName.getInstance(HOTSPOT_DIAGNOSTIC_MXBEAN_NAME), HotSpotDiagnosticMXBean.class);
                }
                catch (MalformedObjectNameException e) {
                    ErrorManager.getDefault().log(16, "Couldn't find HotSpotDiagnosticMXBean: " + e.getLocalizedMessage());
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            this.hotspotDiagnosticInitialized = true;
            return this.hotspotDiagnosticMXBean;
        }
    }

    String takeThreadDump(long[] threadIds) {
        try {
            ThreadMXBean threadMXBean = this.getThreadBean();
            if (threadMXBean == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder(4096);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ThreadInfo[] threads = this.hasDumpAllThreads() ? threadMXBean.getThreadInfo(threadIds, true, true) : threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
            sb.append(df.format(new Date()) + "\n");
            this.printThreads(sb, threadMXBean, threads);
            return sb.toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "takeThreadDump[]", e);
            return null;
        }
    }

    String takeThreadDump() {
        try {
            ThreadInfo[] threads;
            ThreadMXBean threadMXBean = this.getThreadBean();
            if (threadMXBean == null) {
                return null;
            }
            Properties prop = this.getSystemProperties();
            StringBuilder sb = new StringBuilder(4096);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sb.append(df.format(new Date()) + "\n");
            sb.append("Full thread dump " + prop.getProperty("java.vm.name") + " (" + prop.getProperty("java.vm.version") + " " + prop.getProperty("java.vm.info") + "):\n");
            if (this.hasDumpAllThreads()) {
                threads = threadMXBean.dumpAllThreads(true, true);
            } else {
                long[] threadIds = threadMXBean.getAllThreadIds();
                threads = threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
            }
            this.printThreads(sb, threadMXBean, threads);
            return sb.toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "takeThreadDump", e);
            return null;
        }
    }

    private void printThreads(StringBuilder sb, ThreadMXBean threadMXBean, ThreadInfo[] threads) {
        boolean jdk16 = this.hasDumpAllThreads();
        for (ThreadInfo thread : threads) {
            if (thread == null) continue;
            if (jdk16) {
                this.print16Thread(sb, threadMXBean, thread);
                continue;
            }
            this.print15Thread(sb, thread);
        }
    }

    private void print16Thread(StringBuilder sb, ThreadMXBean threadMXBean, ThreadInfo thread) {
        MonitorInfo[] monitors = null;
        if (threadMXBean.isObjectMonitorUsageSupported()) {
            monitors = thread.getLockedMonitors();
        }
        sb.append("\n\"" + thread.getThreadName() + "\" - Thread t@" + thread.getThreadId() + "\n");
        sb.append("   java.lang.Thread.State: " + (Object)((Object)thread.getThreadState()));
        sb.append("\n");
        int index = 0;
        for (StackTraceElement st : thread.getStackTrace()) {
            LockInfo lock = thread.getLockInfo();
            String lockOwner = thread.getLockOwnerName();
            sb.append("\tat " + st.toString() + "\n");
            if (index == 0) {
                if ("java.lang.Object".equals(st.getClassName()) && "wait".equals(st.getMethodName())) {
                    if (lock != null) {
                        sb.append("\t- waiting on ");
                        this.printLock(sb, lock);
                        sb.append("\n");
                    }
                } else if (lock != null) {
                    if (lockOwner == null) {
                        sb.append("\t- parking to wait for ");
                        this.printLock(sb, lock);
                        sb.append("\n");
                    } else {
                        sb.append("\t- waiting to lock ");
                        this.printLock(sb, lock);
                        sb.append(" owned by \"" + lockOwner + "\" t@" + thread.getLockOwnerId() + "\n");
                    }
                }
            }
            this.printMonitors(sb, monitors, index);
            ++index;
        }
        StringBuilder jnisb = new StringBuilder();
        this.printMonitors(jnisb, monitors, -1);
        if (jnisb.length() > 0) {
            sb.append("   JNI locked monitors:\n");
            sb.append((CharSequence)jnisb);
        }
        if (threadMXBean.isSynchronizerUsageSupported()) {
            sb.append("\n   Locked ownable synchronizers:");
            LockInfo[] synchronizers = thread.getLockedSynchronizers();
            if (synchronizers == null || synchronizers.length == 0) {
                sb.append("\n\t- None\n");
            } else {
                for (LockInfo li : synchronizers) {
                    sb.append("\n\t- locked ");
                    this.printLock(sb, li);
                    sb.append("\n");
                }
            }
        }
    }

    private void printMonitors(StringBuilder sb, MonitorInfo[] monitors, int index) {
        if (monitors != null) {
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != index) continue;
                sb.append("\t- locked ");
                this.printLock(sb, mi);
                sb.append("\n");
            }
        }
    }

    private void print15Thread(StringBuilder sb, ThreadInfo thread) {
        sb.append("\n\"" + thread.getThreadName() + "\" - Thread t@" + thread.getThreadId() + "\n");
        sb.append("   java.lang.Thread.State: " + (Object)((Object)thread.getThreadState()));
        if (thread.getLockName() != null) {
            sb.append(" on " + thread.getLockName());
            if (thread.getLockOwnerName() != null) {
                sb.append(" owned by: " + thread.getLockOwnerName());
            }
        }
        sb.append("\n");
        for (StackTraceElement st : thread.getStackTrace()) {
            sb.append("        at " + st.toString() + "\n");
        }
    }

    private void printLock(StringBuilder sb, LockInfo lock) {
        String id = Integer.toHexString(lock.getIdentityHashCode());
        String className = lock.getClassName();
        sb.append("<" + id + "> (a " + className + ")");
    }

    boolean takeHeapDump(String fileName) {
        HotSpotDiagnosticMXBean hsDiagnostic = this.getHotSpotDiagnostic();
        if (hsDiagnostic != null) {
            Path f = Paths.get(fileName, new String[0]);
            try {
                hsDiagnostic.dumpHeap(fileName, true);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "takeHeapDump", ex);
                try {
                    Files.deleteIfExists(f);
                }
                catch (IOException ex1) {
                    LOGGER.log(Level.INFO, "takeHeapDump", ex1);
                }
                return false;
            }
            return Files.isRegularFile(f, LinkOption.NOFOLLOW_LINKS) && Files.isReadable(f);
        }
        return false;
    }

    String getFlagValue(String name) {
        try {
            VMOption option;
            HotSpotDiagnosticMXBean hsDiagnostic = this.getHotSpotDiagnostic();
            if (hsDiagnostic != null && (option = hsDiagnostic.getVMOption(name)) != null) {
                return option.getValue();
            }
            return null;
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.FINE, "getFlagValue", ex);
            return null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "getFlagValue", ex);
            return null;
        }
    }

    HeapHistogram takeHeapHistogram() {
        String histo = this.executeJCmd(HISTOGRAM_COMMAND, Collections.singletonMap(ALL_OBJECTS_OPTION, null));
        if (histo != null) {
            return new HeapHistogramImpl(histo);
        }
        return null;
    }

    void setFlagValue(String name, String value) {
        try {
            HotSpotDiagnosticMXBean hsDiagnostic = this.getHotSpotDiagnostic();
            if (hsDiagnostic != null) {
                hsDiagnostic.setVMOption(name, value);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "setFlagValue", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDumpAllThreads() {
        Object object = this.hasDumpAllThreadsLock;
        synchronized (object) {
            if (this.hasDumpAllThreads == null) {
                this.hasDumpAllThreads = Boolean.FALSE;
                try {
                    ObjectName threadObjName = new ObjectName("java.lang:type=Threading");
                    MBeanInfo threadInfo = this.jmxModel.getMBeanServerConnection().getMBeanInfo(threadObjName);
                    if (threadInfo != null) {
                        for (MBeanOperationInfo op : threadInfo.getOperations()) {
                            if (!"dumpAllThreads".equals(op.getName())) continue;
                            this.hasDumpAllThreads = Boolean.TRUE;
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "hasDumpAllThreads", ex);
                }
            }
            return this.hasDumpAllThreads;
        }
    }

    synchronized boolean isJfrAvailable() {
        if (this.jfrAvailable == null) {
            String recordings = this.getJfrCheck();
            this.jfrAvailable = recordings == null ? Boolean.FALSE : (recordings.contains(JCMD_JFR_UNLOCK_ID) ? Boolean.valueOf(this.unlockCommercialFeature()) : Boolean.TRUE);
            if (Boolean.TRUE.equals(this.jfrAvailable)) {
                this.oldJFR = this.checkForOldJFR();
            }
        }
        return this.jfrAvailable;
    }

    List<Long> jfrCheck() {
        if (!this.isJfrAvailable()) {
            throw new UnsupportedOperationException();
        }
        String recordings = this.getJfrCheck();
        if (recordings == null) {
            return Collections.EMPTY_LIST;
        }
        String[] lines = recordings.split("\\r?\\n");
        ArrayList<Long> recNumbers = new ArrayList<Long>(lines.length);
        for (String line : lines) {
            String recordingNum;
            int recEnd;
            int recStart;
            int index = line.indexOf(JCMD_JFR_CHECK_RECORDING_ID);
            if (index >= 0) {
                recStart = index + JCMD_JFR_CHECK_RECORDING_ID.length();
                recEnd = line.indexOf(32, recStart);
                if (recEnd <= recStart) continue;
                recordingNum = line.substring(recStart, recEnd);
                recNumbers.add(Long.valueOf(recordingNum));
                continue;
            }
            if (!line.startsWith(JCMD_JFR_CHECK_RECORDING_ID1) || (recEnd = line.indexOf(58, recStart = JCMD_JFR_CHECK_RECORDING_ID1.length())) <= recStart) continue;
            recordingNum = line.substring(recStart, recEnd);
            recNumbers.add(Long.valueOf(recordingNum));
        }
        return recNumbers;
    }

    String takeJfrDump(long recording, String fileName) {
        if (!this.isJfrAvailable()) {
            throw new UnsupportedOperationException();
        }
        HashMap<String, Object> pars = new HashMap<String, Object>();
        pars.put("filename", fileName);
        pars.put(this.oldJFR != false ? JCMD_JFR_DUMP_RECORDING : "name", recording);
        return this.executeJCmd(JCMD_JFR_DUMP, pars);
    }

    boolean startJfrRecording(String name, String[] settings, String delay, String duration, Boolean disk, String path, String maxAge, String maxSize, Boolean dumpOnExit) {
        if (!this.isJfrAvailable()) {
            throw new UnsupportedOperationException();
        }
        HashMap<String, Object> pars = new HashMap<String, Object>();
        if (name != null) {
            pars.put("name", name);
        }
        if (settings != null) {
            for (String setting : settings) {
                pars.put(JCMD_JFR_START_SETTINGS, setting);
            }
        }
        if (delay != null) {
            pars.put(JCMD_JFR_START_DELAY, delay);
        }
        if (duration != null) {
            pars.put(JCMD_JFR_START_DURATION, duration);
        }
        if (maxAge != null) {
            pars.put(JCMD_JFR_START_MAXAGE, maxAge);
        }
        if (maxSize != null) {
            pars.put(JCMD_JFR_START_MAXSIZE, maxSize);
        }
        if (dumpOnExit != null) {
            pars.put(JCMD_JFR_START_DUMPONEXIT, dumpOnExit);
        }
        if (path != null) {
            pars.put("filename", path);
        }
        if (disk != null && !this.oldJFR.booleanValue()) {
            pars.put(JCMD_JFR_START_DISK, disk);
        }
        if (pars.isEmpty()) {
            pars = EMPTY_PARS;
        }
        this.executeJCmd(JCMD_JFR_START, pars);
        return true;
    }

    boolean stopJfrRecording() {
        if (!this.isJfrAvailable()) {
            throw new UnsupportedOperationException();
        }
        String recKey = this.oldJFR != false ? JCMD_JFR_DUMP_RECORDING : "name";
        for (Long recording : this.jfrCheck()) {
            Map<String, Object> pars = Collections.singletonMap(recKey, recording);
            this.executeJCmd(JCMD_JFR_STOP, pars);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCommandLine() {
        Object object = this.commandLineLock;
        synchronized (object) {
            if (this.commandLine == null) {
                String vmCommandLine = this.executeJCmd(CMDLINE_COMMAND);
                if (vmCommandLine != null) {
                    this.commandLine = this.parseVMCommandLine(vmCommandLine);
                }
                return null;
            }
            return this.commandLine;
        }
    }

    private String getJfrCheck() {
        return this.executeJCmd(JCMD_JFR_CHECK, EMPTY_PARS);
    }

    private boolean checkForOldJFR() {
        String ret = this.getJCmdHelp(JCMD_JFR_CHECK);
        if (ret != null) {
            int options = ret.indexOf(JCMD_JFR_CHECK_HELP_OPTIONS_ID);
            int recording = ret.indexOf(JCMD_JFR_CHECK_HELP_RECORDING_ID);
            return options != -1 && options < recording;
        }
        return false;
    }

    private boolean unlockCommercialFeature() {
        String ret = this.executeJCmd(JCMD_UNLOCK_CF);
        return ret.contains(JCMD_CF_ID);
    }

    private String getJCmdHelp(String command) {
        Map<String, Object> pars = Collections.singletonMap(command, null);
        return this.executeJCmd(JCMD_HELP, pars);
    }

    private String executeJCmd(String command) {
        return this.executeJCmd(command, Collections.EMPTY_MAP);
    }

    private String executeJCmd(String command, Map<String, Object> pars) {
        if (this.jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
            MBeanServerConnection conn = this.jmxModel.getMBeanServerConnection();
            try {
                ObjectName diagCommName = new ObjectName(DIAGNOSTIC_COMMAND_MXBEAN_NAME);
                if (conn.isRegistered(diagCommName)) {
                    Object ret;
                    Object[] params = null;
                    String[] signature = null;
                    if (!pars.isEmpty()) {
                        params = new Object[]{JmxSupport.getJCmdParams(pars)};
                        signature = new String[]{String[].class.getName()};
                    }
                    if ((ret = conn.invoke(diagCommName, command, params, signature)) instanceof String) {
                        return (String)ret;
                    }
                }
            }
            catch (MalformedObjectNameException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "executeJCmd", ex);
            }
            catch (InstanceNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (MBeanException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ReflectionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private String parseVMCommandLine(String vmCommandLine) {
        String[] lines;
        for (String line : lines = vmCommandLine.split("\\r?\\n")) {
            if (!line.startsWith(CMDLINE_PREFIX)) continue;
            return line.substring(CMDLINE_PREFIX.length());
        }
        return null;
    }

    private static String[] getJCmdParams(Map<String, Object> pars) {
        String[] jcmdParams = new String[pars.size()];
        int i = 0;
        for (Map.Entry<String, Object> e : pars.entrySet()) {
            String key = e.getKey();
            Object val = e.getValue();
            String par = val == null ? key : String.format("%s=%s", key, JmxSupport.quoteString(val.toString()));
            jcmdParams[i++] = par;
        }
        return jcmdParams;
    }

    private static String quoteString(String val) {
        if (val.indexOf(32) >= 0) {
            return "\"" + val + "\"";
        }
        return val;
    }
}

