/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.reactive.context;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.web.reactive.context.ConfigurableReactiveWebApplicationContext;
import org.springframework.boot.web.reactive.context.FilteredReactiveWebContextResource;
import org.springframework.boot.web.reactive.context.StandardReactiveWebEnvironment;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AnnotationConfigReactiveWebApplicationContext
extends AbstractRefreshableConfigApplicationContext
implements ConfigurableReactiveWebApplicationContext,
AnnotationConfigRegistry {
    private BeanNameGenerator beanNameGenerator;
    private ScopeMetadataResolver scopeMetadataResolver;
    private final Set<Class<?>> annotatedClasses = new LinkedHashSet();
    private final Set<String> basePackages = new LinkedHashSet<String>();

    protected ConfigurableEnvironment createEnvironment() {
        return new StandardReactiveWebEnvironment();
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }

    protected BeanNameGenerator getBeanNameGenerator() {
        return this.beanNameGenerator;
    }

    public void setScopeMetadataResolver(ScopeMetadataResolver scopeMetadataResolver) {
        this.scopeMetadataResolver = scopeMetadataResolver;
    }

    protected ScopeMetadataResolver getScopeMetadataResolver() {
        return this.scopeMetadataResolver;
    }

    public void register(Class<?> ... annotatedClasses) {
        Assert.notEmpty((Object[])annotatedClasses, (String)"At least one annotated class must be specified");
        this.annotatedClasses.addAll(Arrays.asList(annotatedClasses));
    }

    public void scan(String ... basePackages) {
        Assert.notEmpty((Object[])basePackages, (String)"At least one base package must be specified");
        this.basePackages.addAll(Arrays.asList(basePackages));
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) {
        AnnotatedBeanDefinitionReader reader = this.getAnnotatedBeanDefinitionReader(beanFactory);
        ClassPathBeanDefinitionScanner scanner = this.getClassPathBeanDefinitionScanner(beanFactory);
        this.applyBeanNameGenerator(beanFactory, reader, scanner);
        this.applyScopeMetadataResolver(reader, scanner);
        this.loadBeanDefinitions(reader, scanner);
    }

    private void applyBeanNameGenerator(DefaultListableBeanFactory beanFactory, AnnotatedBeanDefinitionReader reader, ClassPathBeanDefinitionScanner scanner) {
        BeanNameGenerator beanNameGenerator = this.getBeanNameGenerator();
        if (beanNameGenerator != null) {
            reader.setBeanNameGenerator(beanNameGenerator);
            scanner.setBeanNameGenerator(beanNameGenerator);
            beanFactory.registerSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator", (Object)beanNameGenerator);
        }
    }

    private void applyScopeMetadataResolver(AnnotatedBeanDefinitionReader reader, ClassPathBeanDefinitionScanner scanner) {
        ScopeMetadataResolver scopeMetadataResolver = this.getScopeMetadataResolver();
        if (scopeMetadataResolver != null) {
            reader.setScopeMetadataResolver(scopeMetadataResolver);
            scanner.setScopeMetadataResolver(scopeMetadataResolver);
        }
    }

    private void loadBeanDefinitions(AnnotatedBeanDefinitionReader reader, ClassPathBeanDefinitionScanner scanner) throws LinkageError {
        String[] configLocations;
        if (!this.annotatedClasses.isEmpty()) {
            this.registerAnnotatedClasses(reader);
        }
        if (!this.basePackages.isEmpty()) {
            this.scanBasePackages(scanner);
        }
        if ((configLocations = this.getConfigLocations()) != null) {
            this.registerConfigLocations(reader, scanner, configLocations);
        }
    }

    private void registerAnnotatedClasses(AnnotatedBeanDefinitionReader reader) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Registering annotated classes: [" + StringUtils.collectionToCommaDelimitedString(this.annotatedClasses) + "]"));
        }
        reader.register(ClassUtils.toClassArray(this.annotatedClasses));
    }

    private void scanBasePackages(ClassPathBeanDefinitionScanner scanner) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Scanning base packages: [" + StringUtils.collectionToCommaDelimitedString(this.basePackages) + "]"));
        }
        scanner.scan(StringUtils.toStringArray(this.basePackages));
    }

    private void registerConfigLocations(AnnotatedBeanDefinitionReader reader, ClassPathBeanDefinitionScanner scanner, String[] configLocations) throws LinkageError {
        for (String configLocation : configLocations) {
            try {
                this.register(reader, configLocation);
            }
            catch (ClassNotFoundException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Could not load class for config location [" + configLocation + "] - trying package scan. " + ex));
                }
                int count = scanner.scan(new String[]{configLocation});
                if (!this.logger.isInfoEnabled()) continue;
                this.logScanResult(configLocation, count);
            }
        }
    }

    private void register(AnnotatedBeanDefinitionReader reader, String configLocation) throws ClassNotFoundException, LinkageError {
        Class clazz = ClassUtils.forName((String)configLocation, (ClassLoader)this.getClassLoader());
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Successfully resolved class for [" + configLocation + "]"));
        }
        reader.register(new Class[]{clazz});
    }

    private void logScanResult(String configLocation, int count) {
        if (count == 0) {
            this.logger.info((Object)("No annotated classes found for specified class/package [" + configLocation + "]"));
        } else {
            this.logger.info((Object)("Found " + count + " annotated classes in package [" + configLocation + "]"));
        }
    }

    protected AnnotatedBeanDefinitionReader getAnnotatedBeanDefinitionReader(DefaultListableBeanFactory beanFactory) {
        return new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)beanFactory, (Environment)this.getEnvironment());
    }

    protected ClassPathBeanDefinitionScanner getClassPathBeanDefinitionScanner(DefaultListableBeanFactory beanFactory) {
        return new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)beanFactory, true, (Environment)this.getEnvironment());
    }

    protected Resource getResourceByPath(String path) {
        return new FilteredReactiveWebContextResource(path);
    }
}

