/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.util.Disposer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class ExtensionPointUtil {
    @NotNull
    public static <T> Disposable createExtensionDisposable(@NotNull T extensionObject, @NotNull ExtensionPoint<T> extensionPoint) {
        if (extensionObject == null) {
            ExtensionPointUtil.$$$reportNull$$$0(5);
        }
        if (extensionPoint == null) {
            ExtensionPointUtil.$$$reportNull$$$0(6);
        }
        return ExtensionPointUtil.createExtensionDisposable(extensionObject, extensionPoint, removed2 -> removed2 == extensionObject);
    }

    @NotNull
    public static <T, U> Disposable createExtensionDisposable(@NotNull T extensionObject, @NotNull ExtensionPoint<U> extensionPoint, final @NotNull Predicate<U> removePredicate) {
        if (extensionObject == null) {
            ExtensionPointUtil.$$$reportNull$$$0(7);
        }
        if (extensionPoint == null) {
            ExtensionPointUtil.$$$reportNull$$$0(8);
        }
        if (removePredicate == null) {
            ExtensionPointUtil.$$$reportNull$$$0(9);
        }
        final Disposable disposable = ExtensionPointUtil.createDisposable(extensionObject, extensionPoint);
        extensionPoint.addExtensionPointListener(new ExtensionPointListener<U>(){

            @Override
            public void extensionRemoved(@NotNull U removedExtension, @NotNull PluginDescriptor pluginDescriptor) {
                if (removedExtension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (removePredicate.test(removedExtension)) {
                    Disposer.dispose(disposable);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "removedExtension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/extensions/ExtensionPointUtil$1";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, disposable);
        Disposable disposable2 = disposable;
        if (disposable2 == null) {
            ExtensionPointUtil.$$$reportNull$$$0(10);
        }
        return disposable2;
    }

    @NotNull
    private static <T> Disposable createDisposable(@NotNull T extensionObject, @NotNull ExtensionPoint<?> extensionPoint) {
        if (extensionObject == null) {
            ExtensionPointUtil.$$$reportNull$$$0(14);
        }
        if (extensionPoint == null) {
            ExtensionPointUtil.$$$reportNull$$$0(15);
        }
        Disposable disposable = Disposer.newDisposable("Disposable for [" + extensionObject + "]");
        ComponentManager manager = ((ExtensionPointImpl)extensionPoint).getComponentManager();
        Disposer.register(manager, disposable);
        Disposable disposable2 = disposable;
        if (disposable2 == null) {
            ExtensionPointUtil.$$$reportNull$$$0(16);
        }
        return disposable2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyValue";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/ExtensionPointUtil";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionObject";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removePredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/ExtensionPointUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "dropLazyValueOnChange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtensionDisposable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyedExtensionDisposable";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dropLazyValueOnChange";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 16: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createExtensionDisposable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createKeyedExtensionDisposable";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createDisposable";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

