/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationCheckerUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0007\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\t\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\n\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"expandedClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getConstructedClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "isAnnotationConstructor", "", "isEnumConstructor", "isPrimaryConstructorOfInlineClass", "checkers"})
public final class FirExpectActualDeclarationCheckerKt {
    public static final boolean isAnnotationConstructor(@NotNull FirBasedSymbol<?> $this$isAnnotationConstructor, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isAnnotationConstructor, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!($this$isAnnotationConstructor instanceof FirConstructorSymbol)) {
            return false;
        }
        FirRegularClassSymbol firRegularClassSymbol = FirExpectActualDeclarationCheckerKt.getConstructedClass((FirConstructorSymbol)$this$isAnnotationConstructor, session2);
        return (firRegularClassSymbol == null ? null : firRegularClassSymbol.getClassKind()) == ClassKind.ANNOTATION_CLASS;
    }

    public static final boolean isEnumConstructor(@NotNull FirBasedSymbol<?> $this$isEnumConstructor, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isEnumConstructor, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!($this$isEnumConstructor instanceof FirConstructorSymbol)) {
            return false;
        }
        FirRegularClassSymbol firRegularClassSymbol = FirExpectActualDeclarationCheckerKt.getConstructedClass((FirConstructorSymbol)$this$isEnumConstructor, session2);
        return (firRegularClassSymbol == null ? null : firRegularClassSymbol.getClassKind()) == ClassKind.ENUM_CLASS;
    }

    public static final boolean isPrimaryConstructorOfInlineClass(@NotNull FirBasedSymbol<?> $this$isPrimaryConstructorOfInlineClass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isPrimaryConstructorOfInlineClass, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!($this$isPrimaryConstructorOfInlineClass instanceof FirConstructorSymbol)) {
            return false;
        }
        FirRegularClassSymbol firRegularClassSymbol = FirExpectActualDeclarationCheckerKt.getConstructedClass((FirConstructorSymbol)$this$isPrimaryConstructorOfInlineClass, session2);
        return (firRegularClassSymbol == null ? false : FirDeclarationCheckerUtilsKt.isInlineOrValueClass(firRegularClassSymbol)) && ((FirConstructorSymbol)$this$isPrimaryConstructorOfInlineClass).isPrimary();
    }

    @Nullable
    public static final FirRegularClassSymbol getConstructedClass(@NotNull FirConstructorSymbol $this$getConstructedClass, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$getConstructedClass, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirBasedSymbol<?> firBasedSymbol = TypeUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType($this$getConstructedClass.getResolvedReturnTypeRef()), session2), session2);
        return firBasedSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol : null;
    }

    @Nullable
    public static final FirRegularClassSymbol expandedClass(@NotNull FirBasedSymbol<?> $this$expandedClass, @NotNull FirSession session2) {
        FirBasedSymbol<?> firBasedSymbol;
        Intrinsics.checkNotNullParameter($this$expandedClass, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirBasedSymbol<?> firBasedSymbol2 = $this$expandedClass;
        return firBasedSymbol2 instanceof FirTypeAliasSymbol ? ((firBasedSymbol = TypeUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(((FirTypeAliasSymbol)$this$expandedClass).getResolvedExpandedTypeRef()), session2), session2)) instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol : null) : (firBasedSymbol2 instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)$this$expandedClass : null);
    }
}

