/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerOperatorCall;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u0004\u0018\u00010\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u0004\u0018\u00010\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/EmptyRangeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "asLong", "", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirIntegerOperatorCall;", "getAsLong", "(Lorg/jetbrains/kotlin/fir/scopes/impl/FirIntegerOperatorCall;)Ljava/lang/Long;", "rangeLeft", "getRangeLeft", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Ljava/lang/Long;", "rangeRight", "getRangeRight", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class EmptyRangeChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final EmptyRangeChecker INSTANCE = new EmptyRangeChecker();

    private EmptyRangeChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean needReport;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (expression2.getSource() instanceof FirFakeSourceElement) {
            return;
        }
        Long l = this.getRangeLeft(expression2);
        if (l == null) {
            return;
        }
        long left = l;
        Long l2 = this.getRangeRight(expression2);
        if (l2 == null) {
            return;
        }
        long right = l2;
        switch (expression2.getCalleeReference().getName().asString()) {
            case "rangeTo": {
                boolean bl;
                if (left > right) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "downTo": {
                boolean bl;
                if (right > left) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "until": {
                boolean bl;
                if (left >= right) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = needReport = false;
            }
        }
        if (needReport) {
            DiagnosticReporterKt.reportOn$default(reporter, expression2.getSource(), FirErrors.INSTANCE.getEMPTY_RANGE(), context2, null, 8, null);
        }
    }

    private final Long getRangeLeft(FirFunctionCall $this$rangeLeft) {
        Long l;
        if ($this$rangeLeft.getExplicitReceiver() instanceof FirIntegerOperatorCall) {
            FirIntegerOperatorCall firIntegerOperatorCall;
            FirExpression firExpression2 = $this$rangeLeft.getExplicitReceiver();
            FirIntegerOperatorCall firIntegerOperatorCall2 = firIntegerOperatorCall = firExpression2 instanceof FirIntegerOperatorCall ? (FirIntegerOperatorCall)firExpression2 : null;
            l = firIntegerOperatorCall == null ? null : this.getAsLong(firIntegerOperatorCall);
        } else {
            FirExpression firExpression3 = $this$rangeLeft.getExplicitReceiver();
            FirConstExpression firConstExpression = firExpression3 instanceof FirConstExpression ? (FirConstExpression)firExpression3 : null;
            Object var2_5 = firConstExpression == null ? null : firConstExpression.getValue();
            l = var2_5 instanceof Long ? (Long)var2_5 : null;
        }
        return l;
    }

    private final Long getRangeRight(FirFunctionCall $this$rangeRight) {
        Long l;
        FirExpression arg = CollectionsKt.getOrNull($this$rangeRight.getArgumentList().getArguments(), 0);
        if (arg instanceof FirIntegerOperatorCall) {
            l = this.getAsLong((FirIntegerOperatorCall)arg);
        } else {
            FirConstExpression firConstExpression = arg instanceof FirConstExpression ? (FirConstExpression)arg : null;
            Object var3_4 = firConstExpression == null ? null : firConstExpression.getValue();
            l = var3_4 instanceof Long ? (Long)var3_4 : null;
        }
        return l;
    }

    private final Long getAsLong(FirIntegerOperatorCall $this$asLong) {
        FirExpression firExpression2 = $this$asLong.getDispatchReceiver();
        FirConstExpression firConstExpression = firExpression2 instanceof FirConstExpression ? (FirConstExpression)firExpression2 : null;
        Long l = firConstExpression == null ? null : firConstExpression.getValue();
        if (l == null) {
            return null;
        }
        long value2 = l;
        if (Intrinsics.areEqual($this$asLong.getCalleeReference().getName().asString(), "unaryMinus")) {
            return -value2;
        }
        return value2;
    }
}

