/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

abstract class GdaJValue {
    protected long cnc_c_pointer = 0L;
    protected int gda_row_column = -1;
    protected boolean convert_lc = false;
    protected boolean no_null = false;

    GdaJValue() {
    }

    private static native void initIDs();

    native void setCString(long var1, int var3, String var4);

    native void setCInt(long var1, int var3, int var4);

    native void setCChar(long var1, int var3, byte var4);

    native void setCDouble(long var1, int var3, double var4);

    native void setCFloat(long var1, int var3, float var4);

    native void setCLong(long var1, int var3, long var4);

    native void setCShort(long var1, int var3, short var4);

    native void setCBoolean(long var1, int var3, boolean var4);

    native void setCDate(long var1, int var3, int var4, int var5, int var6);

    native void setCTime(long var1, int var3, int var4, int var5, int var6);

    native void setCTimestamp(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    native void setCBinary(long var1, int var3, byte[] var4);

    native void setCBlob(long var1, int var3, long var4, GdaJBlobOp var6);

    native void setCNumeric(long var1, int var3, String var4, int var5, int var6);

    native String getCString(long var1);

    native int getCInt(long var1);

    native byte getCChar(long var1);

    native double getCDouble(long var1);

    native float getCFloat(long var1);

    native long getCLong(long var1);

    native short getCShort(long var1);

    native boolean getCBoolean(long var1);

    native Date getCDate(long var1);

    native Time getCTime(long var1);

    native Timestamp getCTimestamp(long var1);

    native byte[] getCBinary(long var1);

    native GdaInputStream getCBlob(long var1);

    native BigDecimal getCNumeric(long var1);

    abstract void setCValue(ResultSet var1, int var2, long var3) throws Exception;

    abstract void getCValue(PreparedStatement var1, int var2, long var3) throws Exception;

    public void setGdaConnectionPointer(long l) {
        this.cnc_c_pointer = l;
    }

    public void setGdaRowColumn(int n) {
        this.gda_row_column = n;
    }

    public static Date createDate(int n, int n2, int n3) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(n, n2, n3);
        return new Date(calendar.getTimeInMillis());
    }

    public static Time createTime(int n, int n2, int n3) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(0, 0, 0, n, n2, n3);
        return new Time(calendar.getTimeInMillis());
    }

    public static Timestamp createTimestamp(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.set(n, n2, n3, n4, n5, n6);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static GdaJValue proto_type_to_jvalue(byte by) throws Exception {
        GdaJValue gdaJValue;
        switch (by) {
            case 0: {
                gdaJValue = new GdaJNull();
                break;
            }
            case 1: {
                gdaJValue = new GdaJString();
                break;
            }
            case 2: {
                gdaJValue = new GdaJInt();
                break;
            }
            case 3: {
                gdaJValue = new GdaJChar();
                break;
            }
            case 4: {
                gdaJValue = new GdaJDouble();
                break;
            }
            case 5: {
                gdaJValue = new GdaJFloat();
                break;
            }
            case 6: {
                gdaJValue = new GdaJBoolean();
                break;
            }
            case 7: {
                gdaJValue = new GdaJDate();
                break;
            }
            case 8: {
                gdaJValue = new GdaJTime();
                break;
            }
            case 9: {
                gdaJValue = new GdaJTimestamp();
                break;
            }
            case 10: {
                gdaJValue = new GdaJBinary();
                break;
            }
            case 11: {
                gdaJValue = new GdaJBlob();
                break;
            }
            case 12: {
                gdaJValue = new GdaJInt64();
                break;
            }
            case 13: {
                gdaJValue = new GdaJShort();
                break;
            }
            case 14: {
                gdaJValue = new GdaJNumeric();
                break;
            }
            default: {
                throw new Exception("Unhandled protocol type " + by);
            }
        }
        return gdaJValue;
    }

    public static String jdbc_type_to_g_type(int n) {
        switch (n) {
            case 12: {
                return "gchararray";
            }
            case 2003: {
                return "GdaBinary";
            }
            case -5: {
                return "gint64";
            }
            case -2: {
                return "GdaBinary";
            }
            case -7: {
                return "gboolean";
            }
            case 2004: {
                return "GdaBlob";
            }
            case 16: {
                return "gboolean";
            }
            case 1: {
                return "gchararray";
            }
            case 70: 
            case 2005: {
                return "GdaBinary";
            }
            case 91: {
                return "GDate";
            }
            case 3: {
                return "GdaNumeric";
            }
            case 2001: {
                return "GdaBinary";
            }
            case 8: {
                return "gdouble";
            }
            case 6: {
                return "gfloat";
            }
            case 4: {
                return "gint";
            }
            case 2000: {
                return "GdaBinary";
            }
            case -16: {
                return "gchararray";
            }
            case -4: {
                return "GdaBinary";
            }
            case -1: {
                return "gchararray";
            }
            case -15: {
                return "gchararray";
            }
            case 2011: {
                return "GdaBinary";
            }
            case 0: {
                return "GdaNull";
            }
            case 2: {
                return "GdaNumeric";
            }
            case -9: {
                return "gchararray";
            }
            case 1111: {
                return "GdaBinary";
            }
            case 7: {
                return "gfloat";
            }
            case 2006: {
                return "GdaBinary";
            }
            case -8: {
                return "gchararray";
            }
            case 5: {
                return "GdaShort";
            }
            case 2009: {
                return "gchararray";
            }
            case 2002: {
                return "GdaBinary";
            }
            case 92: {
                return "GdaTime";
            }
            case 93: {
                return "GdaTimestamp";
            }
            case -6: {
                return "gchar";
            }
        }
        return "GdaBinary";
    }

    public static String toLower(String string) {
        String string2 = string.toUpperCase();
        if (string2 == string) {
            return string.toLowerCase();
        }
        return string;
    }

    static {
        GdaJValue.initIDs();
    }
}

