"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hashObjectTask = void 0;
const task_1 = require("./task");
/**
 * Task used by `git.hashObject`
 */
function hashObjectTask(filePath, write) {
    const commands = ['hash-object', filePath];
    if (write) {
        commands.push('-w');
    }
    return task_1.straightThroughStringTask(commands, true);
}
exports.hashObjectTask = hashObjectTask;
//# sourceMappingURL=hash-object.js.map