/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractHttp11Protocol<S>
extends AbstractProtocol<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractHttp11Protocol.class);
    private String relaxedPathChars = null;
    private String relaxedQueryChars = null;
    private boolean allowHostHeaderMismatch = true;
    private boolean rejectIllegalHeader = false;
    private int socketBuffer = 9000;
    private int maxSavePostSize = 4096;
    private int maxHttpHeaderSize = 8192;
    private int connectionUploadTimeout = 300000;
    private boolean disableUploadTimeout = true;
    private String compression = "off";
    private String noCompressionUserAgents = null;
    private String compressibleMimeTypes = "text/html,text/xml,text/plain,text/css,text/javascript,application/javascript";
    private int compressionMinSize = 2048;
    private boolean noCompressionStrongETag = true;
    private String restrictedUserAgents = null;
    private String server;
    private int maxTrailerSize = 8192;
    private int maxExtensionSize = 8192;
    private int maxSwallowSize = 0x200000;
    private boolean secure;
    private int upgradeAsyncWriteBufferSize = 8192;
    private Set<String> allowedTrailerHeaders = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    protected String getProtocolName() {
        return "Http";
    }

    public String getRelaxedPathChars() {
        return this.relaxedPathChars;
    }

    public void setRelaxedPathChars(String string) {
        this.relaxedPathChars = string;
    }

    public String getRelaxedQueryChars() {
        return this.relaxedQueryChars;
    }

    public void setRelaxedQueryChars(String string) {
        this.relaxedQueryChars = string;
    }

    public boolean getAllowHostHeaderMismatch() {
        return this.allowHostHeaderMismatch;
    }

    public void setAllowHostHeaderMismatch(boolean bl) {
        this.allowHostHeaderMismatch = bl;
    }

    public boolean getRejectIllegalHeader() {
        return this.rejectIllegalHeader;
    }

    public void setRejectIllegalHeader(boolean bl) {
        this.rejectIllegalHeader = bl;
    }

    @Deprecated
    public boolean getRejectIllegalHeaderName() {
        return this.rejectIllegalHeader;
    }

    @Deprecated
    public void setRejectIllegalHeaderName(boolean bl) {
        this.rejectIllegalHeader = bl;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int n) {
        this.socketBuffer = n;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int n) {
        this.maxSavePostSize = n;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int n) {
        this.maxHttpHeaderSize = n;
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setConnectionUploadTimeout(int n) {
        this.connectionUploadTimeout = n;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean bl) {
        this.disableUploadTimeout = bl;
    }

    public void setCompression(String string) {
        this.compression = string;
    }

    public String getCompression() {
        return this.compression;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String string) {
        this.noCompressionUserAgents = string;
    }

    @Deprecated
    public String getCompressableMimeType() {
        return this.getCompressibleMimeType();
    }

    @Deprecated
    public void setCompressableMimeType(String string) {
        this.setCompressibleMimeType(string);
    }

    @Deprecated
    public String getCompressableMimeTypes() {
        return this.getCompressibleMimeType();
    }

    @Deprecated
    public void setCompressableMimeTypes(String string) {
        this.setCompressibleMimeType(string);
    }

    public void setCompressibleMimeType(String string) {
        this.compressibleMimeTypes = string;
    }

    public String getCompressibleMimeType() {
        return this.compressibleMimeTypes;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int n) {
        this.compressionMinSize = n;
    }

    public boolean getNoCompressionStrongETag() {
        return this.noCompressionStrongETag;
    }

    public void setNoCompressionStrongEtag(boolean bl) {
        this.noCompressionStrongETag = bl;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String string) {
        this.restrictedUserAgents = string;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public int getMaxTrailerSize() {
        return this.maxTrailerSize;
    }

    public void setMaxTrailerSize(int n) {
        this.maxTrailerSize = n;
    }

    public int getMaxExtensionSize() {
        return this.maxExtensionSize;
    }

    public void setMaxExtensionSize(int n) {
        this.maxExtensionSize = n;
    }

    public int getMaxSwallowSize() {
        return this.maxSwallowSize;
    }

    public void setMaxSwallowSize(int n) {
        this.maxSwallowSize = n;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public int getUpgradeAsyncWriteBufferSize() {
        return this.upgradeAsyncWriteBufferSize;
    }

    public void setUpgradeAsyncWriteBufferSize(int n) {
        this.upgradeAsyncWriteBufferSize = n;
    }

    public void setAllowedTrailerHeaders(String string) {
        HashSet<String> hashSet = new HashSet<String>(this.allowedTrailerHeaders);
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                String string3 = string2.trim().toLowerCase(Locale.ENGLISH);
                if (hashSet.contains(string3)) {
                    hashSet.remove(string3);
                    continue;
                }
                this.allowedTrailerHeaders.add(string3);
            }
            this.allowedTrailerHeaders.removeAll(hashSet);
        }
    }

    public String getAllowedTrailerHeaders() {
        ArrayList<String> arrayList = new ArrayList<String>(this.allowedTrailerHeaders);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : arrayList) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public void addAllowedTrailerHeader(String string) {
        if (string != null) {
            this.allowedTrailerHeaders.add(string.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    public void removeAllowedTrailerHeader(String string) {
        if (string != null) {
            this.allowedTrailerHeaders.remove(string.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    protected Set<String> getAllowedTrailerHeadersAsSet() {
        return this.allowedTrailerHeaders;
    }

    public boolean isSSLEnabled() {
        return this.endpoint.isSSLEnabled();
    }

    public void setSSLEnabled(boolean bl) {
        this.endpoint.setSSLEnabled(bl);
    }

    public int getMaxKeepAliveRequests() {
        return this.endpoint.getMaxKeepAliveRequests();
    }

    public void setMaxKeepAliveRequests(int n) {
        this.endpoint.setMaxKeepAliveRequests(n);
    }

    protected void configureProcessor(AbstractHttp11Processor<S> abstractHttp11Processor) {
        abstractHttp11Processor.setAdapter(this.getAdapter());
        abstractHttp11Processor.setMaxKeepAliveRequests(this.getMaxKeepAliveRequests());
        abstractHttp11Processor.setKeepAliveTimeout(this.getKeepAliveTimeout());
        abstractHttp11Processor.setConnectionUploadTimeout(this.getConnectionUploadTimeout());
        abstractHttp11Processor.setDisableUploadTimeout(this.getDisableUploadTimeout());
        abstractHttp11Processor.setCompressionMinSize(this.getCompressionMinSize());
        abstractHttp11Processor.setNoCompressionStrongETag(this.getNoCompressionStrongETag());
        abstractHttp11Processor.setCompression(this.getCompression());
        abstractHttp11Processor.setNoCompressionUserAgents(this.getNoCompressionUserAgents());
        abstractHttp11Processor.setCompressibleMimeTypes(this.getCompressibleMimeType());
        abstractHttp11Processor.setRestrictedUserAgents(this.getRestrictedUserAgents());
        abstractHttp11Processor.setSocketBuffer(this.getSocketBuffer());
        abstractHttp11Processor.setMaxSavePostSize(this.getMaxSavePostSize());
        abstractHttp11Processor.setServer(this.getServer());
        abstractHttp11Processor.setMaxCookieCount(this.getMaxCookieCount());
        abstractHttp11Processor.setAllowHostHeaderMismatch(this.getAllowHostHeaderMismatch());
    }
}

