/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.UpgradeProcessor;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketWrapper;

@Deprecated
public class UpgradeNioProcessor
extends UpgradeProcessor<NioChannel> {
    private final NioChannel nioChannel;
    private final NioSelectorPool pool;
    private final int maxRead;
    private final int maxWrite;

    public UpgradeNioProcessor(SocketWrapper<NioChannel> socketWrapper, UpgradeInbound upgradeInbound, NioSelectorPool nioSelectorPool) {
        super(upgradeInbound);
        socketWrapper.setTimeout(upgradeInbound.getReadTimeout());
        this.nioChannel = socketWrapper.getSocket();
        this.pool = nioSelectorPool;
        this.maxRead = this.nioChannel.getBufHandler().getReadBuffer().capacity();
        this.maxWrite = this.nioChannel.getBufHandler().getWriteBuffer().capacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)this.nioChannel.getAttachment();
        if (keyAttachment == null) {
            throw new IOException("Key must be cancelled");
        }
        long l = keyAttachment.getTimeout();
        Selector selector = null;
        try {
            selector = this.pool.get();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            while (!this.nioChannel.flush(true, selector, l)) {
            }
        }
        finally {
            if (selector != null) {
                this.pool.put(selector);
            }
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.writeToSocket(new byte[]{(byte)n}, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 - n3 > this.maxWrite) {
            n3 += this.writeToSocket(byArray, n + n3, this.maxWrite);
        }
        this.writeToSocket(byArray, n + n3, n2 - n3);
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.readSocket(true, byArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public int read(boolean bl, byte[] byArray, int n, int n2) throws IOException {
        if (n2 > this.maxRead) {
            return this.readSocket(bl, byArray, n, this.maxRead);
        }
        return this.readSocket(bl, byArray, n, n2);
    }

    private int readSocket(boolean bl, byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = this.nioChannel.getBufHandler().getReadBuffer();
        int n3 = byteBuffer.remaining();
        if (n3 >= n2) {
            byteBuffer.get(byArray, n, n2);
            return n2;
        }
        int n4 = n2;
        int n5 = n;
        if (n3 > 0) {
            byteBuffer.get(byArray, n, n3);
            n4 -= n3;
            n5 += n3;
        }
        byteBuffer.clear();
        int n6 = this.fillReadBuffer(bl);
        if (n6 > 0) {
            byteBuffer.flip();
            byteBuffer.limit(n6);
            if (n6 > n4) {
                byteBuffer.get(byArray, n5, n4);
                n4 = 0;
            } else {
                byteBuffer.get(byArray, n5, n6);
                n4 -= n6;
            }
        } else if (n6 == 0) {
            byteBuffer.flip();
            byteBuffer.limit(n6);
        } else if (n6 == -1) {
            throw new EOFException(sm.getString("nio.eof.error"));
        }
        return n2 - n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillReadBuffer(boolean bl) throws IOException {
        int n;
        if (bl) {
            Selector selector = null;
            try {
                selector = this.pool.get();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)this.nioChannel.getAttachment();
                if (keyAttachment == null) {
                    throw new IOException("Key must be cancelled.");
                }
                n = this.pool.read(this.nioChannel.getBufHandler().getReadBuffer(), this.nioChannel, selector, keyAttachment.getTimeout());
            }
            catch (EOFException eOFException) {
                n = -1;
            }
            finally {
                if (selector != null) {
                    this.pool.put(selector);
                }
            }
        } else {
            n = this.nioChannel.read(this.nioChannel.getBufHandler().getReadBuffer());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int writeToSocket(byte[] byArray, int n, int n2) throws IOException {
        this.nioChannel.getBufHandler().getWriteBuffer().clear();
        this.nioChannel.getBufHandler().getWriteBuffer().put(byArray, n, n2);
        this.nioChannel.getBufHandler().getWriteBuffer().flip();
        int n3 = 0;
        NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)this.nioChannel.getAttachment();
        if (keyAttachment == null) {
            throw new IOException("Key must be cancelled");
        }
        long l = keyAttachment.getTimeout();
        Selector selector = null;
        try {
            selector = this.pool.get();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            n3 = this.pool.write(this.nioChannel.getBufHandler().getWriteBuffer(), this.nioChannel, selector, l, true);
        }
        finally {
            if (selector != null) {
                this.pool.put(selector);
            }
        }
        return n3;
    }
}

