/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.naming.Context;
import javax.sql.DataSource;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.naming.ContextBindings;

public class DataSourceRealm
extends RealmBase {
    private String preparedRoles = null;
    private String preparedCredentials = null;
    protected String dataSourceName = null;
    protected static final String info = "org.apache.catalina.realm.DataSourceRealm/1.0";
    protected boolean localDataSource = false;
    protected static final String name = "DataSourceRealm";
    protected String roleNameCol = null;
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public boolean getLocalDataSource() {
        return this.localDataSource;
    }

    public void setLocalDataSource(boolean bl) {
        this.localDataSource = bl;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String string) {
        this.roleNameCol = string;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String string) {
        this.userCredCol = string;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String string) {
        this.userNameCol = string;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String string) {
        this.userRoleTable = string;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String string) {
        this.userTable = string;
    }

    @Override
    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        Connection connection = null;
        connection = this.open();
        if (connection == null) {
            return null;
        }
        try {
            Principal principal = this.authenticate(connection, string, string2);
            return principal;
        }
        finally {
            this.close(connection);
        }
    }

    protected Principal authenticate(Connection connection, String string, String string2) {
        if (string == null || string2 == null) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        String string3 = this.getPassword(connection, string);
        if (string3 == null) {
            this.compareCredentials(string2, this.getClass().getName());
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        boolean bl = this.compareCredentials(string2, string3);
        if (bl) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateSuccess", new Object[]{string}));
            }
        } else {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        ArrayList<String> arrayList = this.getRoles(connection, string);
        return new GenericPrincipal(string, string2, arrayList);
    }

    protected void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            this.containerLog.error((Object)"Exception committing connection before closing:", (Throwable)sQLException);
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.close"), (Throwable)sQLException);
        }
    }

    protected Connection open() {
        try {
            Context context = null;
            if (this.localDataSource) {
                context = ContextBindings.getClassLoader();
                context = (Context)context.lookup("comp/env");
            } else {
                context = this.getServer().getGlobalNamingContext();
            }
            DataSource dataSource = (DataSource)context.lookup(this.dataSourceName);
            return dataSource.getConnection();
        }
        catch (Exception exception) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.exception"), (Throwable)exception);
            return null;
        }
    }

    @Override
    protected String getName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getPassword(String string) {
        Connection connection = null;
        connection = this.open();
        if (connection == null) {
            return null;
        }
        try {
            String string2 = this.getPassword(connection, string);
            return string2;
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String getPassword(Connection connection, String string) {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        String string2 = null;
        preparedStatement = connection.prepareStatement(this.preparedCredentials);
        preparedStatement.setString(1, string);
        resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            string2 = resultSet.getString(1);
        }
        String string3 = string2 != null ? string2.trim() : null;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.getPassword.exception", new Object[]{string}), (Throwable)sQLException);
        }
        return string3;
        catch (SQLException sQLException) {
            try {
                this.containerLog.error((Object)sm.getString("dataSourceRealm.getPassword.exception", new Object[]{string}), (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException2) {
                    this.containerLog.error((Object)sm.getString("dataSourceRealm.getPassword.exception", new Object[]{string}), (Throwable)sQLException2);
                }
                throw throwable;
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException3) {
                this.containerLog.error((Object)sm.getString("dataSourceRealm.getPassword.exception", new Object[]{string}), (Throwable)sQLException3);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Principal getPrincipal(String string) {
        Connection connection = this.open();
        if (connection == null) {
            return new GenericPrincipal(string, null, null);
        }
        try {
            GenericPrincipal genericPrincipal = new GenericPrincipal(string, this.getPassword(connection, string), this.getRoles(connection, string));
            return genericPrincipal;
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<String> getRoles(String string) {
        Connection connection = null;
        connection = this.open();
        if (connection == null) {
            return null;
        }
        try {
            ArrayList<String> arrayList = this.getRoles(connection, string);
            return arrayList;
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected ArrayList<String> getRoles(Connection connection, String string) {
        Object object;
        if (this.allRolesMode != RealmBase.AllRolesMode.STRICT_MODE && !this.isRoleStoreDefined()) {
            return null;
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        ArrayList<String> arrayList = null;
        preparedStatement = connection.prepareStatement(this.preparedRoles);
        preparedStatement.setString(1, string);
        resultSet = preparedStatement.executeQuery();
        arrayList = new ArrayList<String>();
        while (resultSet.next()) {
            object = resultSet.getString(1);
            if (object == null) continue;
            arrayList.add(((String)object).trim());
        }
        object = arrayList;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.getRoles.exception", new Object[]{string}), (Throwable)sQLException);
        }
        return object;
        catch (SQLException sQLException) {
            try {
                this.containerLog.error((Object)sm.getString("dataSourceRealm.getRoles.exception", new Object[]{string}), (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException2) {
                    this.containerLog.error((Object)sm.getString("dataSourceRealm.getRoles.exception", new Object[]{string}), (Throwable)sQLException2);
                }
                throw throwable;
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException sQLException3) {
                this.containerLog.error((Object)sm.getString("dataSourceRealm.getRoles.exception", new Object[]{string}), (Throwable)sQLException3);
            }
        }
        return null;
    }

    private boolean isRoleStoreDefined() {
        return this.userRoleTable != null || this.roleNameCol != null;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        stringBuilder.append(this.roleNameCol);
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.userRoleTable);
        stringBuilder.append(" WHERE ");
        stringBuilder.append(this.userNameCol);
        stringBuilder.append(" = ?");
        this.preparedRoles = stringBuilder.toString();
        stringBuilder = new StringBuilder("SELECT ");
        stringBuilder.append(this.userCredCol);
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.userTable);
        stringBuilder.append(" WHERE ");
        stringBuilder.append(this.userNameCol);
        stringBuilder.append(" = ?");
        this.preparedCredentials = stringBuilder.toString();
        super.startInternal();
    }
}

