/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.NonLoginAuthenticator;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.WebAnnotationSet;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.IOTools;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.res.StringManager;

public class Tomcat {
    private static final StringManager sm = StringManager.getManager(Tomcat.class);
    private final Map<String, Logger> pinnedLoggers = new HashMap<String, Logger>();
    protected Server server;
    protected Service service;
    protected Engine engine;
    protected Connector connector;
    protected Host host;
    protected int port = 8080;
    protected String hostname = "localhost";
    protected String basedir;
    @Deprecated
    protected Realm defaultRealm;
    private final Map<String, String> userPass = new HashMap<String, String>();
    private final Map<String, List<String>> userRoles = new HashMap<String, List<String>>();
    private final Map<String, Principal> userPrincipals = new HashMap<String, Principal>();
    private boolean addDefaultWebXmlToWebapp = true;
    static final String[] silences = new String[]{"org.apache.coyote.http11.Http11Protocol", "org.apache.catalina.core.StandardService", "org.apache.catalina.core.StandardEngine", "org.apache.catalina.startup.ContextConfig", "org.apache.catalina.core.ApplicationContext", "org.apache.catalina.core.AprLifecycleListener"};
    private boolean silent = false;

    public Tomcat() {
        ExceptionUtils.preload();
    }

    public void setBaseDir(String string) {
        this.basedir = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public Context addWebapp(String string, String string2) {
        return this.addWebapp(this.getHost(), string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context addWebapp(String string, URL uRL) throws IOException {
        ContextName contextName = new ContextName(string, null);
        Host host = this.getHost();
        if (host.findChild(contextName.getName()) != null) {
            throw new IllegalArgumentException(sm.getString("tomcat.addWebapp.conflictChild", new Object[]{uRL, string, contextName.getName()}));
        }
        File file = new File(host.getAppBase(), contextName.getBaseName() + ".war");
        File file2 = new File(host.getAppBase(), contextName.getBaseName());
        if (file.exists()) {
            throw new IllegalArgumentException(sm.getString("tomcat.addWebapp.conflictFile", new Object[]{uRL, string, file.getAbsolutePath()}));
        }
        if (file2.exists()) {
            throw new IllegalArgumentException(sm.getString("tomcat.addWebapp.conflictFile", new Object[]{uRL, string, file2.getAbsolutePath()}));
        }
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            fileOutputStream = new FileOutputStream(file);
            IOTools.flow(inputStream, fileOutputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.addWebapp(string, file.getAbsolutePath());
    }

    public Context addContext(String string, String string2) {
        return this.addContext(this.getHost(), string, string2);
    }

    public Wrapper addServlet(String string, String string2, String string3) {
        Container container = this.getHost().findChild(string);
        return Tomcat.addServlet((Context)container, string2, string3);
    }

    public static Wrapper addServlet(Context context, String string, String string2) {
        Wrapper wrapper = context.createWrapper();
        wrapper.setServletClass(string2);
        wrapper.setName(string);
        context.addChild(wrapper);
        return wrapper;
    }

    public Wrapper addServlet(String string, String string2, Servlet servlet) {
        Container container = this.getHost().findChild(string);
        return Tomcat.addServlet((Context)container, string2, servlet);
    }

    public static Wrapper addServlet(Context context, String string, Servlet servlet) {
        ExistingStandardWrapper existingStandardWrapper = new ExistingStandardWrapper(servlet);
        existingStandardWrapper.setName(string);
        context.addChild(existingStandardWrapper);
        return existingStandardWrapper;
    }

    public void init() throws LifecycleException {
        this.getServer();
        this.getConnector();
        this.server.init();
    }

    public void start() throws LifecycleException {
        this.getServer();
        this.getConnector();
        this.server.start();
    }

    public void stop() throws LifecycleException {
        this.getServer();
        this.server.stop();
    }

    public void destroy() throws LifecycleException {
        this.getServer();
        this.server.destroy();
    }

    public void addUser(String string, String string2) {
        this.userPass.put(string, string2);
    }

    public void addRole(String string, String string2) {
        List<String> list = this.userRoles.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.userRoles.put(string, list);
        }
        list.add(string2);
    }

    public Connector getConnector() {
        this.getServer();
        if (this.connector != null) {
            return this.connector;
        }
        this.connector = new Connector("HTTP/1.1");
        this.connector.setPort(this.port);
        this.service.addConnector(this.connector);
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public Service getService() {
        this.getServer();
        return this.service;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    public Host getHost() {
        if (this.host == null) {
            this.host = new StandardHost();
            this.host.setName(this.hostname);
            this.getEngine().addChild(this.host);
        }
        return this.host;
    }

    @Deprecated
    public void setDefaultRealm(Realm realm) {
        this.defaultRealm = realm;
    }

    public Engine getEngine() {
        if (this.engine == null) {
            this.getServer();
            this.engine = new StandardEngine();
            this.engine.setName("Tomcat");
            this.engine.setDefaultHost(this.hostname);
            if (this.defaultRealm == null) {
                this.initSimpleAuth();
            }
            this.engine.setRealm(this.defaultRealm);
            this.service.setContainer(this.engine);
        }
        return this.engine;
    }

    public Server getServer() {
        if (this.server != null) {
            return this.server;
        }
        this.initBaseDir();
        System.setProperty("catalina.useNaming", "false");
        this.server = new StandardServer();
        this.server.setPort(-1);
        this.service = new StandardService();
        this.service.setName("Tomcat");
        this.server.addService(this.service);
        return this.server;
    }

    public Context addContext(Host host, String string, String string2) {
        return this.addContext(host, string, string, string2);
    }

    public Context addContext(Host host, String string, String string2, String string3) {
        this.silence(host, string2);
        Context context = this.createContext(host, string);
        context.setName(string2);
        context.setPath(string);
        context.setDocBase(string3);
        context.addLifecycleListener(new FixContextListener());
        if (host == null) {
            this.getHost().addChild(context);
        } else {
            host.addChild(context);
        }
        return context;
    }

    public Context addWebapp(Host host, String string, String string2) {
        LifecycleListener lifecycleListener = null;
        try {
            Class<?> clazz = Class.forName(this.getHost().getConfigClass());
            lifecycleListener = (LifecycleListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        return this.addWebapp(host, string, string2, lifecycleListener);
    }

    @Deprecated
    public Context addWebapp(Host host, String string, String string2, String string3) {
        return this.addWebapp(host, string, string3);
    }

    public Context addWebapp(Host host, String string, String string2, LifecycleListener lifecycleListener) {
        this.silence(host, string);
        Context context = this.createContext(host, string);
        context.setPath(string);
        context.setDocBase(string2);
        if (this.addDefaultWebXmlToWebapp) {
            context.addLifecycleListener(this.getDefaultWebXmlListener());
        }
        context.setConfigFile(this.getWebappConfigFile(string2, string));
        context.addLifecycleListener(lifecycleListener);
        if (this.addDefaultWebXmlToWebapp && lifecycleListener instanceof ContextConfig) {
            ((ContextConfig)lifecycleListener).setDefaultWebXml(this.noDefaultWebXmlPath());
        }
        if (host == null) {
            this.getHost().addChild(context);
        } else {
            host.addChild(context);
        }
        return context;
    }

    public LifecycleListener getDefaultWebXmlListener() {
        return new DefaultWebXmlListener();
    }

    public String noDefaultWebXmlPath() {
        return "org/apache/catalina/startup/NO_DEFAULT_XML";
    }

    @Deprecated
    public Realm getDefaultRealm() {
        if (this.defaultRealm == null) {
            this.initSimpleAuth();
        }
        return this.defaultRealm;
    }

    @Deprecated
    protected void initSimpleAuth() {
        this.defaultRealm = new RealmBase(){

            @Override
            protected String getName() {
                return "Simple";
            }

            @Override
            protected String getPassword(String string) {
                return (String)Tomcat.this.userPass.get(string);
            }

            @Override
            protected Principal getPrincipal(String string) {
                String string2;
                Principal principal = (Principal)Tomcat.this.userPrincipals.get(string);
                if (principal == null && (string2 = (String)Tomcat.this.userPass.get(string)) != null) {
                    principal = new GenericPrincipal(string, string2, (List)Tomcat.this.userRoles.get(string));
                    Tomcat.this.userPrincipals.put(string, principal);
                }
                return principal;
            }
        };
    }

    protected void initBaseDir() {
        String string = System.getProperty("catalina.home");
        if (this.basedir == null) {
            this.basedir = System.getProperty("catalina.base");
        }
        if (this.basedir == null) {
            this.basedir = string;
        }
        if (this.basedir == null) {
            this.basedir = System.getProperty("user.dir") + "/tomcat." + this.port;
            File file = new File(this.basedir);
            file.mkdir();
            if (!file.isAbsolute()) {
                try {
                    this.basedir = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    this.basedir = file.getAbsolutePath();
                }
            }
        }
        if (string == null) {
            System.setProperty("catalina.home", this.basedir);
        }
        System.setProperty("catalina.base", this.basedir);
    }

    public void setSilent(boolean bl) {
        this.silent = bl;
        for (String string : silences) {
            Logger logger = Logger.getLogger(string);
            this.pinnedLoggers.put(string, logger);
            if (bl) {
                logger.setLevel(Level.WARNING);
                continue;
            }
            logger.setLevel(Level.INFO);
        }
    }

    private void silence(Host host, String string) {
        String string2 = this.getLoggerName(host, string);
        Logger logger = Logger.getLogger(string2);
        this.pinnedLoggers.put(string2, logger);
        if (this.silent) {
            logger.setLevel(Level.WARNING);
        } else {
            logger.setLevel(Level.INFO);
        }
    }

    public void setAddDefaultWebXmlToWebapp(boolean bl) {
        this.addDefaultWebXmlToWebapp = bl;
    }

    private String getLoggerName(Host host, String string) {
        if (host == null) {
            host = this.getHost();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ContainerBase.class.getName());
        stringBuilder.append(".[");
        stringBuilder.append(host.getParent().getName());
        stringBuilder.append("].[");
        stringBuilder.append(host.getName());
        stringBuilder.append("].[");
        if (string == null || string.equals("")) {
            stringBuilder.append("/");
        } else if (string.startsWith("##")) {
            stringBuilder.append("/");
            stringBuilder.append(string);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private Context createContext(Host host, String string) {
        String string2 = StandardContext.class.getName();
        if (host == null) {
            host = this.getHost();
        }
        if (host instanceof StandardHost) {
            string2 = ((StandardHost)host).getContextClass();
        }
        try {
            return (Context)Class.forName(string2).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Can't instantiate context-class " + string2 + " for host " + host + " and url " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Can't instantiate context-class " + string2 + " for host " + host + " and url " + string, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Can't instantiate context-class " + string2 + " for host " + host + " and url " + string, illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException("Can't instantiate context-class " + string2 + " for host " + host + " and url " + string, invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Can't instantiate context-class " + string2 + " for host " + host + " and url " + string, noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException("Can't instantiate context-class " + string2 + " for host " + host + " and url " + string, securityException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Can't instantiate context-class " + string2 + " for host " + host + " and url " + string, classNotFoundException);
        }
    }

    public void enableNaming() {
        this.getServer();
        this.server.addLifecycleListener(new NamingContextListener());
        System.setProperty("catalina.useNaming", "true");
        String string = "org.apache.naming";
        String string2 = System.getProperty("java.naming.factory.url.pkgs");
        if (string2 != null) {
            string = string2.contains(string) ? string2 : string + ":" + string2;
        }
        System.setProperty("java.naming.factory.url.pkgs", string);
        string = System.getProperty("java.naming.factory.initial");
        if (string == null) {
            System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        }
    }

    public void initWebappDefaults(String string) {
        Container container = this.getHost().findChild(string);
        Tomcat.initWebappDefaults((Context)container);
    }

    public static void initWebappDefaults(Context context) {
        Wrapper wrapper = Tomcat.addServlet(context, "default", "org.apache.catalina.servlets.DefaultServlet");
        wrapper.setLoadOnStartup(1);
        wrapper.setOverridable(true);
        wrapper = Tomcat.addServlet(context, "jsp", "org.apache.jasper.servlet.JspServlet");
        wrapper.addInitParameter("fork", "false");
        wrapper.setLoadOnStartup(3);
        wrapper.setOverridable(true);
        context.addServletMapping("/", "default");
        context.addServletMapping("*.jsp", "jsp");
        context.addServletMapping("*.jspx", "jsp");
        context.setSessionTimeout(30);
        Tomcat.addDefaultMimeTypeMappings(context);
        context.addWelcomeFile("index.html");
        context.addWelcomeFile("index.htm");
        context.addWelcomeFile("index.jsp");
    }

    public static void addDefaultMimeTypeMappings(Context context) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = Tomcat.class.getResourceAsStream("MimeTypeMappings.properties");
            properties.load(inputStream);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                context.addMimeMapping((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(sm.getString("tomcat.defaultMimeTypeMappingsFail"), iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected URL getWebappConfigFile(String string, String string2) {
        File file = new File(string);
        if (file.isDirectory()) {
            return this.getWebappConfigFileFromDirectory(file, string2);
        }
        return this.getWebappConfigFileFromWar(file, string2);
    }

    private URL getWebappConfigFileFromDirectory(File file, String string) {
        URL uRL = null;
        File file2 = new File(file, "META-INF/context.xml");
        if (file2.exists()) {
            try {
                uRL = file2.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(this.getLoggerName(this.getHost(), string)).log(Level.WARNING, "Unable to determine web application context.xml " + file, malformedURLException);
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getWebappConfigFileFromWar(File file, String string) {
        URL uRL = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            JarEntry jarEntry = jarFile.getJarEntry("META-INF/context.xml");
            if (jarEntry != null) {
                uRL = UriUtil.buildJarUrl((File)file, (String)"META-INF/context.xml");
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getLoggerName(this.getHost(), string)).log(Level.WARNING, "Unable to determine web application context.xml " + file, iOException);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return uRL;
    }

    public static class ExistingStandardWrapper
    extends StandardWrapper {
        private final Servlet existing;

        public ExistingStandardWrapper(Servlet servlet) {
            this.existing = servlet;
            if (servlet instanceof SingleThreadModel) {
                this.singleThreadModel = true;
                this.instancePool = new Stack();
            }
        }

        @Override
        public synchronized Servlet loadServlet() throws ServletException {
            if (this.singleThreadModel) {
                Servlet servlet;
                try {
                    servlet = (Servlet)this.existing.getClass().newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new ServletException((Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ServletException((Throwable)illegalAccessException);
                }
                servlet.init((ServletConfig)this.facade);
                return servlet;
            }
            if (!this.instanceInitialized) {
                this.existing.init((ServletConfig)this.facade);
                this.instanceInitialized = true;
            }
            return this.existing;
        }

        @Override
        public long getAvailable() {
            return 0L;
        }

        @Override
        public boolean isUnavailable() {
            return false;
        }

        @Override
        public Servlet getServlet() {
            return this.existing;
        }

        @Override
        public String getServletClass() {
            return this.existing.getClass().getName();
        }
    }

    public static class DefaultWebXmlListener
    implements LifecycleListener {
        @Override
        public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
            if ("before_start".equals(lifecycleEvent.getType())) {
                Tomcat.initWebappDefaults((Context)lifecycleEvent.getLifecycle());
            }
        }
    }

    public static class FixContextListener
    implements LifecycleListener {
        @Override
        public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
            try {
                Context context = (Context)lifecycleEvent.getLifecycle();
                if (lifecycleEvent.getType().equals("configure_start")) {
                    context.setConfigured(true);
                    WebAnnotationSet.loadApplicationAnnotations(context);
                    if (context.getLoginConfig() == null) {
                        context.setLoginConfig(new LoginConfig("NONE", null, null, null));
                        context.getPipeline().addValve(new NonLoginAuthenticator());
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

