/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.table;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.table.ImagesTableColumns;
import org.fibs.geotag.tasks.EditAltitudeTask;
import org.fibs.geotag.tasks.EditDirectionTask;
import org.fibs.geotag.tasks.EditLatitudeTask;
import org.fibs.geotag.tasks.EditLongitudeTask;
import org.fibs.geotag.tasks.ManualEditTask;
import org.fibs.geotag.tasks.TaskExecutor;
import org.fibs.geotag.util.Coordinates;
import org.fibs.geotag.util.Units;
import org.fibs.geotag.util.Util;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ImagesTableModel
extends AbstractTableModel {
    private static final I18n i18n = I18nFactory.getI18n(ImagesTableModel.class);
    private static final double INVALID_LAT_LON = 999.9;
    private static final double EPSILON = 1.0E-8;
    private ArrayList<ImageInfo> values = new ArrayList();
    private boolean editingForbidden = false;
    private static final String[] COLUMN_NAMES = new String[]{i18n.tr("Name"), i18n.tr("GPS Time"), i18n.tr("Offset"), i18n.tr("Camera Time"), i18n.tr("Latitude"), i18n.tr("Longitude"), i18n.tr("Altitude"), i18n.tr("Direction"), i18n.tr("Location"), i18n.tr("City"), i18n.tr("Province"), i18n.tr("Country"), i18n.tr("Description")};
    public static final int LATITUDE_DECIMALS = 7;
    public static final int LONGITUDE_DECIMALS = 7;
    public static final int ALTITUDE_DECIMALS = 1;
    public static final int DIRECTION_DECIMALS = 1;

    public void sortRows() {
        Collections.sort(this.values);
        this.fireTableDataChanged();
    }

    public void addImageInfo(ImageInfo imageInfo) {
        this.values.add(imageInfo);
        this.sortRows();
    }

    public ImageInfo getImageInfo(int row) {
        return this.values.get(row);
    }

    public void removeRow(int row) {
        this.values.remove(row);
    }

    public int getRow(ImageInfo imageInfo) {
        int row = 0;
        while (row < this.values.size()) {
            if (this.values.get(row).getSequenceNumber() == imageInfo.getSequenceNumber()) {
                return row;
            }
            ++row;
        }
        return -1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    public boolean isEditingForbidden() {
        return this.editingForbidden;
    }

    public void setEditingForbidden(boolean editingForbidden) {
        this.editingForbidden = editingForbidden;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.editingForbidden) {
            return false;
        }
        switch (ImagesTableColumns.COLUMN.values()[columnIndex]) {
            case IMAGE_NAME: 
            case GPS_DATE: 
            case TIME_OFFSET: 
            case CAMERA_DATE: {
                return false;
            }
            case LATITUDE: 
            case LONGITUDE: {
                return true;
            }
            case ALTITUDE: {
                return true;
            }
            case DIRECTION: {
                ImageInfo imageInfo = this.getImageInfo(rowIndex);
                return imageInfo.hasLocation();
            }
            case LOCATION_NAME: 
            case CITY_NAME: 
            case PROVINCE_NAME: 
            case COUNTRY_NAME: {
                return true;
            }
            case USER_COMMENT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        if (this.values == null) {
            return 0;
        }
        return this.values.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        ImageInfo imageInfo = this.values.get(row);
        switch (ImagesTableColumns.COLUMN.values()[column]) {
            case IMAGE_NAME: {
                return imageInfo.getName();
            }
            case CAMERA_DATE: {
                return imageInfo.getCameraDate();
            }
            case GPS_DATE: {
                return imageInfo.getGpsDateTime();
            }
            case TIME_OFFSET: {
                return imageInfo.getOffsetString();
            }
            case LATITUDE: {
                String latitude = imageInfo.getGpsLatitude();
                if (latitude != null) {
                    latitude = Coordinates.format(Double.parseDouble(latitude), false);
                }
                return latitude;
            }
            case LONGITUDE: {
                String longitude = imageInfo.getGpsLongitude();
                if (longitude != null) {
                    longitude = Coordinates.format(Double.parseDouble(longitude), true);
                }
                return longitude;
            }
            case ALTITUDE: {
                Units.ALTITUDE unit = Units.ALTITUDE.values()[Settings.get(Settings.SETTING.ALTITUDE_UNIT, 0)];
                String altitude = imageInfo.getGpsAltitude();
                if (unit != Units.ALTITUDE.METRES) {
                    try {
                        if (altitude != null && altitude.length() > 0) {
                            double altitudeMeters = Double.parseDouble(altitude);
                            double displayAltitude = Units.convert(altitudeMeters, Units.ALTITUDE.METRES, unit);
                            altitude = Double.toString(displayAltitude);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return this.round(altitude, 1);
            }
            case DIRECTION: {
                String direction = imageInfo.getGpsImgDirection();
                if (direction != null) {
                    direction = String.valueOf(this.round(imageInfo.getGpsImgDirection(), 1)) + "\u00b0";
                }
                return direction;
            }
            case LOCATION_NAME: {
                return imageInfo.getLocationName();
            }
            case CITY_NAME: {
                return imageInfo.getCityName();
            }
            case PROVINCE_NAME: {
                return imageInfo.getProvinceName();
            }
            case COUNTRY_NAME: {
                return imageInfo.getCountryName();
            }
            case USER_COMMENT: {
                return imageInfo.getUserComment();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        super.setValueAt(value, rowIndex, columnIndex);
        if (this.editingForbidden) {
            return;
        }
        ImageInfo imageInfo = this.getImageInfo(rowIndex);
        ImagesTableColumns.COLUMN column = ImagesTableColumns.COLUMN.values()[columnIndex];
        String columnName = this.getColumnName(columnIndex);
        switch (column) {
            case IMAGE_NAME: 
            case GPS_DATE: 
            case TIME_OFFSET: 
            case CAMERA_DATE: {
                break;
            }
            case LATITUDE: {
                this.setLatitude(value, imageInfo);
                break;
            }
            case LONGITUDE: {
                this.setLongitude(value, imageInfo);
                break;
            }
            case ALTITUDE: {
                this.setAltitude(value, imageInfo);
                return;
            }
            case DIRECTION: {
                this.setDirection(value, imageInfo);
                break;
            }
            case LOCATION_NAME: {
                this.setLocationName(value, imageInfo, column, columnName);
                break;
            }
            case CITY_NAME: {
                this.setCityName(value, imageInfo, column, columnName);
                break;
            }
            case PROVINCE_NAME: {
                this.setProvinceName(value, imageInfo, column, columnName);
                break;
            }
            case COUNTRY_NAME: {
                this.setCountryName(value, imageInfo, column, columnName);
                break;
            }
            case USER_COMMENT: {
                this.setUserComment(value, imageInfo, column, columnName);
                break;
            }
        }
    }

    private void setUserComment(Object value, ImageInfo imageInfo, ImagesTableColumns.COLUMN column, String columnName) {
        String newString = (String)value;
        String oldString = imageInfo.getUserComment();
        if (!Util.sameContent(oldString, newString)) {
            this.commitManualEdit(imageInfo, column, columnName, newString);
        }
    }

    private void setCountryName(Object value, ImageInfo imageInfo, ImagesTableColumns.COLUMN column, String columnName) {
        String newString = (String)value;
        String oldString = imageInfo.getCountryName();
        if (!Util.sameContent(oldString, newString)) {
            this.commitManualEdit(imageInfo, column, columnName, newString);
        }
    }

    private void setProvinceName(Object value, ImageInfo imageInfo, ImagesTableColumns.COLUMN column, String columnName) {
        String newString = (String)value;
        String oldString = imageInfo.getProvinceName();
        if (!Util.sameContent(oldString, newString)) {
            this.commitManualEdit(imageInfo, column, columnName, newString);
        }
    }

    private void setLocationName(Object value, ImageInfo imageInfo, ImagesTableColumns.COLUMN column, String columnName) {
        String newString = (String)value;
        String oldString = imageInfo.getLocationName();
        if (!Util.sameContent(oldString, newString)) {
            this.commitManualEdit(imageInfo, column, columnName, newString);
        }
    }

    private void setCityName(Object value, ImageInfo imageInfo, ImagesTableColumns.COLUMN column, String columnName) {
        String newString = (String)value;
        String oldString = imageInfo.getCityName();
        if (!Util.sameContent(oldString, newString)) {
            this.commitManualEdit(imageInfo, column, columnName, newString);
        }
    }

    private void setDirection(Object value, ImageInfo imageInfo) {
        boolean update = true;
        String oldString = imageInfo.getGpsImgDirection();
        String newString = (String)value;
        if (oldString == null && newString.length() == 0) {
            update = false;
        } else {
            try {
                double oldDouble = 0.0;
                if (oldString != null) {
                    oldDouble = Double.parseDouble(oldString);
                }
                DecimalFormat decimalFormat = new DecimalFormat();
                Number newNumber = decimalFormat.parse(newString);
                double newDouble = newNumber.doubleValue();
                newString = Double.toString(newDouble);
                double insignificant = 1.0;
                double ten = 10.0;
                int index = 0;
                while (index < 2) {
                    insignificant /= 10.0;
                    ++index;
                }
                if (Math.abs(oldDouble - newDouble) < insignificant) {
                    update = false;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (update) {
            TaskExecutor.execute(new EditDirectionTask(i18n.tr("Edit direction"), imageInfo, newString, ImageInfo.DATA_SOURCE.MANUAL){

                @Override
                protected void process(List<ImageInfo> imageInfos) {
                    for (ImageInfo image : imageInfos) {
                        int row = ImagesTableModel.this.getRow(image);
                        if (row < 0) continue;
                        ImagesTableModel.this.fireTableRowsUpdated(row, row);
                        ImagesTableModel.this.fireTableDataChanged();
                    }
                }
            });
        }
    }

    private void setAltitude(Object value, ImageInfo imageInfo) {
        boolean update = true;
        String oldString = imageInfo.getGpsAltitude();
        String newString = (String)value;
        if (oldString == null && newString.length() == 0) {
            update = false;
        } else {
            try {
                DecimalFormat decimalFormat = new DecimalFormat();
                Number newAltitude = decimalFormat.parse(newString);
                newString = Double.toString(newAltitude.doubleValue());
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                update = false;
            }
            catch (ParseException e) {
                e.printStackTrace();
                update = false;
            }
        }
        if (update) {
            TaskExecutor.execute(new EditAltitudeTask("Edit altitude", imageInfo, newString, ImageInfo.DATA_SOURCE.MANUAL){

                @Override
                protected void process(List<ImageInfo> imageInfos) {
                    for (ImageInfo image : imageInfos) {
                        int row = ImagesTableModel.this.getRow(image);
                        if (row < 0) continue;
                        ImagesTableModel.this.fireTableRowsUpdated(row, row);
                        ImagesTableModel.this.fireTableDataChanged();
                    }
                }
            });
        }
    }

    private void setLongitude(Object value, ImageInfo imageInfo) {
        boolean update = true;
        String oldString = imageInfo.getGpsLatitude();
        String newString = (String)value;
        if (oldString == null && newString.length() == 0) {
            update = false;
        } else {
            try {
                double oldLongitude = 999.9;
                if (oldString != null) {
                    oldLongitude = Double.parseDouble(oldString);
                }
                double newLongitude = Coordinates.parse(newString, true);
                newString = Double.toString(newLongitude);
                if (Double.isNaN(newLongitude) || Math.abs(oldLongitude - newLongitude) < 1.0E-8) {
                    update = false;
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            if (update) {
                TaskExecutor.execute(new EditLongitudeTask(i18n.tr("Edit longitude"), imageInfo, newString, ImageInfo.DATA_SOURCE.MANUAL){

                    @Override
                    protected void process(List<ImageInfo> imageInfos) {
                        for (ImageInfo image : imageInfos) {
                            int row = ImagesTableModel.this.getRow(image);
                            if (row < 0) continue;
                            ImagesTableModel.this.fireTableRowsUpdated(row, row);
                            ImagesTableModel.this.fireTableDataChanged();
                        }
                    }
                });
            }
        }
    }

    private void setLatitude(Object value, ImageInfo imageInfo) {
        boolean update = true;
        String oldString = imageInfo.getGpsLatitude();
        String newString = (String)value;
        if (oldString == null && newString.length() == 0) {
            update = false;
        } else {
            try {
                double oldLatitude = 999.9;
                if (oldString != null) {
                    oldLatitude = Double.parseDouble(oldString);
                }
                double newLatitude = Coordinates.parse(newString, false);
                newString = Double.toString(newLatitude);
                if (Double.isNaN(newLatitude) || Math.abs(oldLatitude - newLatitude) < 1.0E-8) {
                    update = false;
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            if (update) {
                TaskExecutor.execute(new EditLatitudeTask(i18n.tr("Edit latitude"), imageInfo, newString, ImageInfo.DATA_SOURCE.MANUAL){

                    @Override
                    protected void process(List<ImageInfo> imageInfos) {
                        for (ImageInfo image : imageInfos) {
                            int row = ImagesTableModel.this.getRow(image);
                            if (row < 0) continue;
                            ImagesTableModel.this.fireTableRowsUpdated(row, row);
                            ImagesTableModel.this.fireTableDataChanged();
                        }
                    }
                });
            }
        }
    }

    private void commitManualEdit(ImageInfo imageInfo, ImagesTableColumns.COLUMN column, String columnName, String newString) {
        TaskExecutor.execute(new ManualEditTask(columnName, imageInfo, column, newString){

            @Override
            protected void process(List<ImageInfo> imageInfos) {
                for (ImageInfo image : imageInfos) {
                    int row = ImagesTableModel.this.getRow(image);
                    if (row < 0) continue;
                    ImagesTableModel.this.fireTableRowsUpdated(row, row);
                    ImagesTableModel.this.fireTableDataChanged();
                }
            }
        });
    }

    private String round(String value, int decimals) {
        String result = value;
        String format = String.format("%%.%df", decimals);
        if (value != null && value.length() > 0) {
            try {
                Double theValue = new Double(value);
                result = String.format(format, theValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }
}

