/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateGPSLatitude;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class EditLatitudeTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(EditLatitudeTask.class);
    private ImageInfo imageInfo;
    private String newLatitude;
    private ImageInfo.DATA_SOURCE dataSource;

    public EditLatitudeTask(String name, ImageInfo imageInfo, String newLatitude, ImageInfo.DATA_SOURCE dataSource) {
        super(null, name);
        this.imageInfo = imageInfo;
        this.newLatitude = newLatitude;
        this.dataSource = dataSource;
    }

    @Override
    public int getCurrentProgress() {
        return 1;
    }

    @Override
    public int getMaxProgress() {
        return 1;
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        if (this.imageInfo != null) {
            if (this.newLatitude.length() == 0) {
                new UpdateGPSLatitude(this.imageInfo, null, this.dataSource);
            } else {
                new UpdateGPSLatitude(this.imageInfo, this.newLatitude, this.dataSource);
            }
            this.publish(this.imageInfo);
        }
        return i18n.tr("Latitude edited");
    }
}

