/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Vector;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Locale;
import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

abstract class NodeRetained
extends SceneGraphObjectRetained
implements NnuId {
    static final int BACKGROUND = 1;
    static final int CLIP = 2;
    static final int LINEARFOG = 3;
    static final int EXPONENTIALFOG = 4;
    static final int AMBIENTLIGHT = 5;
    static final int DIRECTIONALLIGHT = 6;
    static final int POINTLIGHT = 7;
    static final int SPOTLIGHT = 8;
    static final int LINK = 9;
    static final int MORPH = 10;
    static final int SHAPE = 11;
    static final int BACKGROUNDSOUND = 12;
    static final int POINTSOUND = 13;
    static final int CONESOUND = 14;
    static final int SOUNDSCAPE = 15;
    static final int VIEWPLATFORM = 16;
    static final int BEHAVIOR = 17;
    static final int SWITCH = 18;
    static final int BRANCHGROUP = 19;
    static final int ORDEREDGROUP = 20;
    static final int DECALGROUP = 21;
    static final int SHAREDGROUP = 22;
    static final int GROUP = 23;
    static final int TRANSFORMGROUP = 24;
    static final int BOUNDINGLEAF = 25;
    static final int MODELCLIP = 26;
    static final int ALTERNATEAPPEARANCE = 27;
    static final int ORIENTEDSHAPE3D = 28;
    static final int VIEWSPECIFICGROUP = 29;
    static final int NUMNODES = 29;
    static final int CONTAINS_VIEWPLATFORM = 1;
    VirtualUniverse universe = null;
    Locale locale = null;
    NodeRetained parent = null;
    String nodeId = null;
    int nodeType;
    int refCount = 0;
    int childIndex = -1;
    boolean inSharedGroup = false;
    boolean pickable = true;
    boolean collidable = true;
    Transform3D[][] localToVworld = null;
    int[][] localToVworldIndex = null;
    static final int LAST_LOCAL_TO_VWORLD = 0;
    static final int CURRENT_LOCAL_TO_VWORLD = 1;
    HashKey[] localToVworldKeys = null;
    boolean boundsAutoCompute = true;
    Bounds localBounds;
    Bounds apiBounds;
    protected Bounds cachedBounds = null;
    protected boolean validCachedBounds = false;
    ArrayList branchGroupPaths = new ArrayList(1);
    BackgroundRetained geometryBackground = null;
    GroupRetained parentTransformLink = null;
    GroupRetained parentSwitchLink = null;
    TransformGroupRetained staticTransform = null;
    Integer orderedId = null;
    int nnuId = NnuIdManager.getId();

    NodeRetained() {
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
    }

    public int getId() {
        return this.nnuId;
    }

    public int equal(NnuId nnuId) {
        int n = nnuId.getId();
        if (this.nnuId < n) {
            return -1;
        }
        if (this.nnuId > n) {
            return 1;
        }
        return 0;
    }

    Bounds getLocalBounds(Bounds bounds) {
        return (Bounds)bounds.clone();
    }

    void setBounds(Bounds bounds) {
        this.apiBounds = bounds;
        if (this.source.isLive()) {
            if (!this.boundsAutoCompute) {
                if (bounds != null) {
                    this.localBounds = this.getLocalBounds(bounds);
                    if (this.staticTransform != null) {
                        this.localBounds.transform(this.staticTransform.transform);
                    }
                } else if (this.localBounds != null) {
                    this.localBounds.set(null);
                } else {
                    this.localBounds = new BoundingBox((Bounds)null);
                }
            }
        } else if (bounds != null) {
            this.localBounds = this.getLocalBounds(bounds);
            if (this.staticTransform != null) {
                this.localBounds.transform(this.staticTransform.transform);
            }
        } else if (this.localBounds != null) {
            this.localBounds.set(null);
        } else {
            this.localBounds = new BoundingBox((Bounds)null);
        }
    }

    Bounds getEffectiveBounds() {
        Bounds bounds = null;
        if (this.localBounds != null && !this.localBounds.isEmpty()) {
            bounds = (Bounds)this.localBounds.clone();
            if (this.staticTransform != null) {
                Transform3D transform3D = this.staticTransform.getInvTransform();
                bounds.transform(transform3D);
            }
        }
        return bounds;
    }

    Bounds getBounds() {
        return this.apiBounds;
    }

    void computeCombineBounds(Bounds bounds) {
    }

    void setBoundsAutoCompute(boolean bl) {
        if (this.boundsAutoCompute == bl) {
            return;
        }
        this.boundsAutoCompute = bl;
        this.dirtyBoundsCache();
    }

    boolean getBoundsAutoCompute() {
        return this.boundsAutoCompute;
    }

    void setParent(NodeRetained nodeRetained) {
        this.parent = nodeRetained;
    }

    NodeRetained getParent() {
        return this.parent;
    }

    void transformBounds(SceneGraphPath sceneGraphPath, Bounds bounds) {
        if (!((NodeRetained)sceneGraphPath.item.retained).inSharedGroup) {
            bounds.transform(this.getCurrentLocalToVworld());
        } else {
            HashKey hashKey = new HashKey("");
            sceneGraphPath.getHashKey(hashKey);
            bounds.transform(this.getCurrentLocalToVworld(hashKey));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeLocalToVworld(NodeRetained nodeRetained, NodeRetained nodeRetained2, HashKey hashKey, Transform3D transform3D) {
        if (nodeRetained2 instanceof SharedGroupRetained) {
            String string = hashKey.getLastNodeId();
            SharedGroupRetained sharedGroupRetained = (SharedGroupRetained)nodeRetained2;
            for (int i = 0; i < sharedGroupRetained.parents.size(); ++i) {
                if (!string.equals(((NodeRetained)sharedGroupRetained.parents.elementAt((int)i)).nodeId)) continue;
                this.computeLocalToVworld(nodeRetained, (NodeRetained)sharedGroupRetained.parents.elementAt(i), hashKey, transform3D);
                return;
            }
            throw new RuntimeException(J3dI18N.getString("NodeRetained4"));
        }
        Object object = nodeRetained2.getParent();
        if (object == null) {
            if (((BranchGroupRetained)nodeRetained2).locale == null) throw new RuntimeException(J3dI18N.getString("NodeRetained5"));
            transform3D.setIdentity();
        } else {
            this.computeLocalToVworld(nodeRetained, (NodeRetained)object, hashKey, transform3D);
        }
        if (nodeRetained2 instanceof TransformGroupRetained && nodeRetained2 != nodeRetained) {
            object = new Transform3D();
            ((TransformGroupRetained)nodeRetained2).transform.getWithLock((Transform3D)object);
            transform3D.mul((Transform3D)object);
            return;
        } else {
            if (nodeRetained2 != nodeRetained || this.staticTransform == null) return;
            transform3D.mul(this.staticTransform.transform);
        }
    }

    void computeNonLiveLocalToVworld(Transform3D transform3D, Node node) {
        NodeRetained nodeRetained = this.getParent();
        if (nodeRetained == null) {
            transform3D.setIdentity();
        } else {
            nodeRetained.computeNonLiveLocalToVworld(transform3D, node);
        }
        if (this instanceof TransformGroupRetained && this.source != node) {
            Transform3D transform3D2 = new Transform3D();
            ((TransformGroupRetained)this).getTransform(transform3D2);
            transform3D.mul(transform3D2);
        }
    }

    void getLocalToVworld(Transform3D transform3D) {
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained0"));
        }
        if (this.localToVworld == null) {
            transform3D.setIdentity();
        } else {
            this.computeLocalToVworld(this, this, null, transform3D);
        }
    }

    void getLocalToVworld(SceneGraphPath sceneGraphPath, Transform3D transform3D) {
        HashKey hashKey = new HashKey("");
        if (!this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained1"));
        }
        sceneGraphPath.validate(hashKey);
        this.computeLocalToVworld(this, this, hashKey, transform3D);
    }

    void getLocalToVworld(Transform3D transform3D, HashKey hashKey) {
        HashKey hashKey2 = new HashKey(hashKey);
        this.computeLocalToVworld(this, this, hashKey2, transform3D);
    }

    Locale getLocale() {
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained0"));
        }
        return this.locale;
    }

    Transform3D getCurrentLocalToVworld() {
        if (this.localToVworld != null) {
            return this.localToVworld[0][this.localToVworldIndex[0][1]];
        }
        return new Transform3D();
    }

    Transform3D getCurrentLocalToVworld(int n) {
        return this.localToVworld[n][this.localToVworldIndex[n][1]];
    }

    Transform3D getCurrentLocalToVworld(HashKey hashKey) {
        if (this.localToVworld != null) {
            if (!this.inSharedGroup) {
                return this.localToVworld[0][this.localToVworldIndex[0][1]];
            }
            int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            if (n >= 0) {
                return this.localToVworld[n][this.localToVworldIndex[n][1]];
            }
        }
        return new Transform3D();
    }

    Transform3D getLastLocalToVworld() {
        if (this.localToVworld != null) {
            return this.localToVworld[0][this.localToVworldIndex[0][0]];
        }
        return new Transform3D();
    }

    Transform3D getLastLocalToVworld(int n) {
        return this.localToVworld[n][this.localToVworldIndex[n][0]];
    }

    Transform3D getLastLocalToVworld(HashKey hashKey) {
        if (this.localToVworld != null) {
            if (!this.inSharedGroup) {
                return this.localToVworld[0][this.localToVworldIndex[0][0]];
            }
            int n = hashKey.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
            if (n >= 0) {
                return this.localToVworld[n][this.localToVworldIndex[n][0]];
            }
        }
        return new Transform3D();
    }

    void setAuxData(SetLiveState setLiveState, int n, int n2) {
    }

    void setNodeData(SetLiveState setLiveState) {
        this.localToVworld = setLiveState.localToVworld;
        this.localToVworldIndex = setLiveState.localToVworldIndex;
        this.localToVworldKeys = setLiveState.localToVworldKeys;
        this.branchGroupPaths = setLiveState.parentBranchGroupPaths;
        this.parentTransformLink = setLiveState.parentTransformLink;
        this.parentSwitchLink = setLiveState.parentSwitchLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPickable(boolean bl) {
        if (this.pickable == bl) {
            return;
        }
        this.pickable = bl;
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                boolean[] blArray = !this.inSharedGroup ? new boolean[1] : new boolean[this.localToVworldKeys.length];
                this.findPickableFlags(blArray);
                this.updatePickable(this.localToVworldKeys, blArray);
            }
        }
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (this.pickable) continue;
            blArray[i] = false;
        }
    }

    boolean getPickable() {
        return this.pickable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCollidable(boolean bl) {
        if (this.collidable == bl) {
            return;
        }
        this.collidable = bl;
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                boolean[] blArray = !this.inSharedGroup ? new boolean[1] : new boolean[this.localToVworldKeys.length];
                this.findCollidableFlags(blArray);
                this.updateCollidable(this.localToVworldKeys, blArray);
            }
        }
    }

    boolean getCollidable() {
        return this.collidable;
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            if (this.collidable) continue;
            blArray[i] = false;
        }
    }

    void notifySceneGraphChanged(boolean bl) {
    }

    void recombineAbove() {
    }

    synchronized void updateLocalToVworld() {
    }

    void setLive(SetLiveState setLiveState) {
        int n = this.refCount;
        this.doSetLive(setLiveState);
        if (n <= 0) {
            super.markAsLive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSetLive(SetLiveState setLiveState) {
        int n = this.refCount;
        this.refCount += setLiveState.refCount;
        if (this.locale != null && this.universe != setLiveState.universe) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained3"));
        }
        if (setLiveState.locale == null) {
            System.err.println("NodeRetained.setLive() locale is null");
        }
        this.locale = setLiveState.locale;
        this.inSharedGroup = setLiveState.inSharedGroup;
        if (n <= 0) {
            if (this.listIdx == null) {
                this.universe = setLiveState.universe;
            } else if (setLiveState.universe != this.universe) {
                NodeRetained nodeRetained = this;
                synchronized (nodeRetained) {
                    this.universe = setLiveState.universe;
                    this.incIdxUsed();
                }
            }
        }
        ++setLiveState.universe.numNodes;
        for (int i = 0; i < setLiveState.pickable.length; ++i) {
            if (!this.pickable) {
                setLiveState.pickable[i] = false;
            }
            if (this.collidable) continue;
            setLiveState.collidable[i] = false;
        }
        if (n <= 0) {
            super.doSetLive(setLiveState);
        }
        if (this.inBackgroundGroup) {
            this.geometryBackground = setLiveState.geometryBackground;
        }
        this.setNodeData(setLiveState);
    }

    void removeNodeData(SetLiveState setLiveState) {
        if (this.refCount <= 0) {
            this.localToVworld = null;
            this.localToVworldIndex = null;
            this.localToVworldKeys = null;
            this.branchGroupPaths = new ArrayList(1);
            this.parentTransformLink = null;
            this.parentSwitchLink = null;
        } else {
            this.localToVworld = setLiveState.localToVworld;
            this.localToVworldIndex = setLiveState.localToVworldIndex;
            this.localToVworldKeys = setLiveState.localToVworldKeys;
        }
    }

    void clearLive(SetLiveState setLiveState) {
        this.refCount -= setLiveState.refCount;
        if (this.refCount <= 0) {
            super.clearLive();
            if (this.nodeId != null) {
                this.universe.nodeIdFreeList.addElement(this.nodeId);
                this.nodeId = null;
            }
        }
        --this.universe.numNodes;
        this.removeNodeData(setLiveState);
        if (this.refCount <= 0) {
            this.locale = null;
            this.geometryBackground = null;
        }
    }

    void findPickableFlags(boolean[] blArray) {
        NodeRetained nodeRetained = this;
        if (!this.inSharedGroup) {
            blArray[0] = true;
            nodeRetained = nodeRetained.parent;
            while (nodeRetained != null) {
                if (!nodeRetained.pickable) {
                    blArray[0] = false;
                    break;
                }
                nodeRetained = nodeRetained.parent;
            }
        } else {
            block1: for (int i = 0; i < blArray.length; ++i) {
                nodeRetained = this;
                blArray[i] = true;
                HashKey hashKey = new HashKey(this.localToVworldKeys[i]);
                do {
                    if (nodeRetained instanceof SharedGroupRetained) {
                        String string = hashKey.getLastNodeId();
                        Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                        int n = vector.size();
                        NodeRetained nodeRetained2 = nodeRetained;
                        for (int j = 0; j < n; ++j) {
                            NodeRetained nodeRetained3 = (NodeRetained)vector.elementAt(j);
                            if (!nodeRetained3.nodeId.equals(string)) continue;
                            nodeRetained = nodeRetained3;
                            break;
                        }
                        if (nodeRetained2 == nodeRetained) {
                            return;
                        }
                    } else {
                        nodeRetained = nodeRetained.parent;
                    }
                    if (nodeRetained == null) continue block1;
                } while (nodeRetained.pickable);
                blArray[i] = false;
            }
        }
    }

    void findCollidableFlags(boolean[] blArray) {
        NodeRetained nodeRetained = this;
        if (!this.inSharedGroup) {
            blArray[0] = true;
            nodeRetained = nodeRetained.parent;
            while (nodeRetained != null) {
                if (!nodeRetained.collidable) {
                    blArray[0] = false;
                    break;
                }
                nodeRetained = nodeRetained.parent;
            }
        } else {
            block1: for (int i = 0; i < blArray.length; ++i) {
                nodeRetained = this;
                blArray[i] = true;
                HashKey hashKey = new HashKey(this.localToVworldKeys[i]);
                do {
                    if (nodeRetained instanceof SharedGroupRetained) {
                        String string = hashKey.getLastNodeId();
                        Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                        int n = vector.size();
                        NodeRetained nodeRetained2 = nodeRetained;
                        for (int j = 0; j < n; ++j) {
                            NodeRetained nodeRetained3 = (NodeRetained)vector.elementAt(j);
                            if (!nodeRetained3.nodeId.equals(string)) continue;
                            nodeRetained = nodeRetained3;
                            break;
                        }
                        if (nodeRetained == nodeRetained2) {
                            return;
                        }
                    } else {
                        nodeRetained = nodeRetained.parent;
                    }
                    if (nodeRetained == null) continue block1;
                } while (nodeRetained.collidable);
                blArray[i] = false;
            }
        }
    }

    void findTransformLevels(int[] nArray) {
        NodeRetained nodeRetained = this;
        if (!this.inSharedGroup) {
            nArray[0] = -1;
            while (nodeRetained != null) {
                if (nodeRetained.nodeType == 24) {
                    TransformGroupRetained transformGroupRetained = (TransformGroupRetained)nodeRetained;
                    nArray[0] = transformGroupRetained.transformLevels[0];
                    break;
                }
                nodeRetained = nodeRetained.parent;
            }
        } else {
            block1: for (int i = 0; i < nArray.length; ++i) {
                nodeRetained = this;
                nArray[i] = -1;
                HashKey hashKey = new HashKey(this.localToVworldKeys[i]);
                while (nodeRetained != null) {
                    int n;
                    if (nodeRetained instanceof SharedGroupRetained) {
                        String string = hashKey.getLastNodeId();
                        Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                        int n2 = vector.size();
                        NodeRetained nodeRetained2 = nodeRetained;
                        for (n = 0; n < n2; ++n) {
                            NodeRetained nodeRetained3 = (NodeRetained)vector.elementAt(n);
                            if (!nodeRetained3.nodeId.equals(string)) continue;
                            nodeRetained = nodeRetained3;
                            break;
                        }
                        if (nodeRetained2 == nodeRetained) {
                            return;
                        }
                    } else if (nodeRetained.nodeType == 24) {
                        TransformGroupRetained transformGroupRetained = (TransformGroupRetained)nodeRetained;
                        if (transformGroupRetained.inSharedGroup) {
                            n = hashKey.equals(transformGroupRetained.localToVworldKeys, 0, transformGroupRetained.localToVworldKeys.length);
                            nArray[i] = transformGroupRetained.transformLevels[n];
                            continue block1;
                        }
                        nArray[i] = transformGroupRetained.transformLevels[0];
                        continue block1;
                    }
                    nodeRetained = nodeRetained.parent;
                }
            }
        }
    }

    boolean isStatic() {
        return !this.source.getCapability(11) && !this.source.getCapability(46) && !this.source.getCapability(1) && !this.source.getCapability(0) && !this.source.getCapability(3) && !this.source.getCapability(4) && !this.source.getCapability(5) && !this.source.getCapability(6) && !this.source.getCapability(7) && !this.source.getCapability(8) && !this.source.getCapability(9) && !this.source.getCapability(10);
    }

    void merge(CompileState compileState) {
        this.staticTransform = compileState.staticTransform;
        if (compileState.parentGroup != null) {
            compileState.parentGroup.compiledChildrenList.add(this);
        }
        this.parent = compileState.parentGroup;
        if (this.staticTransform != null) {
            this.mergeTransform(this.staticTransform);
        }
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        if (this.localBounds != null) {
            this.localBounds.transform(transformGroupRetained.transform);
        }
    }

    int[] processViewSpecificInfo(int n, HashKey hashKey, View view, ArrayList arrayList, int[] nArray, ArrayList arrayList2) {
        return nArray;
    }

    VirtualUniverse getVirtualUniverse() {
        return this.universe;
    }

    void searchGeometryAtoms(UnorderList unorderList) {
    }

    void dirtyBoundsCache() {
        if (VirtualUniverse.mc.cacheAutoComputedBounds) {
            this.validCachedBounds = false;
            if (this.parent != null) {
                this.parent.dirtyBoundsCache();
            }
        }
    }
}

