/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.ImageData;
import org.openstreetmap.josm.data.imagery.street_level.IImageEntry;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.layer.LayerVisibilityAction;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.gui.util.imagery.Vector3D;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class ImageViewerDialog
extends ToggleDialog
implements LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener,
ImageData.ImageDataUpdateListener {
    private static final String GEOIMAGE_FILLER = I18n.marktr("Geoimage: {0}");
    private static final String DIALOG_FOLDER = "dialogs";
    private final ImageryFilterSettings imageryFilterSettings = new ImageryFilterSettings();
    private final ImageZoomAction imageZoomAction = new ImageZoomAction();
    private final ImageCenterViewAction imageCenterViewAction = new ImageCenterViewAction();
    private final ImageNextAction imageNextAction = new ImageNextAction();
    private final ImageRemoveAction imageRemoveAction = new ImageRemoveAction();
    private final ImageRemoveFromDiskAction imageRemoveFromDiskAction = new ImageRemoveFromDiskAction();
    private final ImagePreviousAction imagePreviousAction = new ImagePreviousAction();
    private final ImageCollapseAction imageCollapseAction = new ImageCollapseAction();
    private final ImageFirstAction imageFirstAction = new ImageFirstAction();
    private final ImageLastAction imageLastAction = new ImageLastAction();
    private final ImageCopyPathAction imageCopyPathAction = new ImageCopyPathAction();
    private final ImageOpenExternalAction imageOpenExternalAction = new ImageOpenExternalAction();
    private final LayerVisibilityAction visibilityAction = new LayerVisibilityAction(Collections::emptyList, () -> Collections.singleton(this.imageryFilterSettings));
    private final ImageDisplay imgDisplay = new ImageDisplay(this.imageryFilterSettings);
    private Future<?> imgLoadingFuture;
    private boolean centerView;
    private static volatile ImageViewerDialog dialog;
    private boolean collapseButtonClicked;
    private JButton btnLast;
    private JButton btnNext;
    private JButton btnPrevious;
    private JButton btnFirst;
    private JButton btnCollapse;
    private JButton btnDelete;
    private JButton btnCopyPath;
    private JButton btnOpenExternal;
    private JButton btnDeleteFromDisk;
    private JToggleButton tbCentre;
    private transient IImageEntry<? extends IImageEntry<?>> currentEntry;

    static void createInstance() {
        if (dialog != null) {
            throw new IllegalStateException("ImageViewerDialog instance was already created");
        }
        dialog = new ImageViewerDialog();
    }

    public static ImageViewerDialog getInstance() {
        if (dialog == null) {
            throw new AssertionError((Object)"a new instance needs to be created first");
        }
        return dialog;
    }

    private ImageViewerDialog() {
        super(I18n.tr("Geotagged Images", new Object[0]), "geoimage", I18n.tr("Display geotagged images", new Object[0]), Shortcut.registerShortcut("tools:geotagged", I18n.tr("Windows: {0}", I18n.tr("Geotagged Images", new Object[0])), 89, 5003), 200);
        this.build();
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
        MainApplication.getLayerManager().addLayerChangeListener(this);
        for (Layer l : MainApplication.getLayerManager().getLayers()) {
            this.registerOnLayer(l);
        }
    }

    private static JButton createButton(AbstractAction action, Dimension buttonDim) {
        JButton btn = new JButton(action);
        btn.setPreferredSize(buttonDim);
        btn.addPropertyChangeListener("enabled", e -> action.setEnabled(Boolean.TRUE.equals(e.getNewValue())));
        return btn;
    }

    private static JButton createNavigationButton(AbstractAction action, Dimension buttonDim) {
        JButton btn = ImageViewerDialog.createButton(action, buttonDim);
        btn.setEnabled(false);
        action.addPropertyChangeListener(l -> {
            if ("enabled".equals(l.getPropertyName())) {
                btn.setEnabled(action.isEnabled());
            }
        });
        return btn;
    }

    private void build() {
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this.imgDisplay, "Center");
        Dimension buttonDim = new Dimension(26, 26);
        this.btnFirst = ImageViewerDialog.createNavigationButton(this.imageFirstAction, buttonDim);
        this.btnPrevious = ImageViewerDialog.createNavigationButton(this.imagePreviousAction, buttonDim);
        this.btnDelete = ImageViewerDialog.createButton(this.imageRemoveAction, buttonDim);
        this.btnDeleteFromDisk = ImageViewerDialog.createButton(this.imageRemoveFromDiskAction, buttonDim);
        this.btnCopyPath = ImageViewerDialog.createButton(this.imageCopyPathAction, buttonDim);
        this.btnOpenExternal = ImageViewerDialog.createButton(this.imageOpenExternalAction, buttonDim);
        this.btnNext = ImageViewerDialog.createNavigationButton(this.imageNextAction, buttonDim);
        this.btnLast = ImageViewerDialog.createNavigationButton(this.imageLastAction, buttonDim);
        this.tbCentre = new JToggleButton(this.imageCenterViewAction);
        this.tbCentre.setPreferredSize(buttonDim);
        JButton btnZoomBestFit = new JButton(this.imageZoomAction);
        btnZoomBestFit.setPreferredSize(buttonDim);
        this.btnCollapse = ImageViewerDialog.createButton(this.imageCollapseAction, new Dimension(20, 20));
        this.btnCollapse.setAlignmentY(0.0f);
        JPanel buttons = new JPanel();
        buttons.add(this.btnFirst);
        buttons.add(this.btnPrevious);
        buttons.add(this.btnNext);
        buttons.add(this.btnLast);
        buttons.add(Box.createRigidArea(new Dimension(7, 0)));
        buttons.add(this.tbCentre);
        buttons.add(btnZoomBestFit);
        buttons.add(Box.createRigidArea(new Dimension(7, 0)));
        buttons.add(this.btnDelete);
        buttons.add(this.btnDeleteFromDisk);
        buttons.add(Box.createRigidArea(new Dimension(7, 0)));
        buttons.add(this.btnCopyPath);
        buttons.add(this.btnOpenExternal);
        buttons.add(Box.createRigidArea(new Dimension(7, 0)));
        buttons.add(ImageViewerDialog.createButton(this.visibilityAction, buttonDim));
        JPanel bottomPane = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 10;
        gc.weightx = 1.0;
        bottomPane.add((Component)buttons, gc);
        gc.gridx = 1;
        gc.gridy = 0;
        gc.anchor = 20;
        gc.weightx = 0.0;
        bottomPane.add((Component)this.btnCollapse, gc);
        content.add((Component)bottomPane, "South");
        this.createLayout(content, false, null);
    }

    @Override
    public void destroy() {
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this);
        MainApplication.getLayerManager().removeLayerChangeListener(this);
        this.imageFirstAction.destroy();
        this.imageLastAction.destroy();
        this.imagePreviousAction.destroy();
        this.imageNextAction.destroy();
        this.imageCenterViewAction.destroy();
        this.imageCollapseAction.destroy();
        this.imageCopyPathAction.destroy();
        this.imageOpenExternalAction.destroy();
        this.imageRemoveAction.destroy();
        this.imageRemoveFromDiskAction.destroy();
        this.imageZoomAction.destroy();
        this.cancelLoadingImage();
        super.destroy();
        dialog = null;
    }

    public void setPreviousEnabled(boolean value) {
        this.imageFirstAction.updateEnabledState();
        this.btnFirst.setEnabled(value || this.imageFirstAction.isEnabled());
        this.btnPrevious.setEnabled(value);
    }

    public void setNextEnabled(boolean value) {
        this.btnNext.setEnabled(value);
        this.imageLastAction.updateEnabledState();
        this.btnLast.setEnabled(value || this.imageLastAction.isEnabled());
    }

    public static synchronized boolean setCentreEnabled(boolean value) {
        ImageViewerDialog instance = ImageViewerDialog.getInstance();
        boolean wasEnabled = instance.tbCentre.isEnabled();
        instance.tbCentre.setEnabled(value);
        instance.tbCentre.getAction().actionPerformed(new ActionEvent(instance.tbCentre, 0, null));
        return wasEnabled;
    }

    public void displayImage(ImageData ignoredData, ImageEntry entry) {
        this.displayImages(Collections.singletonList(entry));
    }

    public void displayImage(IImageEntry<?> entry) {
        this.displayImages(Collections.singletonList(entry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayImages(List<IImageEntry<?>> entries) {
        boolean imageChanged;
        IImageEntry<?> entry = entries != null && entries.size() == 1 ? entries.get(0) : null;
        ImageViewerDialog imageViewerDialog = this;
        synchronized (imageViewerDialog) {
            boolean bl = imageChanged = this.currentEntry != entry;
            if (this.centerView && entry != null && MainApplication.isDisplayingMapView() && entry.getPos() != null) {
                MainApplication.getMap().mapView.zoomTo(entry.getPos());
            }
            this.currentEntry = entry;
            for (ImageAction action : Arrays.asList(this.imageFirstAction, this.imagePreviousAction, this.imageNextAction, this.imageLastAction)) {
                action.updateEnabledState();
            }
        }
        if (entry == null) {
            this.updateButtonsNullEntry(entries);
            return;
        }
        this.updateButtonsNonNullEntry(entry, imageChanged);
        if (!this.isDialogShowing()) {
            this.setIsDocked(false);
            this.showDialog();
        } else if (this.isDocked && this.isCollapsed) {
            this.expand();
            this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, this);
        }
    }

    private void updateButtonsNullEntry(List<IImageEntry<?>> entries) {
        boolean hasMultipleImages = entries != null && entries.size() > 1;
        this.setTitle(I18n.tr("Geotagged Images", new Object[0]));
        this.imgDisplay.setImage(null);
        this.imgDisplay.setOsdText("");
        this.setNextEnabled(false);
        this.setPreviousEnabled(false);
        this.btnDelete.setEnabled(hasMultipleImages);
        this.btnDeleteFromDisk.setEnabled(hasMultipleImages);
        this.btnCopyPath.setEnabled(false);
        this.btnOpenExternal.setEnabled(false);
        if (hasMultipleImages) {
            this.imgDisplay.setEmptyText(I18n.tr("Multiple images selected", new Object[0]));
            this.btnFirst.setEnabled(!ImageViewerDialog.isFirstImageSelected(entries));
            this.btnLast.setEnabled(!ImageViewerDialog.isLastImageSelected(entries));
        }
        this.imgDisplay.setImage(null);
        this.imgDisplay.setOsdText("");
    }

    private void updateButtonsNonNullEntry(IImageEntry<?> entry, boolean imageChanged) {
        if (imageChanged) {
            this.cancelLoadingImage();
            this.imgLoadingFuture = this.imgDisplay.setImage(entry);
        }
        this.setNextEnabled(entry.getNextImage() != null);
        this.setPreviousEnabled(entry.getPreviousImage() != null);
        this.btnDelete.setEnabled(entry.isRemoveSupported());
        this.btnDeleteFromDisk.setEnabled(entry.isDeleteSupported() && entry.isRemoveSupported());
        this.btnCopyPath.setEnabled(true);
        this.btnOpenExternal.setEnabled(true);
        this.setTitle(I18n.tr("Geotagged Images", new Object[0]) + (!entry.getDisplayName().isEmpty() ? " - " + entry.getDisplayName() : ""));
        StringBuilder osd = new StringBuilder(entry.getDisplayName());
        if (entry.getElevation() != null) {
            osd.append(I18n.tr("\nAltitude: {0} m", Math.round(entry.getElevation())));
        }
        if (entry.getSpeed() != null) {
            osd.append(I18n.tr("\nSpeed: {0} km/h", Math.round(entry.getSpeed())));
        }
        if (entry.getExifImgDir() != null) {
            osd.append(I18n.tr("\nDirection {0}\u00b0", Math.round(entry.getExifImgDir())));
        }
        DateTimeFormatter dtf = DateUtils.getDateTimeFormatter(FormatStyle.SHORT, FormatStyle.MEDIUM).withZone(ZoneOffset.UTC);
        if (entry.hasExifTime()) {
            osd.append(I18n.tr("\nEXIF time: {0}", dtf.format(entry.getExifInstant())));
        }
        if (entry.hasGpsTime()) {
            osd.append(I18n.tr("\nGPS time: {0}", dtf.format(entry.getGpsInstant())));
        }
        Optional.ofNullable(entry.getIptcCaption()).map(s -> I18n.tr("\nCaption: {0}", s)).ifPresent(osd::append);
        Optional.ofNullable(entry.getIptcHeadline()).map(s -> I18n.tr("\nHeadline: {0}", s)).ifPresent(osd::append);
        Optional.ofNullable(entry.getIptcKeywords()).map(s -> I18n.tr("\nKeywords: {0}", s)).ifPresent(osd::append);
        Optional.ofNullable(entry.getIptcObjectName()).map(s -> I18n.tr("\nObject name: {0}", s)).ifPresent(osd::append);
        this.imgDisplay.setOsdText(osd.toString());
    }

    @Deprecated
    public void displayImages(ImageData ignoredData, List<IImageEntry<?>> entries) {
        this.displayImages(entries);
    }

    private static boolean isLastImageSelected(List<IImageEntry<?>> data) {
        return data.stream().anyMatch(image -> data.contains(image.getLastImage()));
    }

    private static boolean isFirstImageSelected(List<IImageEntry<?>> data) {
        return data.stream().anyMatch(image -> data.contains(image.getFirstImage()));
    }

    @Override
    protected boolean dockWhenClosingDetachedDlg() {
        if (this.collapseButtonClicked) {
            this.collapseButtonClicked = false;
            return super.dockWhenClosingDetachedDlg();
        }
        return false;
    }

    @Override
    protected void stateChanged() {
        super.stateChanged();
        if (this.btnCollapse != null) {
            this.btnCollapse.setVisible(!this.isDocked);
        }
    }

    public boolean hasImage() {
        return this.currentEntry != null;
    }

    public static IImageEntry<?> getCurrentImage() {
        return ImageViewerDialog.getInstance().currentEntry;
    }

    public Vector3D getRotation(IImageEntry<?> entry) {
        return this.imgDisplay.getRotation(entry);
    }

    public static boolean isCenterView() {
        return ImageViewerDialog.getInstance().centerView;
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
        this.registerOnLayer(e.getAddedLayer());
        this.showLayer(e.getAddedLayer());
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof GeoImageLayer && this.currentEntry instanceof ImageEntry) {
            ImageData removedData = ((GeoImageLayer)e.getRemovedLayer()).getImageData();
            if (removedData == ((ImageEntry)this.currentEntry).getDataSet()) {
                this.displayImages(null);
            }
            removedData.removeImageDataUpdateListener(this);
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        if (!MainApplication.worker.isShutdown()) {
            this.showLayer(e.getSource().getActiveLayer());
        }
    }

    private void registerOnLayer(Layer layer) {
        if (layer instanceof GeoImageLayer) {
            ((GeoImageLayer)layer).getImageData().addImageDataUpdateListener(this);
        }
    }

    private void showLayer(Layer newLayer) {
        if (this.currentEntry == null && newLayer instanceof GeoImageLayer) {
            ImageData imageData = ((GeoImageLayer)newLayer).getImageData();
            imageData.setSelectedImage(imageData.getFirstImage());
        }
    }

    private void cancelLoadingImage() {
        if (this.imgLoadingFuture != null) {
            this.imgLoadingFuture.cancel(false);
            this.imgLoadingFuture = null;
        }
    }

    @Override
    public void selectedImageChanged(ImageData data) {
        this.displayImages(new ArrayList(data.getSelectedImages()));
    }

    @Override
    public void imageDataUpdated(ImageData data) {
        this.displayImages(new ArrayList(data.getSelectedImages()));
    }

    private class ImageOpenExternalAction
    extends JosmAction {
        ImageOpenExternalAction() {
            super(null, new ImageProvider("external-link"), I18n.tr("Open image in external viewer", new Object[0]), null, false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentEntry != null) {
                try {
                    PlatformManager.getPlatform().openUrl(ImageViewerDialog.this.currentEntry.getFile().toURI().toURL().toExternalForm());
                }
                catch (IOException ex) {
                    Logging.error(ex);
                }
            }
        }
    }

    private class ImageCollapseAction
    extends JosmAction {
        ImageCollapseAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "collapse"), I18n.tr("Move dialog to the side pane", new Object[0]), null, false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageViewerDialog.this.collapseButtonClicked = true;
            ImageViewerDialog.this.detachedDialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(ImageViewerDialog.this.detachedDialog, 201));
        }
    }

    private class ImageCopyPathAction
    extends JosmAction {
        ImageCopyPathAction() {
            super(null, new ImageProvider("copy"), I18n.tr("Copy image path", new Object[0]), Shortcut.registerShortcut("geoimage:copypath", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Copy image path", new Object[0])), 67, 5010), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentEntry != null) {
                ClipboardUtils.copyString(String.valueOf(ImageViewerDialog.this.currentEntry.getFile()));
            }
        }
    }

    private class ImageRemoveFromDiskAction
    extends JosmAction {
        ImageRemoveFromDiskAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "geoimage/deletefromdisk"), I18n.tr("Delete image file from disk", new Object[0]), Shortcut.registerShortcut("geoimage:deletefilefromdisk", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Delete image file from disk", new Object[0])), 127, 5009), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageViewerDialog.this.currentEntry != null) {
                List<Object> toDelete = ImageViewerDialog.this.currentEntry instanceof ImageEntry ? new ArrayList<ImageEntry>(((ImageEntry)ImageViewerDialog.this.currentEntry).getDataSet().getSelectedImages()) : Collections.singletonList(ImageViewerDialog.this.currentEntry);
                int size = toDelete.size();
                int result = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Delete image file from disk", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Delete", new Object[0])).setButtonIcons("cancel", "dialogs/geoimage/deletefromdisk").setContent(new JLabel("<html><h3>" + I18n.trn("Delete the file from disk?", "Delete the {0} files from disk?", size, size) + "<p>" + I18n.trn("The image file will be permanently lost!", "The images files will be permanently lost!", size, new Object[0]) + "</h3></html>", ImageProvider.get("dialogs/geoimage/deletefromdisk"), 10)).toggleEnable("geoimage.deleteimagefromdisk").setCancelButton(1).setDefaultButton(2).showDialog().getValue();
                if (result == 2) {
                    List<ImageData> imageDataCollection = toDelete.stream().filter(ImageEntry.class::isInstance).map(ImageEntry.class::cast).map(ImageEntry::getDataSet).distinct().collect(Collectors.toList());
                    for (IImageEntry iImageEntry : toDelete) {
                        if (iImageEntry.isRemoveSupported() && iImageEntry.isDeleteSupported() && iImageEntry.remove() && iImageEntry.delete()) {
                            Logging.info("File {0} deleted.", iImageEntry.getFile());
                            continue;
                        }
                        JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Image file could not be deleted.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                    }
                    imageDataCollection.forEach(data -> {
                        data.notifyImageUpdate();
                        data.updateSelectedImage();
                    });
                }
            }
        }
    }

    private class ImageRemoveAction
    extends JosmAction {
        ImageRemoveAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "delete"), I18n.tr("Remove photo from layer", new Object[0]), Shortcut.registerShortcut("geoimage:deleteimagefromlayer", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Remove photo from layer", new Object[0])), 127, 5005), false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IImageEntry imageEntry;
            if (ImageViewerDialog.this.currentEntry != null && (imageEntry = ImageViewerDialog.this.currentEntry).isRemoveSupported()) {
                imageEntry.remove();
            }
        }
    }

    private class ImageZoomAction
    extends JosmAction {
        ImageZoomAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "zoom-best-fit"), I18n.tr("Zoom best fit and 1:1", new Object[0]), null, false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImageViewerDialog.this.imgDisplay.zoomBestFitOrOne();
        }
    }

    private class ImageCenterViewAction
    extends JosmAction {
        ImageCenterViewAction() {
            super(null, new ImageProvider("dialogs/autoscale", "selection"), I18n.tr("Center view", new Object[0]), null, false, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton button = (JToggleButton)e.getSource();
            ImageViewerDialog.this.centerView = button.isEnabled() && button.isSelected();
            if (ImageViewerDialog.this.centerView && ImageViewerDialog.this.currentEntry != null && ImageViewerDialog.this.currentEntry.getPos() != null) {
                MainApplication.getMap().mapView.zoomTo(ImageViewerDialog.this.currentEntry.getPos());
            }
        }
    }

    private class ImageLastAction
    extends ImageRememberAction {
        ImageLastAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "last"), I18n.tr("Last", new Object[0]), Shortcut.registerShortcut("geoimage:last", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Show last Image", new Object[0])), 35, 5003), false, null, false, IImageEntry::getLastImage);
        }
    }

    private class ImageFirstAction
    extends ImageRememberAction {
        ImageFirstAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "first"), I18n.tr("First", new Object[0]), Shortcut.registerShortcut("geoimage:first", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Show first Image", new Object[0])), 36, 5003), false, null, false, IImageEntry::getFirstImage);
        }
    }

    private abstract class ImageRememberAction
    extends ImageAction {
        private final ImageProvider defaultIcon;
        transient IImageEntry<?> last;

        ImageRememberAction(String name, ImageProvider icon, String tooltip, Shortcut shortcut, boolean registerInToolbar, String toolbarId, boolean installAdaptors, SerializableUnaryOperator<IImageEntry<?>> supplier) {
            super(name, icon, tooltip, shortcut, registerInToolbar, toolbarId, installAdaptors, supplier);
            this.defaultIcon = icon;
        }

        public void updateIcon() {
            if (this.last != null) {
                new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "history").getResource().attachImageIcon(this, true);
            } else {
                this.defaultIcon.getResource().attachImageIcon(this, true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            IImageEntry current = ImageViewerDialog.this.currentEntry;
            IImageEntry expected = (IImageEntry)this.supplier.apply(current);
            if (current != null) {
                IImageEntry nextEntry = (IImageEntry)this.getSupplier().apply(current);
                current.selectImage(ImageViewerDialog.this, nextEntry);
            }
            this.resetRememberActions();
            this.last = !Objects.equals(current, expected) ? current : null;
            this.updateEnabledState();
        }

        @Override
        protected void updateEnabledState() {
            IImageEntry nextEntry;
            IImageEntry current = ImageViewerDialog.this.currentEntry;
            IImageEntry iImageEntry = nextEntry = current != null ? (IImageEntry)this.getSupplier().apply(current) : null;
            if (this.last == null && nextEntry != null && nextEntry.equals(current)) {
                this.setEnabled(false);
            } else {
                super.updateEnabledState();
            }
            this.updateIcon();
        }

        @Override
        SerializableUnaryOperator<IImageEntry<?>> getSupplier() {
            if (this.last != null) {
                return entry -> this.last;
            }
            return super.getSupplier();
        }
    }

    private class ImagePreviousAction
    extends ImageAction {
        ImagePreviousAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "previous"), I18n.tr("Previous", new Object[0]), Shortcut.registerShortcut("geoimage:previous", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Show previous Image", new Object[0])), 33, 5003), false, null, false, IImageEntry::getPreviousImage);
        }
    }

    private class ImageNextAction
    extends ImageAction {
        ImageNextAction() {
            super(null, new ImageProvider(ImageViewerDialog.DIALOG_FOLDER, "next"), I18n.tr("Next", new Object[0]), Shortcut.registerShortcut("geoimage:next", I18n.tr(GEOIMAGE_FILLER, I18n.tr("Show next Image", new Object[0])), 34, 5003), false, null, false, IImageEntry::getNextImage);
        }
    }

    private abstract class ImageAction
    extends JosmAction {
        final SerializableUnaryOperator<IImageEntry<?>> supplier;

        ImageAction(String name, ImageProvider icon, String tooltip, Shortcut shortcut, boolean registerInToolbar, String toolbarId, boolean installAdaptors, SerializableUnaryOperator<IImageEntry<?>> supplier) {
            super(name, icon, tooltip, shortcut, registerInToolbar, toolbarId, installAdaptors);
            Objects.requireNonNull(supplier);
            this.supplier = supplier;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            IImageEntry entry = ImageViewerDialog.this.currentEntry;
            if (entry != null) {
                IImageEntry nextEntry = (IImageEntry)this.getSupplier().apply(entry);
                entry.selectImage(ImageViewerDialog.this, nextEntry);
            }
            this.resetRememberActions();
        }

        void resetRememberActions() {
            for (ImageRememberAction action : Arrays.asList(ImageViewerDialog.this.imageLastAction, ImageViewerDialog.this.imageFirstAction)) {
                action.last = null;
                action.updateEnabledState();
            }
        }

        SerializableUnaryOperator<IImageEntry<?>> getSupplier() {
            return this.supplier;
        }

        @Override
        protected void updateEnabledState() {
            IImageEntry entry = ImageViewerDialog.this.currentEntry;
            this.setEnabled(entry != null && this.getSupplier().apply(entry) != null);
        }
    }

    @FunctionalInterface
    private static interface SerializableUnaryOperator<I>
    extends UnaryOperator<I>,
    Serializable {
    }
}

