
#ifndef KFILEMETADATA_EXPORT_H
#define KFILEMETADATA_EXPORT_H

#ifdef KFILEMETADATA_STATIC_DEFINE
#  define KFILEMETADATA_EXPORT
#  define KFILEMETADATA_NO_EXPORT
#else
#  ifndef KFILEMETADATA_EXPORT
#    ifdef KF5FileMetaData_EXPORTS
        /* We are building this library */
#      define KFILEMETADATA_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KFILEMETADATA_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KFILEMETADATA_NO_EXPORT
#    define KFILEMETADATA_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KFILEMETADATA_DECL_DEPRECATED
#  define KFILEMETADATA_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KFILEMETADATA_DECL_DEPRECATED_EXPORT
#  define KFILEMETADATA_DECL_DEPRECATED_EXPORT KFILEMETADATA_EXPORT KFILEMETADATA_DECL_DEPRECATED
#endif

#ifndef KFILEMETADATA_DECL_DEPRECATED_NO_EXPORT
#  define KFILEMETADATA_DECL_DEPRECATED_NO_EXPORT KFILEMETADATA_NO_EXPORT KFILEMETADATA_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KFILEMETADATA_NO_DEPRECATED
#    define KFILEMETADATA_NO_DEPRECATED
#  endif
#endif

#define KFILEMETADATA_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KFILEMETADATA_NO_DEPRECATED) && !defined(KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KFILEMETADATA_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KFILEMETADATA_NO_DEPRECATED_WARNINGS) && !defined(KFILEMETADATA_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KFILEMETADATA_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KFILEMETADATA_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KFILEMETADATA_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KFILEMETADATA_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KFILEMETADATA_NO_DEPRECATED)
#  undef KFILEMETADATA_DEPRECATED
#  define KFILEMETADATA_DEPRECATED_EXPORT KFILEMETADATA_EXPORT
#  define KFILEMETADATA_DEPRECATED_NO_EXPORT KFILEMETADATA_NO_EXPORT
#elif defined(KFILEMETADATA_NO_DEPRECATED_WARNINGS)
#  define KFILEMETADATA_DEPRECATED
#  define KFILEMETADATA_DEPRECATED_EXPORT KFILEMETADATA_EXPORT
#  define KFILEMETADATA_DEPRECATED_NO_EXPORT KFILEMETADATA_NO_EXPORT
#else
#  define KFILEMETADATA_DEPRECATED KFILEMETADATA_DECL_DEPRECATED
#  define KFILEMETADATA_DEPRECATED_EXPORT KFILEMETADATA_DECL_DEPRECATED_EXPORT
#  define KFILEMETADATA_DEPRECATED_NO_EXPORT KFILEMETADATA_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KFILEMETADATA_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KFILEMETADATA_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KFILEMETADATA_NO_DEPRECATED
#  define KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55800
#endif
#ifdef KFILEMETADATA_NO_DEPRECATED_WARNINGS
#  define KFILEMETADATA_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KFILEMETADATA_DEPRECATED_WARNINGS_SINCE
#  ifdef KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KFILEMETADATA_DEPRECATED_WARNINGS_SINCE KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KFILEMETADATA_DEPRECATED_WARNINGS_SINCE 0x55800
#  endif
#endif

#ifndef KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KFILEMETADATA_DEPRECATED
#  define KFILEMETADATA_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KFILEMETADATA_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KFILEMETADATA_DEPRECATED_WARNINGS_SINCE >= 0x53200
#  define KFILEMETADATA_DEPRECATED_VERSION_5_50(text) KFILEMETADATA_DECL_DEPRECATED_TEXT(text)
#else
#  define KFILEMETADATA_DEPRECATED_VERSION_5_50(text)
#endif

#if KFILEMETADATA_DEPRECATED_WARNINGS_SINCE >= 0x53c00
#  define KFILEMETADATA_DEPRECATED_VERSION_5_60(text) KFILEMETADATA_DECL_DEPRECATED_TEXT(text)
#else
#  define KFILEMETADATA_DEPRECATED_VERSION_5_60(text)
#endif

#if KFILEMETADATA_DEPRECATED_WARNINGS_SINCE >= 0x54c00
#  define KFILEMETADATA_DEPRECATED_VERSION_5_76(text) KFILEMETADATA_DECL_DEPRECATED_TEXT(text)
#else
#  define KFILEMETADATA_DEPRECATED_VERSION_5_76(text)
#endif

#if KFILEMETADATA_DEPRECATED_WARNINGS_SINCE >= 0x55200
#  define KFILEMETADATA_DEPRECATED_VERSION_5_82(text) KFILEMETADATA_DECL_DEPRECATED_TEXT(text)
#else
#  define KFILEMETADATA_DEPRECATED_VERSION_5_82(text)
#endif
#define KFILEMETADATA_DEPRECATED_VERSION_5(minor, text)      KFILEMETADATA_DEPRECATED_VERSION_5_##minor(text)
#define KFILEMETADATA_DEPRECATED_VERSION(major, minor, text) KFILEMETADATA_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KFILEMETADATA_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KFILEMETADATA_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KFILEMETADATA_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KFILEMETADATA_DEPRECATED_VERSION(major, minor, text)
#  define KFILEMETADATA_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KFILEMETADATA_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KFILEMETADATA_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KFILEMETADATA_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KFILEMETADATA_EXPORT_H */


#ifndef ECM_GENERATEEXPORTHEADER_KFILEMETADATA_EXPORT_H
#define ECM_GENERATEEXPORTHEADER_KFILEMETADATA_EXPORT_H


#define KFILEMETADATA_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#define ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, patch) ((major<<16)|(minor<<8)|(patch))

/* Take any defaults from group settings */
#if !defined(KFILEMETADATA_NO_DEPRECATED) && !defined(KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KFILEMETADATA_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KFILEMETADATA_NO_DEPRECATED_WARNINGS) && !defined(KFILEMETADATA_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KFILEMETADATA_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KFILEMETADATA_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KFILEMETADATA_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KFILEMETADATA_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KFILEMETADATA_NO_DEPRECATED)
#  undef KFILEMETADATA_DEPRECATED
#  define KFILEMETADATA_DEPRECATED_EXPORT KFILEMETADATA_EXPORT
#  define KFILEMETADATA_DEPRECATED_NO_EXPORT KFILEMETADATA_NO_EXPORT
#elif defined(KFILEMETADATA_NO_DEPRECATED_WARNINGS)
#  define KFILEMETADATA_DEPRECATED
#  define KFILEMETADATA_DEPRECATED_EXPORT KFILEMETADATA_EXPORT
#  define KFILEMETADATA_DEPRECATED_NO_EXPORT KFILEMETADATA_NO_EXPORT
#else
#  define KFILEMETADATA_DEPRECATED KFILEMETADATA_DECL_DEPRECATED
#  define KFILEMETADATA_DEPRECATED_EXPORT KFILEMETADATA_DECL_DEPRECATED_EXPORT
#  define KFILEMETADATA_DEPRECATED_NO_EXPORT KFILEMETADATA_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KFILEMETADATA_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KFILEMETADATA_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KFILEMETADATA_NO_DEPRECATED
#  define KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT 0x55800
#endif
#ifdef KFILEMETADATA_NO_DEPRECATED_WARNINGS
#  define KFILEMETADATA_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KFILEMETADATA_DEPRECATED_WARNINGS_SINCE
#  ifdef KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KFILEMETADATA_DEPRECATED_WARNINGS_SINCE KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KFILEMETADATA_DEPRECATED_WARNINGS_SINCE 0x55800
#  endif
#endif

#ifndef KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KFILEMETADATA_DEPRECATED
#  define KFILEMETADATA_ENABLE_DEPRECATED_SINCE(major, minor) (ECM_GENERATEEXPORTHEADER_VERSION_VALUE(major, minor, 0) > KFILEMETADATA_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KFILEMETADATA_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KFILEMETADATA_DEPRECATED_WARNINGS_SINCE >= 0x53200
#  define KFILEMETADATA_DEPRECATED_VERSION_5_50(text) KFILEMETADATA_DECL_DEPRECATED_TEXT(text)
#else
#  define KFILEMETADATA_DEPRECATED_VERSION_5_50(text)
#endif

#if KFILEMETADATA_DEPRECATED_WARNINGS_SINCE >= 0x53c00
#  define KFILEMETADATA_DEPRECATED_VERSION_5_60(text) KFILEMETADATA_DECL_DEPRECATED_TEXT(text)
#else
#  define KFILEMETADATA_DEPRECATED_VERSION_5_60(text)
#endif

#if KFILEMETADATA_DEPRECATED_WARNINGS_SINCE >= 0x54c00
#  define KFILEMETADATA_DEPRECATED_VERSION_5_76(text) KFILEMETADATA_DECL_DEPRECATED_TEXT(text)
#else
#  define KFILEMETADATA_DEPRECATED_VERSION_5_76(text)
#endif

#if KFILEMETADATA_DEPRECATED_WARNINGS_SINCE >= 0x55200
#  define KFILEMETADATA_DEPRECATED_VERSION_5_82(text) KFILEMETADATA_DECL_DEPRECATED_TEXT(text)
#else
#  define KFILEMETADATA_DEPRECATED_VERSION_5_82(text)
#endif
#define KFILEMETADATA_DEPRECATED_VERSION_5(minor, text)      KFILEMETADATA_DEPRECATED_VERSION_5_##minor(text)
#define KFILEMETADATA_DEPRECATED_VERSION(major, minor, text) KFILEMETADATA_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KFILEMETADATA_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KFILEMETADATA_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KFILEMETADATA_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KFILEMETADATA_DEPRECATED_VERSION(major, minor, text)
#  define KFILEMETADATA_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KFILEMETADATA_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KFILEMETADATA_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KFILEMETADATA_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif


#endif /* ECM_GENERATEEXPORTHEADER_KFILEMETADATA_EXPORT_H */
