/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.presets;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.type.ApplicationTypeFactory;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.profiling.presets.PresetSelector;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class ProfilerPresets {
    private static final String JAR_SUFFIX = ".jar";
    private static final String PROP_PRESET_HEADER = "prof_preset_header";
    private static ProfilerPresets INSTANCE;
    private Preferences prefs;
    private List<ProfilerPreset> presets = new ArrayList<ProfilerPreset>();
    private ProfilerPreset presetToSelect;
    private ProfilerPreset presetToCreate;
    private final Set<WeakReference<PresetSelector>> selectors = new HashSet<WeakReference<PresetSelector>>();
    static final String DEFINE_CLASSES;
    private static final String INTERNAL_JAVA_FILTER = "com.sun.**, sun.**, sunw.**,\napple.laf.**, apple.awt.**, com.apple.**,\norg.omg.CORBA.**, org.omg.CosNaming.**, COM.rsa.**";
    private static final String CORE_JAVA_FILTER = "java.**, javax.**, jdk.**,\ncom.sun.**, sun.**, sunw.**,\napple.laf.**, apple.awt.**, com.apple.**,\norg.omg.CORBA.**, org.omg.CosNaming.**, COM.rsa.**";

    public static synchronized ProfilerPresets getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProfilerPresets();
        }
        return INSTANCE;
    }

    public void editPresets(ProfilerPreset preset) {
        this.presetToSelect = preset;
        OptionsDisplayer.getDefault().open("ProfilerOptions");
    }

    ProfilerPreset presetToSelect() {
        ProfilerPreset toSelect = this.presetToSelect;
        this.presetToSelect = null;
        return toSelect;
    }

    public void savePreset(ProfilerPreset preset) {
        this.presetToCreate = preset;
        OptionsDisplayer.getDefault().open("ProfilerOptions");
    }

    ProfilerPreset presetToCreate() {
        ProfilerPreset toCreate = this.presetToCreate;
        this.presetToCreate = null;
        return toCreate;
    }

    void optionsSubmitted(ProfilerPreset selected) {
        HashMap<DefaultComboBoxModel, Boolean> models = new HashMap<DefaultComboBoxModel, Boolean>();
        Iterator<WeakReference<PresetSelector>> selectorsI = this.selectors.iterator();
        while (selectorsI.hasNext()) {
            WeakReference<PresetSelector> selectorR = selectorsI.next();
            PresetSelector selector = (PresetSelector)selectorR.get();
            if (selector == null) {
                selectorsI.remove();
                continue;
            }
            if (SwingUtilities.getRoot(selector) == null) {
                selectorsI.remove();
                continue;
            }
            DefaultComboBoxModel model = selector.getModel();
            boolean savingCustom = selector.checkSavingCustom();
            if (Boolean.TRUE.equals(models.get(model))) continue;
            models.put(model, savingCustom);
        }
        for (DefaultComboBoxModel model : models.keySet()) {
            ProfilerPreset toSelect;
            ProfilerPreset customPreset;
            ProfilerPreset selectedPreset = (ProfilerPreset)model.getSelectedItem();
            ProfilerPreset defaultPreset = (ProfilerPreset)model.getElementAt(0);
            ProfilerPreset profilerPreset = customPreset = model.getSize() < 2 ? null : (ProfilerPreset)model.getElementAt(1);
            if (customPreset != null && !PresetSelector.isCustomPreset(customPreset)) {
                customPreset = null;
            }
            boolean savingCustom = (Boolean)models.get(model);
            model.removeAllElements();
            model.addElement(defaultPreset);
            if (!savingCustom && customPreset != null) {
                model.addElement(customPreset);
            }
            for (ProfilerPreset preset : this.presets) {
                model.addElement(preset);
            }
            ProfilerPreset profilerPreset2 = toSelect = savingCustom && selected != null ? selected : selectedPreset;
            if (model.getIndexOf(toSelect) >= 0) {
                model.setSelectedItem(toSelect);
                continue;
            }
            model.setSelectedItem(model.getElementAt(0));
        }
    }

    public PresetSelector createSelector(DefaultComboBoxModel selectorsModel, List<PresetSelector> allSelectors, Runnable presetSync) {
        return this.createSelector(null, selectorsModel, allSelectors, presetSync);
    }

    public PresetSelector createSelector(Application application, DefaultComboBoxModel selectorsModel, List<PresetSelector> allSelectors, Runnable presetSync) {
        if (selectorsModel.getSize() == 0) {
            for (ProfilerPreset preset : this.getPresets(application)) {
                selectorsModel.addElement(preset);
            }
            String mainClass = null;
            if (application != null) {
                mainClass = ProfilerPresets.getMainClass(application);
                if (mainClass == null || mainClass.isEmpty()) {
                    mainClass = ApplicationTypeFactory.getApplicationTypeFor((Application)application).getName();
                }
                if (mainClass == null || mainClass.isEmpty()) {
                    mainClass = DataSourceDescriptorFactory.getDescriptor((DataSource)application).getName();
                }
            }
            ProfilerPreset defaultPreset = (ProfilerPreset)selectorsModel.getElementAt(0);
            defaultPreset.setSelector(mainClass);
            ProfilerPreset toSelect = defaultPreset;
            if (mainClass != null && !mainClass.isEmpty()) {
                String mainClassL = mainClass.toLowerCase();
                for (int i = 0; i < this.presets.size(); ++i) {
                    ProfilerPreset preset = this.presets.get(i);
                    String selector = preset.getSelector();
                    if (selector == null || selector.isEmpty() || !mainClass.equals(selector) && !mainClassL.contains(selector.toLowerCase())) continue;
                    toSelect = preset;
                    break;
                }
            }
            selectorsModel.setSelectedItem(toSelect);
        }
        PresetSelector selector = new PresetSelector(selectorsModel, allSelectors, presetSync);
        this.selectors.add(new WeakReference<PresetSelector>(selector));
        return selector;
    }

    public ProfilerPreset[] getPresets(Application application) {
        ProfilerPreset[] presetsArr = new ProfilerPreset[this.presets.size() + 1];
        int index = 0;
        presetsArr[index++] = ProfilerPresets.createDefaultPreset(application);
        for (ProfilerPreset preset : this.presets) {
            presetsArr[index++] = preset;
        }
        return presetsArr;
    }

    private void loadPresets() {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                final List loadedPresets = ProfilerPresets.this.doLoadPresets();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerPresets.this.presets.clear();
                        ProfilerPresets.this.presets.addAll(loadedPresets);
                    }
                });
            }
        });
    }

    void savePresets(final PresetsModel toSave) {
        this.presets.clear();
        Enumeration en = toSave.elements();
        while (en.hasMoreElements()) {
            this.presets.add((ProfilerPreset)en.nextElement());
        }
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                ProfilerPresets.this.doSavePresets(toSave);
            }
        });
    }

    PresetsModel getPresets() {
        PresetsModel model = new PresetsModel();
        for (ProfilerPreset preset : this.presets) {
            model.addElement(preset);
        }
        return model;
    }

    private static ProfilerPreset createDefaultPreset(Application application) {
        ProfilerPreset defaultPreset = new ProfilerPreset(NbBundle.getMessage(ProfilerPresets.class, (String)"MSG_Default"), "");
        defaultPreset.setFilterS(ProfilerPresets.getDefaultFiltersS());
        defaultPreset.setRootsP(ProfilerPresets.getDefaultRootsP(application));
        defaultPreset.setFilterP(ProfilerPresets.getDefaultFiltersP(defaultPreset.getRootsP()));
        defaultPreset.setMemoryFilterP(ProfilerPresets.getDefaultMemoryFilterP(application));
        return defaultPreset;
    }

    private static String getMainClass(Application application) {
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        String mainClass = jvm.getMainClass();
        if (mainClass == null || mainClass.trim().isEmpty()) {
            mainClass = "";
        } else if (mainClass.endsWith(JAR_SUFFIX)) {
            File jarFile;
            String args;
            int index;
            String userdir;
            Properties sysProp;
            mainClass = "";
            if (jvm.isGetSystemPropertiesSupported() && (sysProp = jvm.getSystemProperties()) != null && (userdir = sysProp.getProperty("user.dir")) != null && (index = (args = jvm.getCommandLine()).indexOf(JAR_SUFFIX)) != -1 && (jarFile = new File(userdir, args.substring(0, index + JAR_SUFFIX.length()))).exists()) {
                try {
                    JarFile jf = new JarFile(jarFile);
                    String mainClassName = jf.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                    assert (mainClassName != null);
                    mainClass = mainClassName.replace('\\', '/').replace('/', '.');
                    jf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return mainClass;
    }

    private static String getDefaultFiltersS() {
        return CORE_JAVA_FILTER;
    }

    private static String getDefaultRootsP(Application application) {
        if (application == null) {
            return DEFINE_CLASSES;
        }
        String mainClass = ProfilerPresets.getMainClass(application);
        if ("".equals(mainClass)) {
            return DEFINE_CLASSES;
        }
        int dotIndex = mainClass.lastIndexOf(".");
        if (dotIndex == -1) {
            return mainClass;
        }
        return mainClass.substring(0, dotIndex + 1) + "**";
    }

    private static String getDefaultFiltersP(String defaultRoots) {
        return defaultRoots.isEmpty() ? INTERNAL_JAVA_FILTER : CORE_JAVA_FILTER;
    }

    private static String getDefaultMemoryFilterP(Application application) {
        return DEFINE_CLASSES;
    }

    private List<ProfilerPreset> doLoadPresets() {
        Preferences p = this.prefs();
        ArrayList<ProfilerPreset> loadedPresets = new ArrayList<ProfilerPreset>();
        int i = 0;
        String prefix = i + "_";
        while (p.get(prefix + PROP_PRESET_HEADER, null) != null) {
            loadedPresets.add(new ProfilerPreset(p, prefix));
            prefix = ++i + "_";
        }
        return loadedPresets;
    }

    private void doSavePresets(PresetsModel toSave) {
        Preferences p = this.prefs();
        try {
            p.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int count = toSave.size();
        for (int i = 0; i < count; ++i) {
            String prefix = i + "_";
            p.put(prefix + PROP_PRESET_HEADER, "");
            ProfilerPreset preset = (ProfilerPreset)toSave.get(i);
            preset.toPreferences(p, prefix);
        }
    }

    private synchronized Preferences prefs() {
        if (this.prefs == null) {
            this.prefs = NbPreferences.forModule(ProfilerPresets.class);
        }
        return this.prefs;
    }

    private ProfilerPresets() {
        this.loadPresets();
    }

    static {
        DEFINE_CLASSES = NbBundle.getMessage(ProfilerPresets.class, (String)"HINT_Define_roots");
    }

    static class PresetsModel
    extends DefaultListModel {
        PresetsModel() {
        }

        void addPreset(ProfilerPreset preset) {
            this.addElement(preset);
        }

        void removePreset(int preset) {
            this.removeElementAt(preset);
        }

        void movePresetUp(int preset) {
            Object o = this.elementAt(preset);
            this.remove(preset);
            this.add(preset - 1, o);
        }

        void movePresetDown(int preset) {
            Object o = this.elementAt(preset);
            this.remove(preset);
            this.add(preset + 1, o);
        }

        public void fireItemChanged(int itemIndex) {
            this.fireContentsChanged(this, itemIndex, itemIndex);
        }
    }
}

