/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.memory;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.graalvm.visualvm.lib.jfluid.ProfilerEngineSettings;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.filters.InstrumentationFilter;
import org.graalvm.visualvm.lib.jfluid.results.memory.HeapHistogram;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.HeapHistogramResponse;

public class HeapHistogramManager {
    private Map<Integer, String> classesIdMap = new HashMap<Integer, String>(8000);
    private final ProfilerEngineSettings settings;

    public HeapHistogramManager(ProfilerEngineSettings settings) {
        this.settings = settings;
    }

    public HeapHistogram getHistogram(HeapHistogramResponse resp) {
        String[] newNames = resp.getNewNames();
        int[] newIds = resp.getNewids();
        for (int i = 0; i < newNames.length; ++i) {
            this.classesIdMap.put(newIds[i], newNames[i]);
        }
        int[] ids = resp.getIds();
        long[] instances = resp.getInstances();
        long[] bytes = resp.getBytes();
        HeapHistogramImpl histogram = new HeapHistogramImpl(resp.getTime());
        InstrumentationFilter classFilter = this.settings.getInstrumentationFilter();
        for (int i = 0; i < ids.length; ++i) {
            String className = this.classesIdMap.get(ids[i]);
            if (!((GenericFilter)classFilter).passes(className.replace('.', '/'))) continue;
            ClassInfoImpl ci = new ClassInfoImpl(className, instances[i], bytes[i]);
            histogram.addClassInfo(ci, false);
        }
        return histogram;
    }

    static class ClassInfoImpl
    extends HeapHistogram.ClassInfo {
        private String name;
        private long instances;
        private long bytes;

        ClassInfoImpl(String n, long i, long b) {
            this.name = n;
            this.instances = i;
            this.bytes = b;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getInstancesCount() {
            return this.instances;
        }

        @Override
        public long getBytes() {
            return this.bytes;
        }
    }

    static class HeapHistogramImpl
    extends HeapHistogram {
        private Date time;
        private long totalHeapInstances;
        private long totalHeapBytes;
        private Set<HeapHistogram.ClassInfo> heap;
        private long totalPermInstances;
        private long totalPermBytes;
        private Set<HeapHistogram.ClassInfo> perm;

        HeapHistogramImpl(Date t) {
            this.time = t;
            this.heap = new HashSet<HeapHistogram.ClassInfo>(4096);
            this.perm = new HashSet<HeapHistogram.ClassInfo>();
        }

        void addClassInfo(HeapHistogram.ClassInfo ci, boolean permInfo) {
            if (permInfo) {
                this.perm.add(ci);
                this.totalPermInstances += ci.getInstancesCount();
                this.totalPermBytes += ci.getBytes();
            } else {
                this.heap.add(ci);
                this.totalHeapInstances += ci.getInstancesCount();
                this.totalHeapBytes += ci.getBytes();
            }
        }

        @Override
        public Date getTime() {
            return this.time;
        }

        @Override
        public long getTotalInstances() {
            return this.totalHeapInstances + this.totalPermInstances;
        }

        @Override
        public long getTotalBytes() {
            return this.totalHeapBytes + this.totalPermBytes;
        }

        @Override
        public Set<HeapHistogram.ClassInfo> getHeapHistogram() {
            return this.heap;
        }

        @Override
        public long getTotalHeapInstances() {
            return this.totalHeapInstances;
        }

        @Override
        public long getTotalHeapBytes() {
            return this.totalHeapBytes;
        }

        @Override
        public Set<HeapHistogram.ClassInfo> getPermGenHistogram() {
            return this.perm;
        }

        @Override
        public long getTotalPerGenInstances() {
            return this.totalPermInstances;
        }

        @Override
        public long getTotalPermGenHeapBytes() {
            return this.totalPermBytes;
        }
    }
}

