/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.util.List;

public class MindMapNodesSelection
implements Transferable,
ClipboardOwner {
    private String nodesContent;
    private String stringContent;
    private String imageContent;
    private String rtfContent;
    private String htmlContent;
    private String dropActionContent;
    private final List fileList;
    private List nodeIdsContent;
    public static DataFlavor mindMapNodesFlavor = null;
    public static DataFlavor rtfFlavor = null;
    public static DataFlavor htmlFlavor = null;
    public static DataFlavor fileListFlavor = null;
    public static DataFlavor dropActionFlavor = null;
    public static DataFlavor copyNodeIdsFlavor = null;

    public MindMapNodesSelection(String nodesContent, String imageContent, String stringContent, String rtfContent, String htmlContent, String dropActionContent, List fileList, List nodeIdsContent) {
        this.nodesContent = nodesContent;
        this.rtfContent = rtfContent;
        this.imageContent = imageContent;
        this.stringContent = stringContent;
        this.dropActionContent = dropActionContent;
        this.htmlContent = htmlContent;
        this.fileList = fileList;
        this.nodeIdsContent = nodeIdsContent;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(DataFlavor.imageFlavor)) {
            return this.imageContent;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.stringContent;
        }
        if (flavor.equals(mindMapNodesFlavor)) {
            return this.nodesContent;
        }
        if (flavor.equals(dropActionFlavor)) {
            return this.dropActionContent;
        }
        if (flavor.equals(rtfFlavor)) {
            byte[] byteArray = this.rtfContent.getBytes();
            return new ByteArrayInputStream(byteArray);
        }
        if (flavor.equals(htmlFlavor) && this.htmlContent != null) {
            return this.htmlContent;
        }
        if (flavor.equals(fileListFlavor)) {
            return this.fileList;
        }
        if (flavor.equals(copyNodeIdsFlavor)) {
            return this.nodeIdsContent;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor, DataFlavor.stringFlavor, mindMapNodesFlavor, rtfFlavor, htmlFlavor, dropActionFlavor, copyNodeIdsFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor.equals(DataFlavor.imageFlavor) && this.imageContent != null) {
            return true;
        }
        if (flavor.equals(DataFlavor.stringFlavor) && this.stringContent != null) {
            return true;
        }
        if (flavor.equals(mindMapNodesFlavor) && this.nodesContent != null) {
            return true;
        }
        if (flavor.equals(rtfFlavor) && this.rtfContent != null) {
            return true;
        }
        if (flavor.equals(dropActionFlavor) && this.dropActionContent != null) {
            return true;
        }
        if (flavor.equals(htmlFlavor) && this.htmlContent != null) {
            return true;
        }
        if (flavor.equals(fileListFlavor) && this.fileList != null && this.fileList.size() > 0) {
            return true;
        }
        return flavor.equals(copyNodeIdsFlavor) && this.nodeIdsContent != null;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setDropAction(String dropActionContent) {
        this.dropActionContent = dropActionContent;
    }

    static {
        try {
            mindMapNodesFlavor = new DataFlavor("text/freemind-nodes; class=java.lang.String");
            rtfFlavor = new DataFlavor("text/rtf; class=java.io.InputStream");
            htmlFlavor = new DataFlavor("text/html; class=java.lang.String");
            fileListFlavor = new DataFlavor("application/x-java-file-list; class=java.util.List");
            dropActionFlavor = new DataFlavor("text/drop-action; class=java.lang.String");
            copyNodeIdsFlavor = new DataFlavor("application/freemind-node-ids; class=java.util.List");
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

