/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoaderFactory;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRaw;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRawPNG;
import org.apache.xmlgraphics.image.loader.spi.ImageLoader;

public class ImageLoaderFactoryRaw
extends AbstractImageLoaderFactory {
    public static final String MIME_EMF = "image/x-emf";
    private static final String[] MIMES = new String[]{"image/png", "image/jpeg", "image/tiff", "image/x-emf"};
    private static final ImageFlavor[][] FLAVORS = new ImageFlavor[][]{{ImageFlavor.RAW_PNG}, {ImageFlavor.RAW_JPEG}, {ImageFlavor.RAW_TIFF}, {ImageFlavor.RAW_EMF}};

    public static String getMimeForRawFlavor(ImageFlavor flavor) {
        int ci = FLAVORS.length;
        for (int i = 0; i < ci; ++i) {
            int cj = FLAVORS[i].length;
            for (int j = 0; j < cj; ++j) {
                if (!FLAVORS[i][j].equals(flavor)) continue;
                return MIMES[i];
            }
        }
        throw new IllegalArgumentException("ImageFlavor is not a \"raw\" flavor: " + flavor);
    }

    @Override
    public String[] getSupportedMIMETypes() {
        return MIMES;
    }

    @Override
    public ImageFlavor[] getSupportedFlavors(String mime) {
        int c = MIMES.length;
        for (int i = 0; i < c; ++i) {
            if (!MIMES[i].equals(mime)) continue;
            return FLAVORS[i];
        }
        throw new IllegalArgumentException("Unsupported MIME type: " + mime);
    }

    @Override
    public ImageLoader newImageLoader(ImageFlavor targetFlavor) {
        if (targetFlavor.equals(ImageFlavor.RAW_JPEG)) {
            return new ImageLoaderRawJPEG();
        }
        if (targetFlavor.equals(ImageFlavor.RAW_PNG)) {
            return new ImageLoaderRawPNG();
        }
        return new ImageLoaderRaw(targetFlavor);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

