/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCacheEventLogging;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheClient;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElementSerialized;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICacheType;
import org.apache.commons.jcs3.engine.behavior.IZombie;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.Stats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.serialization.SerializationConversionUtil;
import org.apache.commons.jcs3.utils.threadpool.ThreadPoolManager;

public abstract class AbstractRemoteAuxiliaryCache<K, V>
extends AbstractAuxiliaryCacheEventLogging<K, V>
implements IRemoteCacheClient<K, V> {
    private static final Log log = LogManager.getLog(AbstractRemoteAuxiliaryCache.class);
    private ICacheServiceNonLocal<K, V> remoteCacheService;
    protected final String cacheName;
    private IRemoteCacheListener<K, V> remoteCacheListener;
    private IRemoteCacheAttributes remoteCacheAttributes;
    private ExecutorService pool = null;
    private boolean usePoolForGet = false;

    public AbstractRemoteAuxiliaryCache(IRemoteCacheAttributes cattr, ICacheServiceNonLocal<K, V> remote, IRemoteCacheListener<K, V> listener) {
        this.setRemoteCacheAttributes(cattr);
        this.cacheName = cattr.getCacheName();
        this.setRemoteCacheService(remote);
        this.setRemoteCacheListener(listener);
        if (log.isDebugEnabled()) {
            log.debug("Construct> cacheName={0}", () -> cattr.getCacheName());
            log.debug("irca = {0}", () -> this.getRemoteCacheAttributes());
            log.debug("remote = {0}", remote);
            log.debug("listener = {0}", listener);
        }
        log.debug("GetTimeoutMillis() = {0}", () -> this.getRemoteCacheAttributes().getGetTimeoutMillis());
        if (this.getRemoteCacheAttributes().getGetTimeoutMillis() > 0) {
            this.pool = ThreadPoolManager.getInstance().getExecutorService(this.getRemoteCacheAttributes().getThreadPoolName());
            log.debug("Thread Pool = {0}", this.pool);
            this.usePoolForGet = true;
        }
    }

    @Override
    protected void processDispose() throws IOException {
        log.info("Disposing of remote cache.");
        try {
            if (this.getRemoteCacheListener() != null) {
                this.getRemoteCacheListener().dispose();
            }
        }
        catch (IOException ex) {
            log.error("Couldn't dispose", ex);
            this.handleException(ex, "Failed to dispose [" + this.cacheName + "]", "dispose");
        }
    }

    @Override
    protected ICacheElement<K, V> processGet(K key) throws IOException {
        ICacheElement<K, V> retVal = null;
        try {
            retVal = this.usePoolForGet ? this.getUsingPool(key) : this.getRemoteCacheService().get(this.cacheName, key, this.getListenerId());
            if (retVal instanceof ICacheElementSerialized && this.getRemoteCacheAttributes().getRemoteType() != RemoteType.CLUSTER) {
                retVal = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)retVal, super.getElementSerializer());
            }
        }
        catch (Exception ex) {
            this.handleException(ex, "Failed to get [" + key + "] from [" + this.cacheName + "]", "get");
        }
        return retVal;
    }

    public ICacheElement<K, V> getUsingPool(K key) throws IOException {
        int timeout = this.getRemoteCacheAttributes().getGetTimeoutMillis();
        try {
            Callable<ICacheElement> command = () -> this.getRemoteCacheService().get(this.cacheName, key, this.getListenerId());
            Future<ICacheElement> future = this.pool.submit(command);
            ICacheElement ice = future.get(timeout, TimeUnit.MILLISECONDS);
            if (ice == null) {
                log.debug("nothing found in remote cache");
            } else {
                log.debug("found item in remote cache");
            }
            return ice;
        }
        catch (TimeoutException te) {
            log.warn("TimeoutException, Get Request timed out after {0}", timeout);
            throw new IOException("Get Request timed out after " + timeout);
        }
        catch (InterruptedException ex) {
            log.warn("InterruptedException, Get Request timed out after {0}", timeout);
            throw new IOException("Get Request timed out after " + timeout);
        }
        catch (ExecutionException ex) {
            log.error("ExecutionException, Assuming an IO exception thrown in the background.", ex);
            throw new IOException("Get Request timed out after " + timeout);
        }
    }

    @Override
    public Map<K, ICacheElement<K, V>> processGetMatching(String pattern) throws IOException {
        HashMap<K, ICacheElement<K, V>> results = new HashMap<K, ICacheElement<K, V>>();
        try {
            Map<K, ICacheElement<K, V>> rawResults = this.getRemoteCacheService().getMatching(this.cacheName, pattern, this.getListenerId());
            if (rawResults != null) {
                for (Map.Entry<K, ICacheElement<K, V>> entry : rawResults.entrySet()) {
                    ICacheElement<K, V> unwrappedResult = null;
                    if (entry.getValue() instanceof ICacheElementSerialized) {
                        if (this.getRemoteCacheAttributes().getRemoteType() != RemoteType.CLUSTER) {
                            unwrappedResult = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)entry.getValue(), super.getElementSerializer());
                        }
                    } else {
                        unwrappedResult = entry.getValue();
                    }
                    results.put(entry.getKey(), unwrappedResult);
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex, "Failed to getMatching [" + pattern + "] from [" + this.cacheName + "]", "get");
        }
        return results;
    }

    @Override
    protected boolean processRemove(K key) throws IOException {
        if (!this.getRemoteCacheAttributes().getGetOnly()) {
            log.debug("remove> key={0}", key);
            try {
                this.getRemoteCacheService().remove(this.cacheName, key, this.getListenerId());
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to remove " + key + " from " + this.cacheName, "remove");
            }
            return true;
        }
        return false;
    }

    @Override
    protected void processRemoveAll() throws IOException {
        if (!this.getRemoteCacheAttributes().getGetOnly()) {
            try {
                this.getRemoteCacheService().removeAll(this.cacheName, this.getListenerId());
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to remove all from " + this.cacheName, "removeAll");
            }
        }
    }

    @Override
    protected void processUpdate(ICacheElement<K, V> ce) throws IOException {
        if (!this.getRemoteCacheAttributes().getGetOnly()) {
            ICacheElementSerialized<K, V> serialized = null;
            try {
                log.debug("sending item to remote server");
                serialized = SerializationConversionUtil.getSerializedCacheElement(ce, super.getElementSerializer());
                this.remoteCacheService.update(serialized, this.getListenerId());
            }
            catch (NullPointerException npe) {
                log.error("npe for ce = {0} ce.attr = {1}", ce, ce.getElementAttributes(), npe);
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to put [" + ce.getKey() + "] to " + ce.getCacheName(), "update");
            }
        } else {
            log.debug("get only mode, not sending to remote server");
        }
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        return this.getRemoteCacheService().getKeySet(this.cacheName);
    }

    @Override
    public IRemoteCacheListener<K, V> getListener() {
        return this.getRemoteCacheListener();
    }

    public void setListenerId(long id) {
        if (this.getRemoteCacheListener() != null) {
            try {
                this.getRemoteCacheListener().setListenerId(id);
                log.debug("set listenerId = {0}", id);
            }
            catch (Exception e) {
                log.error("Problem setting listenerId", e);
            }
        }
    }

    @Override
    public long getListenerId() {
        if (this.getRemoteCacheListener() != null) {
            try {
                log.debug("get listenerId = {0}", this.getRemoteCacheListener().getListenerId());
                return this.getRemoteCacheListener().getListenerId();
            }
            catch (IOException e) {
                log.error("Problem getting listenerId", e);
            }
        }
        return -1L;
    }

    @Override
    public int getSize() {
        return 0;
    }

    protected abstract void handleException(Exception var1, String var2, String var3) throws IOException;

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("AbstractRemoteAuxiliaryCache");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<String>("Remote Type", this.getRemoteCacheAttributes().getRemoteTypeName()));
        elems.add(new StatElement<Boolean>("UsePoolForGet", this.usePoolForGet));
        if (this.pool != null) {
            elems.add(new StatElement<ExecutorService>("Pool", this.pool));
        }
        if (this.getRemoteCacheService() instanceof ZombieCacheServiceNonLocal) {
            elems.add(new StatElement<Integer>("Zombie Queue Size", ((ZombieCacheServiceNonLocal)this.getRemoteCacheService()).getQueueSize()));
        }
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    public CacheStatus getStatus() {
        return this.getRemoteCacheService() instanceof IZombie ? CacheStatus.ERROR : CacheStatus.ALIVE;
    }

    @Override
    public void fixCache(ICacheServiceNonLocal<?, ?> restoredRemote) {
        ICacheServiceNonLocal<?, ?> remote = restoredRemote;
        ICacheServiceNonLocal<K, V> prevRemote = this.getRemoteCacheService();
        if (prevRemote instanceof ZombieCacheServiceNonLocal) {
            ZombieCacheServiceNonLocal zombie = (ZombieCacheServiceNonLocal)prevRemote;
            this.setRemoteCacheService(remote);
            try {
                zombie.propagateEvents(remote);
            }
            catch (Exception e) {
                try {
                    this.handleException(e, "Problem propagating events from Zombie Queue to new Remote Service.", "fixCache");
                }
                catch (IOException iOException) {}
            }
        } else {
            this.setRemoteCacheService(remote);
        }
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.REMOTE_CACHE;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    protected void setRemoteCacheService(ICacheServiceNonLocal<K, V> remote) {
        this.remoteCacheService = remote;
    }

    protected ICacheServiceNonLocal<K, V> getRemoteCacheService() {
        return this.remoteCacheService;
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.getRemoteCacheAttributes();
    }

    protected void setRemoteCacheAttributes(IRemoteCacheAttributes remoteCacheAttributes) {
        this.remoteCacheAttributes = remoteCacheAttributes;
    }

    protected IRemoteCacheAttributes getRemoteCacheAttributes() {
        return this.remoteCacheAttributes;
    }

    protected void setRemoteCacheListener(IRemoteCacheListener<K, V> remoteCacheListener) {
        this.remoteCacheListener = remoteCacheListener;
    }

    protected IRemoteCacheListener<K, V> getRemoteCacheListener() {
        return this.remoteCacheListener;
    }
}

