/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collections;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class DeleteLayerAction
extends JosmAction {
    public DeleteLayerAction() {
        super(I18n.tr("Delete Layer", new Object[0]), "dialogs/delete", I18n.tr("Delete the active layer. Does not delete the associated file.", new Object[0]), Shortcut.registerShortcut("system:deletelayer", I18n.tr("File: {0}", I18n.tr("Delete Layer", new Object[0])), 115, 5006), true, "delete-layer", true);
        this.setHelpId(HelpUtil.ht("/Action/DeleteLayer"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Layer activeLayer = this.getLayerManager().getActiveLayer();
        if (activeLayer == null) {
            return;
        }
        if (!SaveLayersDialog.saveUnsavedModifications(Collections.singletonList(activeLayer), SaveLayersDialog.Reason.DELETE)) {
            return;
        }
        this.getLayerManager().removeLayer(activeLayer);
    }

    @Override
    protected boolean listenToSelectionChange() {
        return false;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getActiveLayer() != null);
    }
}

