/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.spi;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class ISO_8859_16
extends Charset {
    public static final ISO_8859_16 INSTANCE = new ISO_8859_16();

    ISO_8859_16() {
        super("ISO-8859-16", new String[]{"iso-ir-226", "ISO_8859-16:2001", "ISO_8859-16", "latin10", "l10", "csISO885916", "ISO8859_16", "ISO_8859_16", "8859_16", "ISO8859-16"});
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof ISO_8859_16;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends CharsetEncoder {
        Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f, new byte[]{63});
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.hasRemaining()) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                char c = in.get();
                byte b2 = 0;
                byte[] replace2 = null;
                switch (c) {
                    case '\u0104': {
                        b2 = -95;
                        break;
                    }
                    case '\u0105': {
                        b2 = -94;
                        break;
                    }
                    case '\u0141': {
                        b2 = -93;
                        break;
                    }
                    case '\u20ac': {
                        b2 = -92;
                        break;
                    }
                    case '\u201e': {
                        b2 = -91;
                        break;
                    }
                    case '\u0160': {
                        b2 = -90;
                        break;
                    }
                    case '\u0161': {
                        b2 = -88;
                        break;
                    }
                    case '\u0218': {
                        b2 = -86;
                        break;
                    }
                    case '\u0179': {
                        b2 = -84;
                        break;
                    }
                    case '\u017a': {
                        b2 = -82;
                        break;
                    }
                    case '\u017b': {
                        b2 = -81;
                        break;
                    }
                    case '\u010c': {
                        b2 = -78;
                        break;
                    }
                    case '\u0142': {
                        b2 = -77;
                        break;
                    }
                    case '\u017d': {
                        b2 = -76;
                        break;
                    }
                    case '\u201d': {
                        b2 = -75;
                        break;
                    }
                    case '\u017e': {
                        b2 = -72;
                        break;
                    }
                    case '\u010d': {
                        b2 = -71;
                        break;
                    }
                    case '\u0219': {
                        b2 = -70;
                        break;
                    }
                    case '\u0152': {
                        b2 = -68;
                        break;
                    }
                    case '\u0153': {
                        b2 = -67;
                        break;
                    }
                    case '\u0178': {
                        b2 = -66;
                        break;
                    }
                    case '\u017c': {
                        b2 = -65;
                        break;
                    }
                    case '\u0102': {
                        b2 = -61;
                        break;
                    }
                    case '\u0106': {
                        b2 = -59;
                        break;
                    }
                    case '\u0110': {
                        b2 = -47;
                        break;
                    }
                    case '\u0143': {
                        b2 = -46;
                        break;
                    }
                    case '\u0150': {
                        b2 = -43;
                        break;
                    }
                    case '\u015a': {
                        b2 = -41;
                        break;
                    }
                    case '\u0170': {
                        b2 = -40;
                        break;
                    }
                    case '\u0118': {
                        b2 = -35;
                        break;
                    }
                    case '\u021a': {
                        b2 = -34;
                        break;
                    }
                    case '\u0103': {
                        b2 = -29;
                        break;
                    }
                    case '\u0107': {
                        b2 = -27;
                        break;
                    }
                    default: {
                        if (c < '\u0100') {
                            b2 = (byte)c;
                            break;
                        }
                        replace2 = this.replacement();
                    }
                }
                if (replace2 != null) {
                    if (out.remaining() < replace2.length) {
                        ((Buffer)in).position(in.position() - 1);
                        return CoderResult.OVERFLOW;
                    }
                    out.put(replace2);
                    continue;
                }
                out.put(b2);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        private static final char[] TABLE = new char[256];

        Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                int b2 = in.get() & 0xFF;
                char c = TABLE[b2];
                out.put(c);
            }
            return CoderResult.UNDERFLOW;
        }

        static {
            for (int i2 = 0; i2 < 256; ++i2) {
                Decoder.TABLE[i2] = (char)i2;
            }
            Decoder.TABLE[161] = 260;
            Decoder.TABLE[162] = 261;
            Decoder.TABLE[163] = 321;
            Decoder.TABLE[164] = 8364;
            Decoder.TABLE[165] = 8222;
            Decoder.TABLE[166] = 352;
            Decoder.TABLE[168] = 353;
            Decoder.TABLE[170] = 536;
            Decoder.TABLE[172] = 377;
            Decoder.TABLE[174] = 378;
            Decoder.TABLE[175] = 379;
            Decoder.TABLE[178] = 268;
            Decoder.TABLE[179] = 322;
            Decoder.TABLE[180] = 381;
            Decoder.TABLE[181] = 8221;
            Decoder.TABLE[184] = 382;
            Decoder.TABLE[185] = 269;
            Decoder.TABLE[186] = 537;
            Decoder.TABLE[188] = 338;
            Decoder.TABLE[189] = 339;
            Decoder.TABLE[190] = 376;
            Decoder.TABLE[191] = 380;
            Decoder.TABLE[195] = 258;
            Decoder.TABLE[197] = 262;
            Decoder.TABLE[209] = 272;
            Decoder.TABLE[210] = 323;
            Decoder.TABLE[213] = 336;
            Decoder.TABLE[215] = 346;
            Decoder.TABLE[216] = 368;
            Decoder.TABLE[221] = 280;
            Decoder.TABLE[222] = 538;
            Decoder.TABLE[227] = 259;
            Decoder.TABLE[229] = 263;
        }
    }
}

