/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import java.util.HashMap;
import org.apache.batik.anim.timing.InstanceTime;
import org.apache.batik.anim.timing.Interval;
import org.apache.batik.anim.timing.OffsetTimingSpecifier;
import org.apache.batik.anim.timing.TimedElement;

public class SyncbaseTimingSpecifier
extends OffsetTimingSpecifier {
    protected String syncbaseID;
    protected TimedElement syncbaseElement;
    protected boolean syncBegin;
    protected HashMap instances = new HashMap();

    public SyncbaseTimingSpecifier(TimedElement timedElement, boolean bl, float f, String string, boolean bl2) {
        super(timedElement, bl, f);
        this.syncbaseID = string;
        this.syncBegin = bl2;
        this.syncbaseElement = timedElement.getTimedElementById(string);
        this.syncbaseElement.addDependent(this, bl2);
    }

    public String toString() {
        return this.syncbaseID + "." + (this.syncBegin ? "begin" : "end") + (this.offset != 0.0f ? super.toString() : "");
    }

    public void initialize() {
    }

    public boolean isEventCondition() {
        return false;
    }

    float newInterval(Interval interval) {
        if (this.owner.hasPropagated) {
            return Float.POSITIVE_INFINITY;
        }
        InstanceTime instanceTime = new InstanceTime(this, (this.syncBegin ? interval.getBegin() : interval.getEnd()) + this.offset, true);
        this.instances.put(interval, instanceTime);
        interval.addDependent(instanceTime, this.syncBegin);
        return this.owner.addInstanceTime(instanceTime, this.isBegin);
    }

    float removeInterval(Interval interval) {
        if (this.owner.hasPropagated) {
            return Float.POSITIVE_INFINITY;
        }
        InstanceTime instanceTime = (InstanceTime)this.instances.get(interval);
        interval.removeDependent(instanceTime, this.syncBegin);
        return this.owner.removeInstanceTime(instanceTime, this.isBegin);
    }

    float handleTimebaseUpdate(InstanceTime instanceTime, float f) {
        if (this.owner.hasPropagated) {
            return Float.POSITIVE_INFINITY;
        }
        return this.owner.instanceTimeChanged(instanceTime, this.isBegin);
    }
}

