/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mzn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_MD = "\u0645\u0648\u0644\u062f\u0627\u0648\u06cc";
        final String metaValue_SK = "\u0627\u0633\u0644\u0648\u0627\u06a9\u06cc";
        final String metaValue_ar = "\u0639\u0631\u0628\u06cc";
        final String metaValue_bn = "\u0628\u0646\u06af\u0627\u0644\u06cc";
        final String metaValue_el = "\u06cc\u0648\u0646\u0627\u0646\u06cc";
        final String metaValue_gu = "\u06af\u062c\u0631\u0627\u062a\u06cc";
        final String metaValue_he = "\u0639\u0628\u0631\u06cc";
        final String metaValue_hy = "\u0627\u0631\u0645\u0646\u06cc";
        final String metaValue_ja = "\u062c\u0627\u067e\u0648\u0646\u06cc";
        final String metaValue_ka = "\u06af\u0631\u062c\u06cc";
        final Object[][] data = new Object[][] {
            { "sbp", "\u0633\u0627\u0646\u06af\u0648\u0648" },
            { "nyn", "\u0646\u06cc\u0627\u0646\u06a9\u0648\u0644\u0647" },
            { "luo", "\u0644\u0648\u0626\u0648" },
            { "fil", "\u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646\u0648" },
            { "luy", "\u0644\u0648\u06cc\u06cc\u0627" },
            { "es_ES", "\u0627\u0631\u0648\u067e\u0627\u06cc \u0650\u0627\u06cc\u0633\u067e\u0627\u0646\u06cc\u0648\u0644\u06cc" },
            { "teo", "\u062a\u0633\u0648\u06cc\u06cc" },
            { "ab", "\u0622\u0628\u062e\u0627\u0632\u06cc" },
            { "AC", "\u0622\u0633\u0646\u0633\u06cc\u0648\u0646 \u062c\u0632\u06cc\u0631\u0647" },
            { "AD", "\u0622\u0646\u062f\u0648\u0631\u0627" },
            { "AE", "\u0645\u062a\u062d\u062f\u0647 \u0639\u0631\u0628\u06cc \u0627\u0645\u0627\u0631\u0627\u062a" },
            { "nl_BE", "\u0641\u0644\u0645\u06cc\u0634" },
            { "AF", "\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0648\u0646" },
            { "af", "\u0622\u0641\u0631\u06cc\u06a9\u0627\u0646\u0633" },
            { "AG", "\u0622\u0646\u062a\u06cc\u06af\u0648\u0627 \u0648 \u0628\u0627\u0631\u0628\u0648\u062f\u0627" },
            { "AI", "\u0622\u0646\u06af\u0648\u06cc\u0644\u0627" },
            { "ak", "\u0622\u06a9\u0627\u0646" },
            { "AL", "\u0622\u0644\u0628\u0627\u0646\u06cc" },
            { "AM", "\u0627\u0631\u0645\u0646\u0633\u062a\u0648\u0646" },
            { "am", "\u0627\u0645\u0647\u0631\u06cc" },
            { "Arab", metaValue_ar },
            { "AO", "\u0622\u0646\u06af\u0648\u0644\u0627" },
            { "Jpan", metaValue_ja },
            { "AQ", "\u062c\u0646\u0648\u0628\u06cc \u06cc\u062e\u200c\u0628\u0632\u0647 \u0642\u0637\u0628" },
            { "ar", metaValue_ar },
            { "AR", "\u0622\u0631\u0698\u0627\u0646\u062a\u06cc\u0646" },
            { "AS", "\u0622\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0650\u0633\u0627\u0645\u0648\u0622" },
            { "as", "\u0622\u0633\u0627\u0645\u06cc" },
            { "AT", "\u0627\u062a\u0631\u06cc\u0634" },
            { "AU", "\u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627" },
            { "AW", "\u0622\u0631\u0648\u0628\u0627" },
            { "sdh", "\u062c\u0646\u0648\u0628\u06cc \u06a9\u0631\u062f\u06cc" },
            { "en_US", "\u0627\u0645\u0631\u06cc\u06a9\u0646 \u0627\u0646\u06af\u0644\u06cc\u0633\u06cc" },
            { "AX", "\u0622\u0644\u0646\u062f \u062c\u0632\u06cc\u0631\u0647" },
            { "AZ", "\u0622\u0630\u0631\u0628\u0627\u06cc\u062c\u0648\u0646" },
            { "az", "\u0622\u0630\u0631\u06cc \u0650\u062a\u0631\u06a9\u06cc" },
            { "BA", "\u0628\u0648\u0633\u0646\u06cc \u0648 \u0647\u0631\u0632\u06af\u0648\u06cc\u0646" },
            { "ba", "\u0628\u0627\u0634\u0642\u06cc\u0631\u06cc" },
            { "BB", "\u0628\u0627\u0631\u0628\u0627\u062f\u0648\u0633" },
            { "BD", "\u0628\u0646\u06af\u0644\u0627\u062f\u0634" },
            { "BE", "\u0628\u0644\u0698\u06cc\u06a9" },
            { "be", "\u0628\u0644\u0627\u0631\u0648\u0633\u06cc" },
            { "BF", "\u0628\u0648\u0631\u06a9\u06cc\u0646\u0627 \u0641\u0627\u0633\u0648" },
            { "BG", "\u0628\u0644\u063a\u0627\u0631\u0633\u062a\u0648\u0646" },
            { "bg", "\u0628\u0644\u063a\u0627\u0631\u06cc" },
            { "BH", "\u0628\u062d\u0631\u06cc\u0646" },
            { "BI", "\u0628\u0648\u0631\u0648\u0646\u062f\u06cc" },
            { "BJ", "\u0628\u0646\u06cc\u0646" },
            { "BL", "\u0633\u0646\u062a \u0628\u0627\u0631\u062a\u0644\u0645\u06cc" },
            { "BM", "\u0628\u0631\u0645\u0648\u062f\u0627" },
            { "bm", "\u0628\u0627\u0645\u0628\u0627\u0631\u0627\u06cc\u06cc" },
            { "bn", metaValue_bn },
            { "BN", "\u0628\u0631\u0648\u0646\u0626\u06cc" },
            { "BO", "\u0628\u0648\u0644\u06cc\u0648\u06cc" },
            { "bo", "\u062a\u0628\u062a\u06cc" },
            { "BQ", "\u0647\u0644\u0646\u062f \u0650\u06a9\u0627\u0631\u0627\u06cc\u06cc\u0628\u06cc \u062c\u0632\u0627\u06cc\u0631" },
            { "BR", "\u0628\u0631\u0632\u06cc\u0644" },
            { "br", "\u0628\u0631\u0650\u062a\u0648\u0646\u06cc" },
            { "BS", "\u0628\u0627\u0647\u0627\u0645\u0627" },
            { "bs", "\u0628\u0648\u0633\u0646\u06cc\u0627\u06cc\u06cc" },
            { "xog", "\u0633\u0648\u06af\u0627" },
            { "BT", "\u0628\u0648\u062a\u0627\u0646" },
            { "BV", "\u0628\u0648\u0648\u062a \u062c\u0632\u06cc\u0631\u0647" },
            { "BW", "\u0628\u0648\u062a\u0633\u0627\u0648\u0627\u0646\u0627" },
            { "BY", "\u0628\u0644\u0627\u0631\u0648\u0633" },
            { "seh", "\u0633\u0650\u0646\u0627\u06cc\u06cc" },
            { "BZ", "\u0628\u0644\u06cc\u0632" },
            { "CA", "\u06a9\u0627\u0646\u0627\u062f\u0627" },
            { "ca", "\u06a9\u0627\u062a\u0627\u0644\u0648\u0646\u06cc" },
            { "CC", "\u06a9\u0648\u06a9 (\u06a9\u06cc\u0644\u06cc\u0646\u06af) \u062c\u0632\u0627\u06cc\u0631" },
            { "mzn", "\u0645\u0627\u0632\u0631\u0648\u0646\u06cc" },
            { "ses", "\u06a9\u0648\u06cc\u0631\u0627\u0628\u0648\u0631\u0627 \u0633\u0646\u06cc" },
            { "CD", "\u06a9\u0646\u06af\u0648 \u06a9\u06cc\u0646\u0634\u0627\u0633\u0627" },
            { "ce", "\u0686\u0686\u0646\u06cc" },
            { "CF", "\u0645\u0631\u06a9\u0632\u06cc \u0622\u0641\u0631\u06cc\u0642\u0627\u06cc \u062c\u0645\u0647\u0648\u0631\u06cc" },
            { "CG", "\u06a9\u0646\u06af\u0648 \u0628\u0631\u0627\u0632\u0627\u0648\u06cc\u0644" },
            { "CH", "\u0633\u0648\u06cc\u06cc\u0633" },
            { "CI", "\u0639\u0627\u062c \u0650\u0633\u0627\u062d\u0644" },
            { "CK", "\u06a9\u0648\u06a9 \u062c\u0632\u0627\u06cc\u0631" },
            { "CL", "\u0634\u06cc\u0644\u06cc" },
            { "CM", "\u06a9\u0627\u0645\u0631\u0648\u0646" },
            { "CN", "\u0686\u06cc\u0646" },
            { "CO", "\u06a9\u0644\u0645\u0628\u06cc\u0627" },
            { "co", "\u06a9\u0648\u0631\u0633\u06cc\u06a9\u0627\u0646" },
            { "CP", "\u06a9\u0644\u06cc\u067e\u0631\u062a\u0648\u0646 \u062c\u0632\u06cc\u0631\u0647" },
            { "CR", "\u06a9\u0627\u0633\u062a\u0627\u0631\u06cc\u06a9\u0627" },
            { "cs", "\u0686\u06a9\u06cc" },
            { "CU", "\u06a9\u0648\u0628\u0627" },
            { "CV", "\u06a9\u06cc\u067e \u0648\u0631\u062f" },
            { "cv", "\u0686\u0648\u0648\u0627\u0634\u06cc" },
            { "CW", "\u06a9\u0648\u0631\u0627\u0633\u0627\u0626\u0648" },
            { "CX", "\u06a9\u0631\u06cc\u0633\u0645\u0633 \u062c\u0632\u06cc\u0631\u0647" },
            { "CY", "\u0642\u0628\u0631\u0633" },
            { "cy", "\u0648\u0644\u0632\u06cc" },
            { "CZ", "\u0686\u06a9 \u062c\u0645\u0647\u0648\u0631\u06cc" },
            { "da", "\u062f\u0627\u0646\u0645\u0627\u0631\u06a9\u06cc" },
            { "pt_PT", "\u0627\u0631\u0648\u067e\u0627\u06cc \u0650\u067e\u0631\u062a\u063a\u0627\u0644\u06cc" },
            { "DE", "\u0622\u0644\u0645\u0627\u0646" },
            { "de", "\u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "cgg", "\u0686\u06cc\u06af\u0627" },
            { "DG", "\u062f\u06cc\u06af\u0648 \u06af\u0627\u0631\u0633\u06cc\u0627" },
            { "DJ", "\u062c\u06cc\u0628\u0648\u062a\u06cc" },
            { "DK", "\u062f\u0627\u0646\u0645\u0627\u0631\u06a9" },
            { "DM", "\u062f\u0648\u0645\u0646\u06cc\u06a9\u0627" },
            { "DO", "\u062f\u0648\u0645\u0646\u06cc\u06a9\u0646 \u062c\u0645\u0647\u0648\u0631\u06cc" },
            { "bem", "\u0628\u0645\u0628\u0627\u06cc\u06cc" },
            { "es_419", "\u062c\u0646\u0648\u0628\u06cc \u0622\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0650\u0627\u06cc\u0633\u067e\u0627\u0646\u06cc\u0648\u0644\u06cc" },
            { "DZ", "\u0627\u0644\u062c\u0632\u06cc\u0631\u0647" },
            { "dz", "\u062f\u0632\u0648\u0646\u06af\u062e\u0627" },
            { "bez", "\u0628\u0646\u0627\u06cc\u06cc" },
            { "EA", "\u0633\u0648\u062a\u0627 \u0648 \u0645\u0644\u06cc\u0644\u0647" },
            { "EC", "\u0627\u06a9\u0648\u0627\u062f\u0631" },
            { "dje", "\u0632\u0627\u0631\u0645\u0627\u06cc\u06cc" },
            { "EE", "\u0627\u0633\u062a\u0648\u0646\u06cc" },
            { "ee", "\u0627\u0648\u0647\u200c\u06cc\u06cc" },
            { "EG", "\u0645\u0635\u0631" },
            { "ro_MD", metaValue_MD },
            { "EH", "\u063a\u0631\u0628\u06cc \u0635\u062d\u0631\u0627" },
            { "el", metaValue_el },
            { "en", "\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc" },
            { "eo", "\u0627\u0633\u067e\u0631\u0627\u0646\u062a\u0648" },
            { "chr", "\u0686\u0631\u0648\u06a9\u06cc\u0627\u06cc\u06cc" },
            { "ER", "\u0627\u0631\u06cc\u062a\u0631\u0647" },
            { "ES", "\u0627\u06cc\u0633\u067e\u0627\u0646\u06cc\u0627" },
            { "es", "\u0627\u06cc\u0633\u067e\u0627\u0646\u06cc\u0648\u0644\u06cc" },
            { "ET", "\u0627\u062a\u06cc\u0648\u067e\u06cc" },
            { "et", "\u0627\u0633\u062a\u0648\u0646\u06cc\u0627\u06cc\u06cc" },
            { "EU", "\u0627\u0631\u0648\u067e\u0627 \u0627\u062a\u062d\u0627\u062f\u06cc\u0647" },
            { "eu", "\u0628\u0627\u0633\u06a9\u06cc" },
            { "Hang", "\u0647\u0627\u0646\u06af\u0648\u0644" },
            { "shi", "\u062a\u0627\u0686\u0644\u0647\u06cc\u062a" },
            { "hsb", "\u0628\u0627\u0644\u0627\u06cc\u06cc \u0635\u0631\u0628\u06cc" },
            { "Hani", "\u0647\u0627\u0646" },
            { "fa", "\u0641\u0627\u0631\u0633\u06cc" },
            { "Hans", "\u0633\u0627\u062f\u0647\u200c\u0628\u064e\u06cc\u06cc \u0647\u0627\u0646" },
            { "Hant", "\u0633\u0646\u062a\u06cc \u0647\u0627\u0646\u062a" },
            { "az_Arab", "\u062c\u0646\u0648\u0628\u06cc \u0622\u0630\u0631\u06cc \u062a\u0631\u06a9\u06cc" },
            { "FI", "\u0641\u0646\u0644\u0627\u0646\u062f" },
            { "fi", "\u0641\u06cc\u0646\u06cc\u0634" },
            { "FJ", "\u0641\u06cc\u062c\u06cc" },
            { "fj", "\u0641\u06cc\u062c\u06cc\u0627\u06cc\u06cc" },
            { "FK", "\u0641\u0627\u0644\u06a9\u0644\u0646\u062f \u062c\u0632\u06cc\u0631\u0647\u200c\u0626\u0648\u0646" },
            { "FM", "\u0645\u06cc\u06a9\u0631\u0648\u0646\u0632\u06cc" },
            { "bgn", "\u063a\u0631\u0628\u06cc \u0628\u0644\u0648\u0686\u06cc" },
            { "FO", "\u0641\u0627\u0631\u0648 \u062c\u0632\u0627\u06cc\u0631" },
            { "fo", "\u0641\u0627\u0631\u0648\u06cc\u06cc" },
            { "FR", "\u0641\u0631\u0627\u0646\u0633\u0647" },
            { "fr", "\u0641\u0631\u0627\u0646\u0633\u0648\u06cc" },
            { "fy", "\u063a\u0631\u0628\u06cc \u0641\u06cc\u0631\u06cc\u0632\u06cc" },
            { "GA", "\u06af\u0627\u0628\u0648\u0646" },
            { "ga", "\u0627\u06cc\u0631\u06cc\u0634" },
            { "GB", "\u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "GD", "\u06af\u0631\u0627\u0646\u0627\u062f\u0627" },
            { "GE", "\u06af\u0631\u062c\u0633\u062a\u0648\u0646" },
            { "GF", "\u0641\u0631\u0627\u0646\u0633\u0647\u200c\u06cc \u0650\u06af\u0648\u06cc\u0627\u0646" },
            { "GG", "\u06af\u0631\u0646\u0632\u06cc" },
            { "GH", "\u063a\u0646\u0627" },
            { "GI", "\u062c\u0628\u0644 \u0637\u0627\u0631\u0642" },
            { "GL", "\u06af\u0631\u06cc\u0646\u0644\u0646\u062f" },
            { "gl", "\u06af\u0627\u0644\u06cc\u06a9" },
            { "GM", "\u06af\u0627\u0645\u0628\u06cc\u0627" },
            { "GN", "\u06af\u06cc\u0646\u0647" },
            { "gn", "\u06af\u0648\u0631\u0627\u0646\u06cc" },
            { "GP", "\u06af\u0648\u0627\u062f\u0644\u0648\u067e" },
            { "GQ", "\u0627\u0633\u062a\u0648\u0627\u06cc\u06cc \u06af\u06cc\u0646\u0647" },
            { "und", "\u0646\u0634\u0646\u0627\u0633\u06cc\u200c\u06cc\u0647 \u0632\u0648\u0648\u0646" },
            { "GR", "\u06cc\u0648\u0646\u0627\u0646" },
            { "GS", "\u062c\u0646\u0648\u0628\u06cc \u062c\u0648\u0631\u062c\u06cc\u0627 \u0648 \u062c\u0646\u0648\u0628\u06cc \u0633\u0627\u0646\u062f\u0648\u06cc\u0686 \u062c\u0632\u0627\u06cc\u0631" },
            { "GT", "\u06af\u0648\u0627\u062a\u0645\u0627\u0644\u0627" },
            { "gu", metaValue_gu },
            { "GU", "\u06af\u0648\u0626\u0627\u0645" },
            { "gv", "\u0645\u0627\u0646\u06a9\u0633" },
            { "GW", "\u06af\u06cc\u0646\u0647 \u0628\u06cc\u0633\u0627\u0626\u0648" },
            { "GY", "\u06af\u0648\u06cc\u0627\u0646" },
            { "ha", "\u0647\u0648\u0633\u0627" },
            { "ckb", "\u0645\u06cc\u0648\u0646\u06cc \u06a9\u0648\u0631\u062f\u06cc" },
            { "zxx", "\u0627\u06cc\u0646 \u0632\u0648\u0648\u0646 \u0628\u0634\u0646\u0627\u0633\u06cc\u200c\u06cc\u0647 \u0646\u06cc\u0651\u0647" },
            { "he", metaValue_he },
            { "hi", "\u0647\u0646\u062f\u06cc" },
            { "de_AT", "\u0627\u062a\u0631\u06cc\u0634 \u0650\u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "HK", "\u0647\u0646\u06af \u06a9\u0646\u06af" },
            { "HM", "\u0647\u0627\u0631\u062f \u0648 \u0645\u06a9\u200c\u062f\u0648\u0646\u0627\u0644\u062f \u062c\u0632\u0627\u06cc\u0631" },
            { "HN", "\u0647\u0646\u062f\u0648\u0631\u0627\u0633" },
            { "HR", "\u06a9\u0631\u0648\u0627\u0633\u06cc" },
            { "hr", "\u06a9\u0631\u0648\u0627\u062a\u06cc" },
            { "agq", "\u0622\u0642\u0645" },
            { "gsw", "\u0633\u0648\u06cc\u06cc\u0633 \u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "HT", "\u0647\u0627\u06cc\u06cc\u062a\u06cc" },
            { "ht", "\u0647\u0627\u0626\u062a\u06cc\u0627\u06cc\u06cc" },
            { "HU", "\u0645\u062c\u0627\u0631\u0633\u062a\u0648\u0646" },
            { "hu", "\u0645\u062c\u0627\u0631\u06cc" },
            { "hy", metaValue_hy },
            { "IC", "\u0642\u0646\u0627\u0631\u06cc \u062c\u0632\u0627\u06cc\u0631" },
            { "ID", "\u0627\u0646\u062f\u0648\u0646\u0632\u06cc" },
            { "id", "\u0627\u0646\u062f\u0648\u0646\u0632\u06cc\u0627\u06cc\u06cc" },
            { "IE", "\u0627\u06cc\u0631\u0644\u0646\u062f" },
            { "ig", "\u0627\u06cc\u06af\u0628\u0648" },
            { "naq", "\u0646\u0627\u0645\u0627" },
            { "ii", "\u0633\u06cc\u0686\u0648\u0626\u0627\u0646 \u06cc\u06cc" },
            { "IL", "\u0627\u06cc\u0633\u0631\u0627\u06cc\u06cc\u0644" },
            { "IM", "\u0645\u0646 \u0650\u062c\u0632\u06cc\u0631\u0647" },
            { "IN", "\u0647\u0646\u062f" },
            { "IO", "\u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627\u06cc \u0647\u0646\u062f \u0650\u0627\u0648\u0642\u06cc\u0627\u0646\u0648\u0633 \u0650\u0645\u0646\u0627\u0637\u0642" },
            { "IQ", "\u0639\u0631\u0627\u0642" },
            { "IR", "\u0627\u06cc\u0631\u0627\u0646" },
            { "IS", "\u0627\u06cc\u0633\u0644\u0646\u062f" },
            { "is", "\u0627\u06cc\u0633\u0644\u0646\u062f\u06cc" },
            { "IT", "\u0627\u06cc\u062a\u0627\u0644\u06cc\u0627" },
            { "it", "\u0627\u06cc\u062a\u0627\u0644\u06cc\u0627\u06cc\u06cc" },
            { "iu", "\u0627\u0646\u0648\u06a9\u062a\u06cc\u062a\u0648\u062a" },
            { "ja", metaValue_ja },
            { "JE", "\u062c\u0631\u0633\u06cc" },
            { "Beng", metaValue_bn },
            { "JM", "\u062c\u0627\u0645\u0627\u06cc\u06cc\u06a9\u0627" },
            { "JO", "\u0627\u0631\u062f\u0646" },
            { "JP", "\u062c\u0627\u067e\u0648\u0646" },
            { "sma", "\u062c\u0646\u0648\u0628\u06cc \u0633\u0627\u0645\u06cc" },
            { "jv", "\u062c\u0627\u0648\u0627\u06cc\u06cc" },
            { "guz", "\u06af\u0648\u0633\u06cc" },
            { "smj", "\u0644\u0648\u0644\u0647 \u0633\u0627\u0645\u06cc" },
            { "de_CH", "\u0633\u0648\u06cc\u06cc\u0633 \u0650\u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "smn", "\u0627\u06cc\u0646\u0627\u0631\u06cc \u0633\u0627\u0645\u06cc" },
            { "ka", metaValue_ka },
            { "sms", "\u0633\u06a9\u0648\u0644\u062a \u0633\u0627\u0645\u06cc" },
            { "KE", "\u06a9\u0646\u06cc\u0627" },
            { "419", "\u0644\u0627\u062a\u06cc\u0646 \u0622\u0645\u0631\u06cc\u06a9\u0627" },
            { "KG", "\u0642\u0631\u0642\u06cc\u0632\u0633\u062a\u0648\u0646" },
            { "KH", "\u06a9\u0627\u0645\u0628\u0648\u062c" },
            { "KI", "\u06a9\u06cc\u0631\u06cc\u0628\u0627\u062a\u06cc" },
            { "ki", "\u06a9\u06cc\u06a9\u0648\u06cc\u0648" },
            { "mas", "\u0645\u0627\u0633\u0627\u06cc\u06cc" },
            { "kk", "\u0642\u0632\u0627\u0642\u06cc" },
            { "kl", "\u06a9\u0627\u0644\u0627\u0626\u0644\u06cc\u0633\u0648\u062a" },
            { "KM", "\u06a9\u0648\u0645\u0648\u0631" },
            { "km", "\u062e\u0645\u0631\u06cc" },
            { "KN", "\u0633\u0646\u062a \u06a9\u06cc\u062a\u0633 \u0648 \u0646\u0648\u06cc\u0633" },
            { "kn", "\u06a9\u0627\u0646\u0651\u0627\u062f\u0627" },
            { "fr_CA", "\u06a9\u0627\u0646\u0627\u062f\u0627\u06cc \u0650\u0641\u0631\u0627\u0646\u0633\u0648\u06cc" },
            { "ko", "\u06a9\u064f\u0631\u0647\u200c\u06cc\u06cc" },
            { "KP", "\u0634\u0645\u0627\u0644\u06cc \u06a9\u064f\u0631\u0647" },
            { "KR", "\u062c\u0646\u0648\u0628\u06cc \u06a9\u064f\u0631\u0647" },
            { "ks", "\u06a9\u0634\u0645\u06cc\u0631\u06cc" },
            { "ku", "\u06a9\u0648\u0631\u062f\u06cc" },
            { "fr_CH", "\u0633\u0648\u06cc\u06cc\u0633 \u0650\u0641\u0631\u0627\u0646\u0633\u0648\u06cc" },
            { "KW", "\u06a9\u0648\u06cc\u062a" },
            { "kw", "\u06a9\u0648\u0631\u0646\u06cc\u0634" },
            { "KY", "\u06a9\u06cc\u0645\u0646 \u062c\u0632\u06cc\u0631\u0647\u200c\u0626\u0648\u0646" },
            { "ky", "\u0642\u0631\u0642\u06cc\u0632\u06cc" },
            { "KZ", "\u0642\u0632\u0627\u0642\u0633\u062a\u0648\u0646" },
            { "Cyrl", "\u0633\u06cc\u0631\u06cc\u0644\u06cc\u06a9" },
            { "LA", "\u0644\u0627\u0626\u0648\u0633" },
            { "la", "\u0644\u0627\u062a\u06cc\u0646" },
            { "LB", "\u0644\u0628\u0646\u0627\u0646" },
            { "lb", "\u0644\u0648\u06a9\u0632\u0627\u0645\u0628\u0648\u0631\u06af\u06cc" },
            { "LC", "\u0633\u0646\u062a \u0644\u0648\u0633\u06cc\u0627" },
            { "lg", "\u06af\u0627\u0646\u062f\u0627" },
            { "nds", "\u067e\u0627\u06cc\u06cc\u0646 \u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "LI", "\u0644\u06cc\u062e\u062a\u0646 \u0627\u0634\u062a\u0627\u06cc\u0646" },
            { "LK", "\u0633\u0631\u06cc\u0644\u0627\u0646\u06a9\u0627" },
            { "ln", "\u0644\u06cc\u0646\u06af\u0627\u0644\u0627" },
            { "lo", "\u0644\u0627\u0626\u0648\u06cc\u06cc" },
            { "LR", "\u0644\u06cc\u0628\u0631\u06cc\u0627" },
            { "LS", "\u0644\u0633\u0648\u062a\u0648" },
            { "LT", "\u0644\u062a\u0648\u0646\u06cc" },
            { "lt", "\u0644\u062a\u0648\u0646\u06cc\u0627\u06cc\u06cc" },
            { "LU", "\u0644\u0648\u06a9\u0632\u0627\u0645\u0628\u0648\u0631\u06af" },
            { "lu", "\u0644\u0648\u0628\u0627-\u06a9\u0627\u062a\u0627\u0646\u06af\u0627" },
            { "LV", "\u0644\u0627\u062a\u0648\u06cc\u0627" },
            { "lv", "\u0644\u0627\u062a\u0648\u06cc\u0627\u06cc\u06cc" },
            { "Kana", "\u06a9\u0627\u062a\u0627\u06a9\u0627\u0646\u0627" },
            { "LY", "\u0644\u06cc\u0628\u06cc" },
            { "vun", "\u0648\u0648\u0646\u062c\u0648\u06cc\u06cc" },
            { "lag", "\u0644\u0627\u0646\u06af\u06cc" },
            { "MA", "\u0645\u0631\u0627\u06a9\u0634" },
            { "MC", "\u0645\u0648\u0646\u0627\u06a9\u0648" },
            { "MD", metaValue_MD },
            { "ME", "\u0645\u0648\u0646\u062a\u0647\u200c\u0646\u06af\u0631\u0648" },
            { "MF", "\u0633\u0646\u062a \u0645\u0627\u0631\u062a\u06cc\u0646" },
            { "MG", "\u0645\u0627\u062f\u0627\u06af\u0627\u0633\u06a9\u0627\u0631" },
            { "mg", "\u0645\u0627\u0644\u0627\u06af\u0627\u0633\u06cc" },
            { "MH", "\u0645\u0627\u0631\u0634\u0627\u0644 \u062c\u0632\u0627\u06cc\u0631" },
            { "mi", "\u0645\u0627\u0626\u0648\u0631\u06cc" },
            { "mk", "\u0645\u0642\u062f\u0648\u0646\u06cc" },
            { "ML", "\u0645\u0627\u0644\u06cc" },
            { "ml", "\u0645\u0627\u0644\u0627\u06cc\u0627\u0644\u0627\u0645" },
            { "MM", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631" },
            { "MN", "\u0645\u063a\u0648\u0644\u0633\u062a\u0648\u0646" },
            { "mn", "\u0645\u063a\u0648\u0644\u06cc" },
            { "MO", "\u0645\u0627\u06a9\u0627\u0626\u0648 (\u0686\u06cc\u0646 \u062f\u0644\u0647)" },
            { "MP", "\u0634\u0645\u0627\u0644\u06cc \u0645\u0627\u0631\u06cc\u0627\u0646\u0627 \u062c\u0632\u0627\u06cc\u0631" },
            { "MQ", "\u0645\u0627\u0631\u062a\u06cc\u0646\u06cc\u06a9 \u062c\u0632\u06cc\u0631\u0647\u200c\u0626\u0648\u0646" },
            { "MR", "\u0645\u0648\u0631\u06cc\u062a\u0627\u0646\u06cc" },
            { "mr", "\u0645\u0627\u0631\u0627\u062a\u06cc" },
            { "MS", "\u0645\u0648\u0646\u062a\u0633\u0631\u0627\u062a" },
            { "ms", "\u0645\u0627\u0644\u0627\u06cc\u06cc" },
            { "MT", "\u0645\u0627\u0644\u062a" },
            { "mt", "\u0645\u0627\u0644\u062a\u06cc" },
            { "MU", "\u0645\u0648\u0631\u0649 \u062a\u064a\u0648\u0633" },
            { "MV", "\u0645\u0627\u0644\u062f\u06cc\u0648" },
            { "MW", "\u0645\u0627\u0644\u0627\u0648\u06cc" },
            { "MX", "\u0645\u06a9\u0632\u06cc\u06a9" },
            { "MY", "\u0645\u0627\u0644\u0632\u06cc" },
            { "my", "\u0628\u0631\u0645\u0647\u200c\u06cc\u06cc" },
            { "Armn", metaValue_hy },
            { "MZ", "\u0645\u0648\u0632\u0627\u0645\u0628\u06cc\u06a9" },
            { "dsb", "\u067e\u0627\u06cc\u06cc\u0646 \u0635\u0631\u0628\u06cc" },
            { "NA", "\u0646\u0627\u0645\u0628\u06cc\u0627" },
            { "nb", "\u0646\u0631\u0648\u0698\u06cc \u0628\u0648\u06a9\u0645\u0627\u0644" },
            { "NC", "\u0646\u06cc\u0648 \u06a9\u0627\u0644\u06cc\u062f\u0648\u0646\u06cc\u0627" },
            { "nd", "\u0634\u0645\u0627\u0644\u06cc \u0646\u062f\u0628\u0644\u0647" },
            { "NE", "\u0646\u06cc\u062c\u0631" },
            { "ne", "\u0646\u067e\u0627\u0644\u06cc" },
            { "NF", "\u0646\u0648\u0631\u0641\u0648\u0644\u06a9 \u062c\u0632\u06cc\u0631\u0647" },
            { "NG", "\u0646\u06cc\u062c\u0631\u06cc\u0647" },
            { "NI", "\u0646\u06cc\u06a9\u0627\u0631\u0627\u06af\u0648\u0626\u0647" },
            { "NL", "\u0647\u0644\u0646\u062f" },
            { "nl", "\u0647\u0644\u0646\u062f\u06cc" },
            { "nn", "\u0646\u0631\u0648\u0698\u06cc \u0646\u06cc\u0646\u0648\u0631\u0633\u06a9" },
            { "NO", "\u0646\u0631\u0648\u0698" },
            { "NP", "\u0646\u067e\u0627\u0644" },
            { "NR", "\u0646\u0627\u0626\u0648\u0631\u0648" },
            { "NU", "\u0646\u06cc\u0626\u0648" },
            { "rof", "\u0631\u0648\u0645\u0628\u0648" },
            { "NZ", "\u0646\u06cc\u0648\u0632\u0644\u0646\u062f" },
            { "kab", "\u0642\u0628\u0627\u06cc\u0644\u06cc" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627\u06cc\u06cc" },
            { "mer", "\u0645\u0650\u0631\u0648\u06cc\u06cc" },
            { "OM", "\u0639\u0645\u0627\u0646" },
            { "om", "\u0627\u0648\u0631\u0648\u0645\u0648" },
            { "or", "\u0627\u0648\u0631\u06cc\u0627" },
            { "mfe", "\u0645\u0648\u0631\u06cc\u0633\u06cc\u0646" },
            { "PA", "\u067e\u0627\u0646\u0627\u0645\u0627" },
            { "pa", "\u067e\u0646\u062c\u0627\u0628\u06cc" },
            { "dua", "\u062f\u0648\u0626\u0627\u0644\u0627\u06cc\u06cc" },
            { "en_GB", "\u0628\u0631\u06cc\u062a\u06cc\u0634 \u0627\u0646\u06af\u0644\u06cc\u0633\u06cc" },
            { "PE", "\u067e\u0631\u0648" },
            { "PF", "\u0641\u0631\u0627\u0646\u0633\u0647\u200c\u06cc \u067e\u0648\u0644\u06cc\u200c\u0646\u0632\u06cc" },
            { "PG", "\u067e\u0627\u067e\u0648\u0627 \u0646\u0648 \u06af\u06cc\u0646\u0647" },
            { "PH", "\u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646" },
            { "PK", "\u067e\u0627\u06a9\u0633\u062a\u0648\u0646" },
            { "PL", "\u0644\u0647\u0633\u062a\u0648\u0646" },
            { "pl", "\u0644\u0647\u0633\u062a\u0648\u0646\u06cc" },
            { "PM", "\u0633\u0646 \u067e\u06cc\u06cc\u0631 \u0648 \u0645\u06cc\u06a9\u0644\u0646" },
            { "PN", "\u067e\u06cc\u062a\u06a9\u0627\u0631\u06cc\u0646 \u062c\u0632\u0627\u06cc\u0631" },
            { "PR", "\u067e\u0648\u0631\u062a\u0648\u0631\u06cc\u06a9\u0648" },
            { "PS", "\u0641\u0644\u0633\u0637\u06cc\u0646 \u0650\u0633\u0631\u0632\u0645\u06cc\u0646" },
            { "ps", "\u067e\u0634\u062a\u0648" },
            { "PT", "\u067e\u0631\u062a\u063a\u0627\u0644" },
            { "pt", "\u067e\u0631\u062a\u063a\u0627\u0644\u06cc" },
            { "PW", "\u067e\u0627\u0644\u0627\u0626\u0648" },
            { "PY", "\u067e\u0627\u0631\u0627\u06af\u0648\u0626\u0647" },
            { "pt_BR", "\u0628\u0631\u0632\u06cc\u0644 \u0650\u067e\u0631\u062a\u063a\u0627\u0644\u06cc" },
            { "Hebr", metaValue_he },
            { "mgh", "\u0645\u0627\u062e\u0648\u0626\u0627-\u0645\u06cc\u062a\u0648" },
            { "QA", "\u0642\u0637\u0631" },
            { "mgo", "\u0645\u0650\u062a\u0627\u0621" },
            { "QO", "\u0627\u0648\u0642\u06cc\u0627\u0646\u0648\u0633\u06cc\u0647\u200c\u06cc \u0650\u067e\u0631\u062a \u0650\u062c\u0627\u0626\u0648\u0646" },
            { "qu", "\u0642\u0648\u0626\u0686\u0648\u0626\u0627" },
            { "brx", "\u0628\u062f\u0648\u06cc\u06cc" },
            { "kde", "\u0645\u0627\u06a9\u0648\u0646\u062f\u0647" },
            { "001", "\u062c\u0647\u0648\u0646" },
            { "Ethi", "\u0627\u062a\u06cc\u0648\u067e\u06cc\u0627\u06cc\u06cc" },
            { "002", "\u0622\u0641\u0631\u06cc\u0642\u0627" },
            { "003", "\u0634\u0645\u0627\u0644\u06cc \u0622\u0645\u0631\u06cc\u06a9\u0627" },
            { "RE", "\u0631\u0626\u0648\u0646\u06cc\u0648\u0646" },
            { "005", "\u062c\u0646\u0648\u0628\u06cc \u0622\u0645\u0631\u06cc\u06a9\u0627" },
            { "009", "\u0627\u0648\u0642\u06cc\u0627\u0646\u0648\u0633\u06cc\u0647" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u0634" },
            { "rn", "\u0631\u0648\u0646\u062f\u06cc" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u06cc" },
            { "ro", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "RS", "\u0635\u0631\u0628\u0633\u062a\u0648\u0646" },
            { "RU", "\u0631\u0648\u0633\u06cc\u0647" },
            { "ru", "\u0631\u0648\u0633\u06cc" },
            { "RW", "\u0631\u0648\u0622\u0646\u062f\u0627" },
            { "rw", "\u06a9\u0646\u06cc\u0627\u0631\u0648\u0622\u0646\u062f\u0627\u06cc\u06cc" },
            { "kea", "\u06a9\u06cc\u067e \u0648\u064f\u0631\u062f\u06cc" },
            { "en_AU", "\u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627\u06cc \u0650\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc" },
            { "SA", "\u0639\u0631\u0628\u0633\u062a\u0648\u0646" },
            { "sa", "\u0633\u0627\u0646\u0633\u06a9\u0631\u06cc\u062a" },
            { "SB", "\u0633\u0644\u06cc\u0645\u0648\u0646 \u062c\u0632\u06cc\u0631\u0647" },
            { "twq", "\u062a\u0627\u0633\u0627\u0648\u0627\u0642\u06cc" },
            { "011", "\u063a\u0631\u0628\u06cc \u0622\u0641\u0631\u06cc\u0642\u0627" },
            { "SC", "\u0633\u06cc\u0634\u0644" },
            { "SD", "\u0633\u0648\u062f\u0627\u0646" },
            { "sd", "\u0633\u0646\u062f\u06cc" },
            { "013", "\u0645\u06cc\u0648\u0646\u06cc \u0622\u0645\u0631\u06cc\u06a9\u0627" },
            { "SE", "\u0633\u0648\u0626\u062f" },
            { "se", "\u0634\u0645\u0627\u0644\u06cc \u0633\u0627\u0645\u06cc" },
            { "014", "\u0634\u0631\u0642\u06cc \u0622\u0641\u0631\u06cc\u0642\u0627" },
            { "015", "\u0634\u0645\u0627\u0644\u06cc \u06c0\u0641\u0631\u06cc\u0642\u0627" },
            { "SG", "\u0633\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "sg", "\u0633\u0627\u0646\u06af\u0648" },
            { "SH", "\u0633\u0646\u062a \u0647\u0644\u0646\u0627" },
            { "017", "\u0645\u06cc\u0648\u0646\u06cc \u0622\u0641\u0631\u06cc\u0642\u0627" },
            { "SI", "\u0627\u0633\u0644\u0648\u0648\u0646\u06cc" },
            { "si", "\u0633\u06cc\u0646\u0647\u0627\u0644\u0627" },
            { "018", "\u062c\u0646\u0648\u0628\u06cc \u0622\u0641\u0631\u06cc\u0642\u0627" },
            { "SJ", "\u0633\u0648\u0627\u0644\u0628\u0627\u0631\u062f \u0648 \u064a\u0627\u0646 \u0645\u0627\u064a\u0646" },
            { "sk", metaValue_SK },
            { "SK", metaValue_SK },
            { "019", "\u0622\u0645\u0631\u06cc\u06a9\u0627" },
            { "SL", "\u0633\u06cc\u0631\u0627\u0644\u0626\u0648\u0646" },
            { "sl", "\u0627\u0633\u0644\u0648\u0648\u0646\u06cc\u0627\u06cc\u06cc" },
            { "SM", "\u0633\u0646 \u0645\u0627\u0631\u06cc\u0646\u0648" },
            { "SN", "\u0633\u0646\u06af\u0627\u0644" },
            { "sn", "\u0634\u0648\u0646\u0627" },
            { "SO", "\u0633\u0648\u0645\u0627\u0644\u06cc" },
            { "so", "\u0633\u0648\u0645\u0627\u0644\u06cc\u0627\u06cc\u06cc" },
            { "arn", "\u0645\u0627\u067e\u0648\u0686\u0647" },
            { "sq", "\u0622\u0644\u0628\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "SR", "\u0633\u0648\u0631\u06cc\u0646\u0627\u0645" },
            { "sr", "\u0635\u0631\u0628\u06cc" },
            { "SS", "\u062c\u0646\u0648\u0628\u06cc \u0633\u0648\u062f\u0627\u0646" },
            { "ST", "\u0633\u0627\u0626\u0648\u062a\u0648\u0645\u0647 \u0648 \u067e\u0631\u06cc\u0646\u0633\u06cc\u067e" },
            { "su", "\u0633\u0648\u0646\u062f\u0627\u0646\u0633\u06cc" },
            { "SV", "\u0627\u0644\u0633\u0627\u0644\u0648\u0627\u062f\u0648\u0631" },
            { "sv", "\u0633\u0648\u0626\u062f\u06cc" },
            { "sw", "\u0633\u0648\u0627\u062d\u06cc\u0644\u06cc" },
            { "SX", "\u0633\u0646\u062a \u0645\u0627\u0631\u062a\u0646" },
            { "SY", "\u0633\u0648\u0631\u06cc\u0647" },
            { "SZ", "\u0633\u0648\u0627\u0632\u06cc\u0644\u0646\u062f" },
            { "TA", "\u062a\u0631\u06cc\u0633\u062a\u0627\u0646 \u062f\u0627 \u062c\u0648\u0646\u0647\u0627" },
            { "ta", "\u062a\u0627\u0645\u06cc\u0644\u06cc" },
            { "asa", "\u0622\u0633\u0648" },
            { "021", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "142", "\u0622\u0633\u06cc\u0627" },
            { "TC", "\u062a\u0648\u0631\u06a9\u0633 \u0648 \u06a9\u0627\u06cc\u06a9\u0648\u0633 \u062c\u0632\u0627\u06cc\u0631" },
            { "143", "\u0645\u06cc\u0648\u0646\u06cc \u0622\u0633\u06cc\u0627" },
            { "TD", "\u0686\u0627\u062f" },
            { "te", "\u062a\u0644\u0648\u06af\u0648\u06cc\u06cc" },
            { "145", "\u063a\u0631\u0628\u06cc \u0622\u0633\u06cc\u0627" },
            { "TF", "\u0641\u0631\u0627\u0646\u0633\u0647\u200c\u06cc \u062c\u0646\u0648\u0628\u06cc \u0645\u0646\u0627\u0637\u0642" },
            { "TG", "\u062a\u0648\u06af\u0648" },
            { "tg", "\u062a\u0627\u062c\u06cc\u06a9\u06cc" },
            { "TH", "\u062a\u0627\u06cc\u0644\u0646\u062f" },
            { "th", "\u062a\u0627\u06cc\u06cc" },
            { "ti", "\u062a\u06cc\u06af\u0631\u06cc\u0646\u06cc\u0627\u06cc\u06cc" },
            { "TJ", "\u062a\u0627\u062c\u06cc\u06a9\u0633\u062a\u0648\u0646" },
            { "en_CA", "\u06a9\u0627\u0646\u0627\u062f\u0627\u06cc \u0650\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc" },
            { "029", "\u06a9\u0627\u0631\u0627\u06cc\u06cc\u0628" },
            { "TK", "\u062a\u0648\u06a9\u0644\u0627\u0626\u0648" },
            { "tk", "\u062a\u0631\u06a9\u0645\u0648\u0646\u06cc" },
            { "TL", "\u062a\u06cc\u0645\u0648\u0631 \u0634\u0631\u0642\u06cc" },
            { "TM", "\u062a\u0631\u06a9\u0645\u0648\u0646\u0633\u062a\u0648\u0646" },
            { "TN", "\u062a\u0648\u0646\u0633" },
            { "TO", "\u062a\u0648\u0646\u06af\u0627" },
            { "to", "\u062a\u0648\u0646\u06af\u0627\u0646\u06cc" },
            { "dyo", "\u062c\u0648\u0644\u0627-\u0641\u0648\u0646\u06cc" },
            { "TR", "\u062a\u0631\u06a9\u06cc\u0647" },
            { "tr", "\u062a\u0631\u06a9\u06cc" },
            { "TT", "\u062a\u0631\u06cc\u0646\u06cc\u062f\u0627\u062f \u0648 \u062a\u0648\u0628\u0627\u06af\u0648" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631\u06cc" },
            { "TV", "\u062a\u0648\u0648\u0627\u0644\u0648" },
            { "TW", "\u062a\u0627\u06cc\u0648\u0627\u0646" },
            { "TZ", "\u062a\u0627\u0646\u0632\u0627\u0646\u06cc\u0627" },
            { "nmg", "\u06a9\u0648\u0626\u0627\u0633\u06cc\u0648" },
            { "150", "\u0627\u0631\u0648\u067e\u0627" },
            { "UA", "\u0627\u0648\u06a9\u0631\u0627\u06cc\u0646" },
            { "030", "\u0634\u0631\u0642\u06cc \u0622\u0633\u06cc\u0627" },
            { "151", "\u0634\u0631\u0642\u06cc \u0627\u0631\u0648\u067e\u0627" },
            { "154", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0631\u0648\u067e\u0627" },
            { "sw_CD", "\u06a9\u0646\u06af\u0648 \u0633\u0648\u0627\u062d\u06cc\u0644\u06cc" },
            { "034", "\u062c\u0646\u0648\u0628\u06cc \u0622\u0633\u06cc\u0627" },
            { "155", "\u063a\u0631\u0628\u06cc \u0627\u0631\u0648\u067e\u0627" },
            { "035", "\u0622\u0633\u06cc\u0627\u06cc \u0650\u062c\u0646\u0648\u0628\u200c\u0634\u0631\u0642\u06cc\u200c\u0648\u064e\u0631" },
            { "UG", "\u0627\u0648\u06af\u0627\u0646\u062f\u0627" },
            { "ug", "\u0626\u0648\u063a\u0648\u0631\u06cc" },
            { "039", "\u062c\u0646\u0648\u0628\u06cc \u0627\u0631\u0648\u067e\u0627" },
            { "uk", "\u0627\u0648\u06a9\u0631\u0627\u06cc\u0646\u06cc" },
            { "UM", "\u0622\u0645\u0631\u06cc\u06a9\u0627\u06cc \u067e\u064e\u0631\u062a\u0650\u200c\u067e\u0650\u0644\u0627 \u062c\u0632\u06cc\u0631\u0647\u200c\u0626\u0648\u0646" },
            { "ur", "\u0627\u0631\u062f\u0648" },
            { "US", "\u0645\u062a\u062d\u062f\u0647 \u0627\u06cc\u0627\u0644\u0627\u062a" },
            { "haw", "\u0647\u0627\u0648\u0627\u06cc\u06cc\u0627\u06cc\u06cc" },
            { "UY", "\u0627\u0631\u0648\u06af\u0648\u0626\u0647" },
            { "UZ", "\u0627\u0632\u0628\u06a9\u0633\u062a\u0648\u0646" },
            { "uz", "\u0627\u0632\u0628\u06a9\u06cc" },
            { "tzm", "\u0645\u06cc\u0648\u0646\u06cc \u0627\u0637\u0644\u0633 \u062a\u0627\u0645\u0632\u06cc\u0642\u06cc" },
            { "VA", "\u0648\u0627\u062a\u06cc\u06a9\u0627\u0646" },
            { "nds_NL", "\u067e\u0627\u06cc\u06cc\u0646 \u0633\u0627\u06a9\u0633\u0648\u0646\u06cc" },
            { "VC", "\u0633\u0646\u062a \u0648\u06cc\u0646\u0633\u0646\u062a \u0648 \u06af\u0631\u0646\u0627\u062f\u06cc\u0646" },
            { "VE", "\u0648\u0646\u0632\u0648\u0626\u0644\u0627" },
            { "VG", "\u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627\u06cc \u0648\u06cc\u0631\u062c\u06cc\u0646" },
            { "VI", "\u0622\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0648\u06cc\u0631\u062c\u06cc\u0646" },
            { "vi", "\u0648\u06cc\u062a\u0646\u0627\u0645\u06cc" },
            { "khq", "\u06a9\u0648\u06cc\u0631\u0627 \u0686\u06cc\u06cc\u0646\u06cc" },
            { "VN", "\u0648\u06cc\u062a\u0646\u0627\u0645" },
            { "quc", "\u06a9\u0626\u06cc\u0686\u0647\u200c\u0626\u06cc" },
            { "VU", "\u0648\u0627\u0646\u0648\u0627\u062a\u0648" },
            { "rwk", "\u0631\u0648\u0622\u06cc\u06cc" },
            { "gag", "\u06af\u0627\u06af\u0627\u0626\u0648\u0632\u06cc" },
            { "053", "\u0627\u0648\u0633\u062a\u0631\u0627\u0644\u0632\u06cc" },
            { "054", "\u0645\u0644\u0627\u0646\u0632\u06cc" },
            { "WF", "\u0648\u0627\u0644\u06cc\u0633 \u0648 \u0641\u0648\u062a\u0648\u0646\u0627" },
            { "Grek", metaValue_el },
            { "057", "\u0645\u06cc\u06a9\u0631\u0648\u0646\u0632\u06cc \u0645\u0646\u0642\u0637\u0647" },
            { "jgo", "\u0646\u06af\u0648\u0645\u0628\u0627" },
            { "lkt", "\u0644\u0627\u06a9\u0648\u062a\u0627" },
            { "wo", "\u0648\u0648\u0644\u0641\u06cc" },
            { "zgh", "\u0645\u0631\u0627\u06a9\u0634 \u0650\u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f \u0650\u062a\u0627\u0645\u0627\u0632\u06cc\u0642\u062a\u06cc" },
            { "ar_001", "\u0645\u062f\u0631\u0646 \u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f \u0639\u0631\u0628\u06cc" },
            { "WS", "\u0633\u0627\u0645\u0648\u0622" },
            { "061", "\u067e\u0648\u0644\u06cc\u200c\u0646\u0632\u06cc" },
            { "xh", "\u062e\u0648\u0633\u0627" },
            { "XK", "\u06a9\u0648\u0632\u0648\u0648" },
            { "Gujr", metaValue_gu },
            { "wbp", "\u0648\u0627\u0644\u0631\u067e\u06cc\u0631\u06cc" },
            { "moh", "\u0645\u0648\u0647\u0627\u06a9" },
            { "YE", "\u06cc\u0645\u0646" },
            { "nqo", "\u0646\u0626\u06a9\u0648" },
            { "yo", "\u06cc\u0648\u0631\u0648\u0628\u0627" },
            { "es_MX", "\u0645\u06a9\u0632\u06cc\u06a9 \u0650\u0627\u06cc\u0633\u067e\u0627\u0646\u06cc\u0648\u0644\u06cc" },
            { "YT", "\u0645\u0627\u06cc\u0648\u062a" },
            { "vai", "\u0648\u0627\u06cc\u06cc" },
            { "ZA", "\u062c\u0646\u0648\u0628\u06cc \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "kln", "\u06a9\u0627\u0644\u0646\u062c\u06cc\u0646" },
            { "Deva", "\u062f\u06cc\u0648\u0627\u0646\u0627\u0646\u06af\u0631\u06cc" },
            { "zh", "\u0686\u06cc\u0646\u06cc" },
            { "Hira", "\u0647\u06cc\u0631\u0627\u06af\u0627\u0646\u0627" },
            { "ZM", "\u0632\u0627\u0645\u0628\u06cc\u0627" },
            { "Bopo", "\u0628\u0648\u067e\u0648\u0645\u0648\u0641\u0648" },
            { "zu", "\u0632\u0648\u0644\u0648" },
            { "ZW", "\u0632\u06cc\u0645\u0628\u0627\u0628\u0648\u0647" },
            { "Geor", metaValue_ka },
            { "ZZ", "\u0646\u0627\u0645\u064e\u06cc\u0650\u0651\u0646 \u0645\u0646\u0637\u0642\u0647" },
            { "ebu", "\u0627\u0645\u0628\u0648" },
            { "jmc", "\u0645\u0627\u0686\u0627\u0645\u0647" },
            { "zh_Hans", "\u0633\u0627\u062f\u0647 \u0686\u06cc\u0646\u06cc" },
            { "koi", "\u06a9\u0648\u0645\u06cc-\u067e\u0631\u0645\u06cc\u0627\u06a9" },
            { "kok", "\u06a9\u0648\u0646\u06a9\u0627\u0646\u06cc" },
            { "nus", "\u0646\u0648\u0626\u0631" },
            { "dav", "\u062a\u0627\u06cc\u062a\u0627" },
            { "lrc", "\u0634\u0645\u0627\u0644\u06cc \u0644\u064f\u0631\u06cc" },
            { "zh_Hant", "\u0633\u0646\u062a\u06cc \u0686\u06cc\u0646\u06cc" },
            { "mua", "\u0645\u0648\u0646\u062f\u0627\u0646\u06af" },
            { "saq", "\u0633\u0627\u0645\u0628\u0648\u0631\u0648" },
            { "Guru", "\u06af\u0648\u0631\u0645\u0648\u062e\u06cc" },
            { "ksb", "\u0634\u0627\u0645\u0628\u0627\u0644\u0627" },
            { "ksf", "\u0628\u0627\u0641\u06cc\u0627\u06cc\u06cc" },
        };
        return data;
    }
}
