/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;

public final class StringUtil {
    static final String[] padding = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             ", "              ", "               ", "                ", "                 ", "                  ", "                   ", "                    "};
    private static final Stack<StringBuilder> builders = new Stack();

    /*
     * WARNING - void declaration
     */
    public static String join(Collection strings, String sep) {
        void var1_1;
        return StringUtil.join(strings.iterator(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Iterator strings, String sep) {
        void var2_2;
        if (!strings.hasNext()) {
            return "";
        }
        String start = strings.next().toString();
        if (!strings.hasNext()) {
            return start;
        }
        StringBuilder sb = StringUtil.borrowBuilder().append(start);
        while (strings.hasNext()) {
            sb.append(sep);
            sb.append(strings.next());
        }
        return StringUtil.releaseBuilder((StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String padding(int width) {
        void var1_1;
        if (width < 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (width < padding.length) {
            return padding[width];
        }
        char[] out = new char[width];
        for (int i = 0; i < width; ++i) {
            out[i] = 32;
        }
        return String.valueOf((char[])var1_1);
    }

    public static boolean isBlank(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (StringUtil.isWhitespace(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isDigit(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int c) {
        int n;
        return c == 32 || c == 9 || c == 10 || c == 12 || n == 13;
    }

    public static boolean isActuallyWhitespace(int c) {
        int n;
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13 || n == 160;
    }

    public static boolean isInvisibleChar(int c) {
        int n;
        return c == 8203 || n == 173;
    }

    public static void appendNormalisedWhitespace(StringBuilder accum2, String string, boolean stripLeading) {
        int c;
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        int len = string.length();
        for (int i = 0; i < len; i += Character.charCount(c)) {
            c = string.codePointAt(i);
            if (StringUtil.isActuallyWhitespace(c)) {
                if (stripLeading && !reachedNonWhite || lastWasWhite) continue;
                accum2.append(' ');
                lastWasWhite = true;
                continue;
            }
            if (StringUtil.isInvisibleChar(c)) continue;
            accum2.appendCodePoint(c);
            lastWasWhite = false;
            reachedNonWhite = true;
        }
    }

    public static boolean in(String needle, String ... haystack) {
        int len = haystack.length;
        for (int i = 0; i < len; ++i) {
            if (!haystack[i].equals(needle)) continue;
            return true;
        }
        return false;
    }

    public static boolean inSorted(String needle, String[] haystack) {
        String string;
        return Arrays.binarySearch(haystack, string) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public static URL resolve(URL base, String relUrl) throws MalformedURLException {
        void var1_1;
        URL uRL;
        if (relUrl.startsWith("?")) {
            relUrl = base.getPath() + relUrl;
        }
        if (relUrl.indexOf(46) == 0 && base.getFile().indexOf(47) != 0) {
            base = new URL(base.getProtocol(), base.getHost(), base.getPort(), "/" + base.getFile());
        }
        return new URL(uRL, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String resolve(String baseUrl, String relUrl) {
        try {
            void var1_1;
            Object object;
            Object base;
            try {
                base = new URL(baseUrl);
            }
            catch (MalformedURLException malformedURLException) {
                base = new URL(relUrl);
                return ((URL)base).toExternalForm();
            }
            return StringUtil.resolve((URL)object, (String)var1_1).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return "";
        }
    }

    public static StringBuilder borrowBuilder() {
        Stack<StringBuilder> stack = builders;
        synchronized (stack) {
            return builders.empty() ? new StringBuilder(8192) : builders.pop();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String releaseBuilder(StringBuilder sb) {
        void var1_2;
        Validate.notNull(sb);
        String string = sb.toString();
        if (sb.length() > 8192) {
            sb = new StringBuilder(8192);
        } else {
            sb.delete(0, sb.length());
        }
        Stack<StringBuilder> stack = builders;
        synchronized (stack) {
            StringBuilder stringBuilder;
            builders.push(stringBuilder);
            while (builders.size() > 8) {
                builders.pop();
            }
        }
        return var1_2;
    }
}

