/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.ozi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.IGpxReader;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class OziWptReader
implements IGpxReader {
    private static final int IDX_NAME = 1;
    private static final int IDX_LAT = 2;
    private static final int IDX_LON = 3;
    private static final int IDX_DESC = 10;
    private static final int IDX_ELE = 14;
    private static final int INVALID_ELE = -777;
    private final InputStream source;
    private GpxData data;
    private int success;

    public OziWptReader(InputStream source) throws IOException {
        this.source = Objects.requireNonNull(source);
    }

    @Override
    public boolean parse(boolean tryToFinish) throws SAXException, IOException {
        this.data = new GpxData();
        ArrayList<Collection<WayPoint>> currentTrack = new ArrayList<Collection<WayPoint>>();
        ArrayList<WayPoint> waypoints = new ArrayList<WayPoint>();
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(this.source, StandardCharsets.UTF_8));){
            String line;
            int linecount = 0;
            do {
                if ((line = rd.readLine()) == null) continue;
                if (++linecount == 1) {
                    if (line.startsWith("OziExplorer Waypoint File")) continue;
                    throw new UnsupportedOperationException("Unsupported format: " + line);
                }
                if (linecount == 2) {
                    if ("WGS 84".equals(line)) continue;
                    throw new UnsupportedOperationException("Unsupported datum: " + line);
                }
                if (linecount == 3 || linecount == 4) {
                    Logging.trace(line);
                    continue;
                }
                try {
                    int eleInFeet;
                    String[] fields = line.split(",");
                    WayPoint currentwp = new WayPoint(new LatLon(Double.parseDouble(fields[2]), Double.parseDouble(fields[3])));
                    currentwp.put("name", fields[1]);
                    currentwp.put("desc", fields[10]);
                    String ele = fields[14];
                    if (!ele.isEmpty() && (eleInFeet = Integer.parseInt(ele)) != 0 && eleInFeet != -777) {
                        currentwp.put("ele", (double)eleInFeet * SystemOfMeasurement.IMPERIAL.aValue);
                    }
                    waypoints.add(currentwp);
                    ++this.success;
                }
                catch (IllegalArgumentException e) {
                    Logging.error(e);
                }
            } while (line != null);
        }
        currentTrack.add(waypoints);
        this.data.tracks.add(new GpxTrack((Collection<Collection<WayPoint>>)currentTrack, Collections.emptyMap()));
        return true;
    }

    @Override
    public GpxData getGpxData() {
        return this.data;
    }

    @Override
    public int getNumberOfCoordinates() {
        return this.success;
    }
}

