/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.MessageExoType;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.command.CommandArrow;
import net.sourceforge.plantuml.skin.ArrowBody;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;

abstract class CommandExoArrowAny
extends SingleLineCommand2<SequenceDiagram> {
    protected static final String ARROW_SUPPCIRCLE1 = "ARROW_SUPPCIRCLE1";
    protected static final String ARROW_SUPPCIRCLE2 = "ARROW_SUPPCIRCLE2";

    public CommandExoArrowAny(IRegex pattern) {
        super(pattern);
    }

    @Override
    protected final CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        HColor activationColor;
        boolean parallel;
        ArrowConfiguration config;
        String body = arg.getLazzy("ARROW_BODYA", 0) + arg.getLazzy("ARROW_BODYB", 0);
        String dressing = arg.getLazzy("ARROW_DRESSING", 0);
        Participant p = diagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("PARTICIPANT", 0)));
        boolean sync = dressing.length() == 2;
        boolean dotted = body.contains("--");
        Display labels = arg.get("LABEL", 0) == null ? Display.create("") : Display.getWithNewlines(arg.get("LABEL", 0));
        boolean bothDirection = arg.get("ARROW_BOTHDRESSING", 0) != null;
        ArrowConfiguration arrowConfiguration = config = bothDirection ? ArrowConfiguration.withDirectionBoth() : ArrowConfiguration.withDirectionNormal();
        if (dotted) {
            config = config.withBody(ArrowBody.DOTTED);
        }
        if (sync) {
            config = config.withHead(ArrowHead.ASYNC);
        }
        MessageExoType messageExoType = this.getMessageExoType(arg);
        config = config.withPart(this.getArrowPart(dressing, messageExoType));
        config = CommandArrow.applyStyle(diagram.getSkinParam().getThemeStyle(), arg.getLazzy("ARROW_STYLE", 0), config);
        String activationSpec = arg.get("ACTIVATION", 0);
        if (activationSpec != null && activationSpec.charAt(0) == '*') {
            diagram.activate(p, LifeEventType.CREATE, null);
        }
        if (messageExoType == MessageExoType.TO_RIGHT || messageExoType == MessageExoType.TO_LEFT) {
            if (this.containsSymbol(ARROW_SUPPCIRCLE1, arg, "o")) {
                config = config.withDecoration1(ArrowDecoration.CIRCLE);
            }
            if (this.containsSymbol(ARROW_SUPPCIRCLE1, arg, "x")) {
                config = config.withHead1(ArrowHead.CROSSX);
            }
            if (this.containsSymbol(ARROW_SUPPCIRCLE2, arg, "o")) {
                config = config.withDecoration2(ArrowDecoration.CIRCLE);
            }
            if (this.containsSymbol(ARROW_SUPPCIRCLE2, arg, "x")) {
                config = config.withHead2(ArrowHead.CROSSX);
            }
        } else {
            if (this.containsSymbol(ARROW_SUPPCIRCLE2, arg, "o")) {
                config = config.withDecoration1(ArrowDecoration.CIRCLE);
            }
            if (this.containsSymbol(ARROW_SUPPCIRCLE2, arg, "x")) {
                config = config.withHead1(ArrowHead.CROSSX);
            }
            if (this.containsSymbol(ARROW_SUPPCIRCLE1, arg, "o")) {
                config = config.withDecoration2(ArrowDecoration.CIRCLE);
            }
            if (this.containsSymbol(ARROW_SUPPCIRCLE1, arg, "x")) {
                config = config.withHead2(ArrowHead.CROSSX);
            }
        }
        MessageExo msg = new MessageExo(diagram.getSkinParam().getCurrentStyleBuilder(), p, messageExoType, labels, config, diagram.getNextMessageNumber(), this.isShortArrow(arg));
        if (arg.get("URL", 0) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url urlLink = urlBuilder.getUrl(arg.get("URL", 0));
            msg.setUrl(urlLink);
        }
        boolean bl = parallel = arg.get("PARALLEL", 0) != null;
        if (parallel) {
            msg.goParallel();
        }
        msg.setAnchor(arg.get("ANCHOR", 1));
        msg.setPart1Anchor(arg.get("PART1ANCHOR", 1));
        msg.setPart2Anchor(arg.get("PART2ANCHOR", 1));
        String error = diagram.addMessage(msg);
        if (error != null) {
            return CommandExecutionResult.error(error);
        }
        String s = arg.get("LIFECOLOR", 0);
        HColor hColor = activationColor = s == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(diagram.getSkinParam().getThemeStyle(), s);
        if (activationSpec != null) {
            switch (activationSpec.charAt(0)) {
                case '+': {
                    diagram.activate(p, LifeEventType.ACTIVATE, activationColor);
                    break;
                }
                case '-': {
                    diagram.activate(p, LifeEventType.DEACTIVATE, null);
                    break;
                }
                case '!': {
                    diagram.activate(p, LifeEventType.DESTROY, null);
                    break;
                }
            }
        } else if (diagram.isAutoactivate() && (config.getHead() == ArrowHead.NORMAL || config.getHead() == ArrowHead.ASYNC)) {
            if (config.isDotted()) {
                diagram.activate(p, LifeEventType.DEACTIVATE, null);
            } else {
                diagram.activate(p, LifeEventType.ACTIVATE, activationColor);
            }
        }
        return CommandExecutionResult.ok();
    }

    private ArrowPart getArrowPart(String dressing, MessageExoType messageExoType) {
        if (dressing.contains("/")) {
            if (messageExoType.getDirection() == 1) {
                return ArrowPart.BOTTOM_PART;
            }
            return ArrowPart.TOP_PART;
        }
        if (dressing.contains("\\")) {
            if (messageExoType.getDirection() == 1) {
                return ArrowPart.TOP_PART;
            }
            return ArrowPart.BOTTOM_PART;
        }
        return ArrowPart.FULL;
    }

    abstract MessageExoType getMessageExoType(RegexResult var1);

    private boolean isShortArrow(RegexResult arg2) {
        String s = arg2.get(ARROW_SUPPCIRCLE2, 0);
        return s != null && s.contains("?");
    }

    private boolean containsSymbol(String suppCircle, RegexResult arg2, String symbol) {
        String s = arg2.get(suppCircle, 0);
        return s != null && s.contains(symbol);
    }
}

