#!/usr/bin/python

# ----------------------------------------------------------------------------
#
#  Copyright (C) 2020-2021 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


# Kmeters for Ambisonics signals up to degree 8.

import sys
import signal
from PyQt5 import QtGui, QtCore, QtWidgets
from jacktools.jackkmeter import *
from sys import argv
sys.path.append ('..')
from utils.kmeters import *


class Meterwin(QtWidgets.QWidget):
    
    def __init__(self, degree, metrics):
        super(Meterwin, self).__init__()
        self.metrics = metrics
        mlist = [ 2 * i + 1 for i in range (degree + 1)]
        self.disp = K20meter(self, metrics, mlist, 6, 4)
        self.disp.move(0, 0)
        self.disp.show()
        self.setFixedSize (self.disp.sx, self.disp.sy)
        self.setWindowTitle('Ambisonic levels')
        self.show()        
        self.timer = QtCore.QBasicTimer ()
        self.timer.start (50, self)

    def timerEvent (self, ev):
        st, rms, dpk = K20.get_levels ()
        self.disp.rms = rms
        self.disp.pks = dpk
        self.disp.update ()

if len (argv) < 2:
    print ("ambmeter <degree (1..8)>")
    exit (1)

degr = int (argv [1])
degr = min (8, max (1, degr))
ninp = (degr + 1) * (degr + 1)
        
# Create K-meter processors. 
K20 = JackKmeter (ninp, 'Meters')

# Allow Ctrl-C        
signal.signal (signal.SIGINT, signal.SIG_DFL)

# Set dark window background.
app = QtWidgets.QApplication(sys.argv)
pal = app.palette()
bgc = QtGui.QColor (40, 40, 40)
pal.setColor(pal.Window, bgc)
app.setPalette(pal)

# Create meter window.
metrics = makek20metrics (bgc)
win = Meterwin (degr, metrics)
sys.exit(app.exec_())


