/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Encoder;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.WsWebSocketContainer;
import org.apache.tomcat.websocket.pojo.PojoMethodMapping;
import org.apache.tomcat.websocket.server.UpgradeUtil;
import org.apache.tomcat.websocket.server.UriTemplate;
import org.apache.tomcat.websocket.server.WsFilter;
import org.apache.tomcat.websocket.server.WsMappingResult;
import org.apache.tomcat.websocket.server.WsWriteTimeout;

public class WsServerContainer
extends WsWebSocketContainer
implements ServerContainer {
    private static final StringManager sm = StringManager.getManager(WsServerContainer.class);
    private final Log log = LogFactory.getLog(WsServerContainer.class);
    private static final CloseReason AUTHENTICATED_HTTP_SESSION_CLOSED = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "This connection was established under an authenticated HTTP session that has ended.");
    private final WsWriteTimeout wsWriteTimeout = new WsWriteTimeout();
    private final ServletContext servletContext;
    private final Map<String, ExactPathMatch> configExactMatchMap = new ConcurrentHashMap<String, ExactPathMatch>();
    private final ConcurrentHashMap<Integer, ConcurrentSkipListMap<String, TemplatePathMatch>> configTemplateMatchMap = new ConcurrentHashMap();
    private volatile boolean enforceNoAddAfterHandshake = Constants.STRICT_SPEC_COMPLIANCE;
    private volatile boolean addAllowed = true;
    private final ConcurrentMap<String, Set<WsSession>> authenticatedSessions = new ConcurrentHashMap<String, Set<WsSession>>();
    private final ExecutorService executorService;
    private final ThreadGroup threadGroup;
    private volatile boolean endpointsRegistered = false;
    private volatile boolean deploymentFailed = false;

    WsServerContainer(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.setInstanceManager((InstanceManager)servletContext.getAttribute(InstanceManager.class.getName()));
        String string = servletContext.getInitParameter("org.apache.tomcat.websocket.binaryBufferSize");
        if (string != null) {
            this.setDefaultMaxBinaryMessageBufferSize(Integer.parseInt(string));
        }
        if ((string = servletContext.getInitParameter("org.apache.tomcat.websocket.textBufferSize")) != null) {
            this.setDefaultMaxTextMessageBufferSize(Integer.parseInt(string));
        }
        if ((string = servletContext.getInitParameter("org.apache.tomcat.websocket.noAddAfterHandshake")) != null) {
            this.setEnforceNoAddAfterHandshake(Boolean.parseBoolean(string));
        }
        int n = 0;
        long l = 60L;
        string = servletContext.getInitParameter("org.apache.tomcat.websocket.executorCoreSize");
        if (string != null) {
            n = Integer.parseInt(string);
        }
        if ((string = servletContext.getInitParameter("org.apache.tomcat.websocket.executorKeepAliveTimeSeconds")) != null) {
            l = Long.parseLong(string);
        }
        FilterRegistration.Dynamic dynamic = servletContext.addFilter("Tomcat WebSocket (JSR356) Filter", (Filter)new WsFilter());
        dynamic.setAsyncSupported(true);
        EnumSet<DispatcherType> enumSet = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD);
        dynamic.addMappingForUrlPatterns(enumSet, true, new String[]{"/*"});
        StringBuffer stringBuffer = new StringBuffer("WebSocketServer-");
        if ("".equals(servletContext.getContextPath())) {
            stringBuffer.append("ROOT");
        } else {
            stringBuffer.append(servletContext.getContextPath());
        }
        this.threadGroup = new ThreadGroup(stringBuffer.toString());
        WsThreadFactory wsThreadFactory = new WsThreadFactory(this.threadGroup);
        this.executorService = new ThreadPoolExecutor(n, Integer.MAX_VALUE, l, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), wsThreadFactory);
    }

    public void addEndpoint(ServerEndpointConfig serverEndpointConfig) throws DeploymentException {
        this.addEndpoint(serverEndpointConfig, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addEndpoint(ServerEndpointConfig serverEndpointConfig, boolean bl) throws DeploymentException {
        if (this.enforceNoAddAfterHandshake && !this.addAllowed) {
            throw new DeploymentException(sm.getString("serverContainer.addNotAllowed"));
        }
        if (this.servletContext == null) {
            throw new DeploymentException(sm.getString("serverContainer.servletContextMissing"));
        }
        if (this.deploymentFailed) {
            throw new DeploymentException(sm.getString("serverContainer.failedDeployment", new Object[]{this.servletContext.getContextPath()}));
        }
        try {
            UriTemplate uriTemplate;
            String string = serverEndpointConfig.getPath();
            PojoMethodMapping pojoMethodMapping = new PojoMethodMapping(serverEndpointConfig.getEndpointClass(), serverEndpointConfig.getDecoders(), string);
            if (pojoMethodMapping.getOnClose() != null || pojoMethodMapping.getOnOpen() != null || pojoMethodMapping.getOnError() != null || pojoMethodMapping.hasMessageHandlers()) {
                serverEndpointConfig.getUserProperties().put("org.apache.tomcat.websocket.pojo.PojoEndpoint.methodMapping", pojoMethodMapping);
            }
            if ((uriTemplate = new UriTemplate(string)).hasParameters()) {
                Integer n = uriTemplate.getSegmentCount();
                ConcurrentSkipListMap<String, TemplatePathMatch> concurrentSkipListMap = this.configTemplateMatchMap.get(n);
                if (concurrentSkipListMap == null) {
                    concurrentSkipListMap = new ConcurrentSkipListMap();
                    this.configTemplateMatchMap.putIfAbsent(n, concurrentSkipListMap);
                    concurrentSkipListMap = this.configTemplateMatchMap.get(n);
                }
                TemplatePathMatch templatePathMatch = new TemplatePathMatch(serverEndpointConfig, uriTemplate, bl);
                TemplatePathMatch templatePathMatch2 = concurrentSkipListMap.putIfAbsent(uriTemplate.getNormalizedPath(), templatePathMatch);
                if (templatePathMatch2 != null) {
                    if (!templatePathMatch2.isFromAnnotatedPojo() || templatePathMatch.isFromAnnotatedPojo() || templatePathMatch2.getConfig().getEndpointClass() != templatePathMatch.getConfig().getEndpointClass()) throw new DeploymentException(sm.getString("serverContainer.duplicatePaths", new Object[]{string, serverEndpointConfig.getEndpointClass(), serverEndpointConfig.getEndpointClass()}));
                    concurrentSkipListMap.put(string, templatePathMatch2);
                }
            } else {
                ExactPathMatch exactPathMatch = new ExactPathMatch(serverEndpointConfig, bl);
                ExactPathMatch exactPathMatch2 = this.configExactMatchMap.put(string, exactPathMatch);
                if (exactPathMatch2 != null) {
                    if (!exactPathMatch2.isFromAnnotatedPojo() || exactPathMatch.isFromAnnotatedPojo() || exactPathMatch2.getConfig().getEndpointClass() != exactPathMatch.getConfig().getEndpointClass()) throw new DeploymentException(sm.getString("serverContainer.duplicatePaths", new Object[]{string, exactPathMatch2.getConfig().getEndpointClass(), serverEndpointConfig.getEndpointClass()}));
                    this.configExactMatchMap.put(string, exactPathMatch2);
                }
            }
            this.endpointsRegistered = true;
            return;
        }
        catch (DeploymentException deploymentException) {
            this.failDeployment();
            throw deploymentException;
        }
    }

    public void addEndpoint(Class<?> clazz) throws DeploymentException {
        this.addEndpoint(clazz, false);
    }

    void addEndpoint(Class<?> clazz, boolean bl) throws DeploymentException {
        ServerEndpointConfig serverEndpointConfig;
        if (this.deploymentFailed) {
            throw new DeploymentException(sm.getString("serverContainer.failedDeployment", new Object[]{this.servletContext.getContextPath()}));
        }
        try {
            ServerEndpoint serverEndpoint = clazz.getAnnotation(ServerEndpoint.class);
            if (serverEndpoint == null) {
                throw new DeploymentException(sm.getString("serverContainer.missingAnnotation", new Object[]{clazz.getName()}));
            }
            String string = serverEndpoint.value();
            WsServerContainer.validateEncoders(serverEndpoint.encoders());
            Class clazz2 = serverEndpoint.configurator();
            ServerEndpointConfig.Configurator configurator = null;
            if (!clazz2.equals(ServerEndpointConfig.Configurator.class)) {
                try {
                    configurator = (ServerEndpointConfig.Configurator)serverEndpoint.configurator().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new DeploymentException(sm.getString("serverContainer.configuratorFail", new Object[]{serverEndpoint.configurator().getName(), clazz.getClass().getName()}), (Throwable)reflectiveOperationException);
                }
            }
            serverEndpointConfig = ServerEndpointConfig.Builder.create(clazz, (String)string).decoders(Arrays.asList(serverEndpoint.decoders())).encoders(Arrays.asList(serverEndpoint.encoders())).subprotocols(Arrays.asList(serverEndpoint.subprotocols())).configurator(configurator).build();
        }
        catch (DeploymentException deploymentException) {
            this.failDeployment();
            throw deploymentException;
        }
        this.addEndpoint(serverEndpointConfig, bl);
    }

    void failDeployment() {
        this.deploymentFailed = true;
        this.endpointsRegistered = false;
        this.configExactMatchMap.clear();
        this.configTemplateMatchMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() {
        this.shutdownExecutor();
        super.destroy();
        int n = this.threadGroup.activeCount();
        boolean bl = false;
        try {
            while (true) {
                int n2 = n;
                ThreadGroup threadGroup = this.threadGroup;
                synchronized (threadGroup) {
                    if (n > 0) {
                        Thread.yield();
                        n = this.threadGroup.activeCount();
                    }
                    if (n <= 0 || n == n2) break;
                }
            }
            {
                if (n <= 0) {
                    this.threadGroup.destroy();
                    return;
                }
                this.threadGroup.setDaemon(true);
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        if (bl) return;
        this.log.warn((Object)sm.getString("serverContainer.threadGroupNotDestroyed", new Object[]{this.threadGroup.getName(), n}));
    }

    boolean areEndpointsRegistered() {
        return this.endpointsRegistered;
    }

    public void doUpgrade(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServerEndpointConfig serverEndpointConfig, Map<String, String> map) throws ServletException, IOException {
        UpgradeUtil.doUpgrade(this, httpServletRequest, httpServletResponse, serverEndpointConfig, map);
    }

    public WsMappingResult findMapping(String string) {
        ExactPathMatch exactPathMatch;
        if (this.addAllowed) {
            this.addAllowed = false;
        }
        if ((exactPathMatch = this.configExactMatchMap.get(string)) != null) {
            return new WsMappingResult(exactPathMatch.getConfig(), Collections.<String, String>emptyMap());
        }
        UriTemplate uriTemplate = null;
        try {
            uriTemplate = new UriTemplate(string);
        }
        catch (DeploymentException deploymentException) {
            return null;
        }
        Integer n = uriTemplate.getSegmentCount();
        ConcurrentSkipListMap<String, TemplatePathMatch> concurrentSkipListMap = this.configTemplateMatchMap.get(n);
        if (concurrentSkipListMap == null) {
            return null;
        }
        ServerEndpointConfig serverEndpointConfig = null;
        Map<String, String> map = null;
        for (TemplatePathMatch templatePathMatch : concurrentSkipListMap.values()) {
            map = templatePathMatch.getUriTemplate().match(uriTemplate);
            if (map == null) continue;
            serverEndpointConfig = templatePathMatch.getConfig();
            break;
        }
        if (serverEndpointConfig == null) {
            return null;
        }
        return new WsMappingResult(serverEndpointConfig, map);
    }

    public boolean isEnforceNoAddAfterHandshake() {
        return this.enforceNoAddAfterHandshake;
    }

    public void setEnforceNoAddAfterHandshake(boolean bl) {
        this.enforceNoAddAfterHandshake = bl;
    }

    protected WsWriteTimeout getTimeout() {
        return this.wsWriteTimeout;
    }

    @Override
    protected void registerSession(Object object, WsSession wsSession) {
        super.registerSession(object, wsSession);
        if (wsSession.isOpen() && wsSession.getUserPrincipal() != null && wsSession.getHttpSessionId() != null) {
            this.registerAuthenticatedSession(wsSession, wsSession.getHttpSessionId());
        }
    }

    @Override
    protected void unregisterSession(Object object, WsSession wsSession) {
        if (wsSession.getUserPrincipal() != null && wsSession.getHttpSessionId() != null) {
            this.unregisterAuthenticatedSession(wsSession, wsSession.getHttpSessionId());
        }
        super.unregisterSession(object, wsSession);
    }

    private void registerAuthenticatedSession(WsSession wsSession, String string) {
        Set set = (Set)this.authenticatedSessions.get(string);
        if (set == null) {
            set = Collections.newSetFromMap(new ConcurrentHashMap());
            this.authenticatedSessions.putIfAbsent(string, set);
            set = (Set)this.authenticatedSessions.get(string);
        }
        set.add(wsSession);
    }

    private void unregisterAuthenticatedSession(WsSession wsSession, String string) {
        Set set = (Set)this.authenticatedSessions.get(string);
        if (set != null) {
            set.remove(wsSession);
        }
    }

    public void closeAuthenticatedSession(String string) {
        Set set = (Set)this.authenticatedSessions.remove(string);
        if (set != null && !set.isEmpty()) {
            for (WsSession wsSession : set) {
                try {
                    wsSession.close(AUTHENTICATED_HTTP_SESSION_CLOSED);
                }
                catch (IOException iOException) {}
            }
        }
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    private void shutdownExecutor() {
        if (this.executorService == null) {
            return;
        }
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void validateEncoders(Class<? extends Encoder>[] classArray) throws DeploymentException {
        for (Class<? extends Encoder> clazz : classArray) {
            try {
                clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new DeploymentException(sm.getString("serverContainer.encoderFail", new Object[]{clazz.getName()}), (Throwable)reflectiveOperationException);
            }
        }
    }

    private static class WsThreadFactory
    implements ThreadFactory {
        private final ThreadGroup tg;
        private final AtomicLong count = new AtomicLong(0L);

        private WsThreadFactory(ThreadGroup threadGroup) {
            this.tg = threadGroup;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.tg, runnable);
            thread.setName(this.tg.getName() + "-" + this.count.incrementAndGet());
            return thread;
        }
    }

    private static class ExactPathMatch {
        private final ServerEndpointConfig config;
        private final boolean fromAnnotatedPojo;

        public ExactPathMatch(ServerEndpointConfig serverEndpointConfig, boolean bl) {
            this.config = serverEndpointConfig;
            this.fromAnnotatedPojo = bl;
        }

        public ServerEndpointConfig getConfig() {
            return this.config;
        }

        public boolean isFromAnnotatedPojo() {
            return this.fromAnnotatedPojo;
        }
    }

    private static class TemplatePathMatch {
        private final ServerEndpointConfig config;
        private final UriTemplate uriTemplate;
        private final boolean fromAnnotatedPojo;

        public TemplatePathMatch(ServerEndpointConfig serverEndpointConfig, UriTemplate uriTemplate, boolean bl) {
            this.config = serverEndpointConfig;
            this.uriTemplate = uriTemplate;
            this.fromAnnotatedPojo = bl;
        }

        public ServerEndpointConfig getConfig() {
            return this.config;
        }

        public UriTemplate getUriTemplate() {
            return this.uriTemplate;
        }

        public boolean isFromAnnotatedPojo() {
            return this.fromAnnotatedPojo;
        }
    }
}

