/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.xmlparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jasper.compiler.Localizer;

public class ASCIIReader
extends Reader {
    protected InputStream fInputStream;
    protected byte[] fBuffer;

    public ASCIIReader(InputStream inputStream, int n) {
        this.fInputStream = inputStream;
        this.fBuffer = new byte[n];
    }

    @Override
    public int read() throws IOException {
        int n = this.fInputStream.read();
        if (n > 128) {
            throw new IOException(Localizer.getMessage("jsp.error.xml.invalidASCII", Integer.toString(n)));
        }
        return n;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n2 > this.fBuffer.length) {
            n2 = this.fBuffer.length;
        }
        int n3 = this.fInputStream.read(this.fBuffer, 0, n2);
        for (int i = 0; i < n3; ++i) {
            int n4 = 0xFF & this.fBuffer[i];
            if (n4 > 128) {
                throw new IOException(Localizer.getMessage("jsp.error.xml.invalidASCII", Integer.toString(n4)));
            }
            cArray[n + i] = (char)n4;
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.fInputStream.skip(l);
    }

    @Override
    public boolean ready() throws IOException {
        return false;
    }

    @Override
    public boolean markSupported() {
        return this.fInputStream.markSupported();
    }

    @Override
    public void mark(int n) throws IOException {
        this.fInputStream.mark(n);
    }

    @Override
    public void reset() throws IOException {
        this.fInputStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.fInputStream.close();
    }
}

