/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

public final class UriUtil {
    private static Pattern PATTERN_EXCLAMATION_MARK = Pattern.compile("!/");
    private static Pattern PATTERN_CARET = Pattern.compile("\\^/");
    private static Pattern PATTERN_ASTERISK = Pattern.compile("\\*/");

    private UriUtil() {
    }

    private static boolean isSchemeChar(char c) {
        return Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.';
    }

    public static boolean hasScheme(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c == ':') {
                return i > 0;
            }
            if (UriUtil.isSchemeChar(c)) continue;
            return false;
        }
        return false;
    }

    public static URL buildJarUrl(File file) throws MalformedURLException {
        return UriUtil.buildJarUrl(file, null);
    }

    public static URL buildJarUrl(File file, String string) throws MalformedURLException {
        return UriUtil.buildJarUrl(file.toURI().toString(), string);
    }

    public static URL buildJarUrl(String string) throws MalformedURLException {
        return UriUtil.buildJarUrl(string, null);
    }

    public static URL buildJarUrl(String string, String string2) throws MalformedURLException {
        String string3 = UriUtil.makeSafeForJarUrl(string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append("!/");
        if (string2 != null) {
            stringBuilder.append(UriUtil.makeSafeForJarUrl(string2));
        }
        return new URL("jar", "", -1, stringBuilder.toString());
    }

    public static URL buildJarSafeUrl(File file) throws MalformedURLException {
        String string = UriUtil.makeSafeForJarUrl(file.toURI().toString());
        return new URL(string);
    }

    private static String makeSafeForJarUrl(String string) {
        String string2 = PATTERN_EXCLAMATION_MARK.matcher(string).replaceAll("%21/");
        string2 = PATTERN_CARET.matcher(string2).replaceAll("%5e/");
        return PATTERN_ASTERISK.matcher(string2).replaceAll("%2a/");
    }
}

