/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.tomcat.util.http.parser.HttpParser;

public class TokenList {
    private TokenList() {
    }

    public static boolean parseTokenList(Enumeration<String> enumeration, Collection<String> collection) throws IOException {
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (string == null || TokenList.parseTokenList(new StringReader(string), collection)) continue;
            bl = false;
        }
        return bl;
    }

    public static boolean parseTokenList(Reader reader, Collection<String> collection) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            String string;
            if ((string = HttpParser.readToken(reader)) == null) {
                bl = true;
                HttpParser.skipUntil(reader, 0, ',');
                continue;
            }
            if (string.length() == 0) break;
            HttpParser.SkipResult skipResult = HttpParser.skipConstant(reader, ",");
            if (skipResult == HttpParser.SkipResult.EOF) {
                bl2 = true;
                collection.add(string.toLowerCase(Locale.ENGLISH));
                break;
            }
            if (skipResult == HttpParser.SkipResult.FOUND) {
                bl2 = true;
                collection.add(string.toLowerCase(Locale.ENGLISH));
                continue;
            }
            bl = true;
            HttpParser.skipUntil(reader, 0, ',');
        }
        return bl2 && !bl;
    }
}

