/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.schemacrawler.SchemaInfoRetrieval;
import us.fatehi.utility.StopWatch;

public final class RetrievalStopWatch {
    private static final Logger LOGGER = Logger.getLogger(RetrievalStopWatch.class.getName());
    private StopWatch stopWatch;
    private final SchemaInfoLevel infoLevel;

    public RetrievalStopWatch(SchemaInfoLevel infoLevel) {
        this.infoLevel = Objects.requireNonNull(infoLevel, "No info-level provided");
        this.reset("none");
    }

    public void reset(String crawl) {
        this.stopWatch = new StopWatch(crawl);
        LOGGER.log(Level.INFO, "Running " + crawl);
    }

    public Supplier<String> stopAndLogTime() {
        Supplier<String> stringify = this.stopWatch.stringify();
        this.reset("none");
        LOGGER.log(Level.INFO, this.stopWatch.stringify());
        return stringify;
    }

    public void time(SchemaInfoRetrieval retrieval, StopWatch.Function function, SchemaInfoRetrieval ... additionalRetrievals) throws Exception {
        boolean run = this.infoLevel.is(retrieval) && this.run(additionalRetrievals);
        this.time(retrieval.name(), run, function);
    }

    public void time(String retrievalName, StopWatch.Function function, SchemaInfoRetrieval ... additionalRetrievals) throws Exception {
        boolean run = this.run(additionalRetrievals);
        this.time(retrievalName, run, function);
    }

    private boolean run(SchemaInfoRetrieval ... additionalRetrievals) {
        boolean run = true;
        if (additionalRetrievals != null && additionalRetrievals.length > 0) {
            for (SchemaInfoRetrieval additionalRetrieval : additionalRetrievals) {
                run = run && this.infoLevel.is(additionalRetrieval);
            }
        }
        return run;
    }

    private void time(String retrievalName, boolean run, StopWatch.Function function) throws Exception {
        this.stopWatch.time(retrievalName, () -> {
            if (run) {
                LOGGER.log(Level.INFO, "Running " + retrievalName);
                function.call();
            } else {
                LOGGER.log(Level.INFO, retrievalName + " not requested");
            }
        });
    }
}

