/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.counts;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.loader.counts.TableRowCountsUtility;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.QueryUtility;
import us.fatehi.utility.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

public final class TableRowCountsRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableRowCountsRetriever.class.getName());
    private final Connection connection;
    private final Catalog catalog;

    public TableRowCountsRetriever(Connection connection, Catalog catalog) throws SQLException {
        this.connection = DatabaseUtility.checkConnection(connection);
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
    }

    public void retrieveTableRowCounts() {
        Identifiers identifiers;
        try {
            identifiers = Identifiers.identifiers().withConnection(this.connection).build();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "No connection provided", e);
            Identifiers identifiers2 = Identifiers.STANDARD;
            return;
        }
        Query query = new Query("schemacrawler.table.row_counts", "SELECT COUNT(*) FROM ${table}");
        ArrayList<Table> allTables = new ArrayList<Table>(this.catalog.getTables());
        for (Table table : allTables) {
            try {
                long count = QueryUtility.executeForLong(query, this.connection, table, identifiers);
                TableRowCountsUtility.addRowCountToTable(table, count);
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e, new StringFormat("Could not get count for table <%s>", table));
            }
        }
    }
}

