/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.schema;

import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptions;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.text.formatter.base.BaseFormatter;
import schemacrawler.tools.text.formatter.schema.SchemaListFormatter;
import schemacrawler.tools.text.formatter.schema.SchemaTextFormatter;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;
import schemacrawler.utility.NamedObjectSort;

public final class SchemaTextRenderer
extends BaseSchemaCrawlerCommand<SchemaTextOptions> {
    public SchemaTextRenderer(String command) {
        super(command);
    }

    @Override
    public void checkAvailability() throws Exception {
    }

    @Override
    public void execute() throws Exception {
        this.checkCatalog();
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler();
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setCatalog(this.catalog);
        traverser.setHandler(formatter);
        traverser.setTablesComparator(NamedObjectSort.getNamedObjectSort(((SchemaTextOptions)this.commandOptions).isAlphabeticalSortForTables()));
        traverser.setRoutinesComparator(NamedObjectSort.getNamedObjectSort(((SchemaTextOptions)this.commandOptions).isAlphabeticalSortForRoutines()));
        traverser.traverse();
    }

    @Override
    public boolean usesConnection() {
        return false;
    }

    private SchemaTextDetailType getSchemaTextDetailType() {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = SchemaTextDetailType.schema;
        }
        return schemaTextDetailType;
    }

    private SchemaTraversalHandler getSchemaTraversalHandler() throws SchemaCrawlerException {
        SchemaTextDetailType schemaTextDetailType = this.getSchemaTextDetailType();
        String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
        BaseFormatter formatter = schemaTextDetailType == SchemaTextDetailType.list ? new SchemaListFormatter(schemaTextDetailType, (SchemaTextOptions)this.commandOptions, this.outputOptions, identifierQuoteString) : new SchemaTextFormatter(schemaTextDetailType, (SchemaTextOptions)this.commandOptions, this.outputOptions, identifierQuoteString);
        return formatter;
    }
}

