/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import us.fatehi.utility.TemplatingUtility;
import us.fatehi.utility.Utility;

public class DatabaseConnectionUrlBuilder {
    private final String connectionUrlTemplate;
    private String defaultDatabase;
    private String defaultHost;
    private int defaultPort;
    private Map<String, String> defaultUrlx;
    private String providedDatabase;
    private String providedHost;
    private Integer providedPort;
    private Map<String, String> providedUrlx;

    public static DatabaseConnectionUrlBuilder builder(String connectionUrlTemplate) {
        return new DatabaseConnectionUrlBuilder(connectionUrlTemplate);
    }

    private DatabaseConnectionUrlBuilder(String connectionUrlTemplate) {
        this.connectionUrlTemplate = Objects.requireNonNull(connectionUrlTemplate, "No database connection URL template provided");
        this.defaultHost = "localhost";
        this.defaultDatabase = "";
    }

    public String toURL() {
        String host = Utility.isBlank(this.providedHost) ? this.defaultHost : this.providedHost;
        int port = this.providedPort == null || this.providedPort < 0 || this.providedPort > 65535 ? this.defaultPort : this.providedPort;
        String database = Utility.isBlank(this.providedDatabase) ? this.defaultDatabase : this.providedDatabase;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("host", host);
        map.put("port", String.valueOf(port));
        map.put("database", database);
        String url = TemplatingUtility.expandTemplate(this.connectionUrlTemplate, map);
        return url;
    }

    public Map<String, String> toUrlx() {
        HashMap<String, String> urlx = new HashMap<String, String>();
        if (this.defaultUrlx != null) {
            urlx.putAll(this.defaultUrlx);
        }
        if (this.providedUrlx != null) {
            urlx.putAll(this.providedUrlx);
        }
        return urlx;
    }

    public DatabaseConnectionUrlBuilder withDatabase(String database) {
        this.providedDatabase = database;
        return this;
    }

    public DatabaseConnectionUrlBuilder withDefaultDatabase(String defaultDatabase) {
        this.defaultDatabase = defaultDatabase;
        return this;
    }

    public DatabaseConnectionUrlBuilder withDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
        return this;
    }

    public DatabaseConnectionUrlBuilder withDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
        return this;
    }

    public DatabaseConnectionUrlBuilder withDefaultUrlx(Map<String, String> defaultUrlx) {
        this.defaultUrlx = defaultUrlx;
        return this;
    }

    public DatabaseConnectionUrlBuilder withHost(String host) {
        this.providedHost = host;
        return this;
    }

    public DatabaseConnectionUrlBuilder withPort(Integer port) {
        this.providedPort = port;
        return this;
    }

    public DatabaseConnectionUrlBuilder withUrlx(Map<String, String> urlx) {
        this.providedUrlx = urlx;
        return this;
    }
}

