/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public final class StopWatch {
    private static final DateTimeFormatter df = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 3, 3, true).toFormatter();
    private final String id;
    private final List<TaskInfo> tasks = new LinkedList<TaskInfo>();
    private String currentTaskName;
    private boolean running;
    private Instant start;
    private Duration totalDuration;

    public StopWatch(String id) {
        this.id = id;
        this.totalDuration = Duration.ofNanos(0L);
    }

    public String getId() {
        return this.id;
    }

    public boolean isRunning() {
        return this.running;
    }

    public Supplier<String> stringify() {
        return () -> {
            StringBuilder buffer = new StringBuilder(1024);
            LocalTime totalDurationLocal = LocalTime.ofNanoOfDay(this.totalDuration.toNanos());
            buffer.append(String.format("Total time taken for <%s> - %s hours%n", this.id, totalDurationLocal.format(df)));
            for (TaskInfo task : this.tasks) {
                buffer.append(String.format("-%5.1f%% - %s%n", this.calculatePercentage(task.getDuration(), this.totalDuration), task));
            }
            return buffer.toString();
        };
    }

    public <V> V time(String taskName, Callable<V> callable) throws Exception {
        this.start(taskName);
        V returnValue = callable.call();
        this.stop();
        return returnValue;
    }

    public void time(String taskName, Function callable) throws Exception {
        this.start(taskName);
        callable.call();
        this.stop();
    }

    private double calculatePercentage(Duration duration, Duration totalDuration) {
        long totalMillis = totalDuration.toMillis();
        if (totalMillis == 0L) {
            return 0.0;
        }
        return (double)duration.toMillis() * 100.0 / (double)totalMillis;
    }

    private void start(String taskName) {
        if (this.running) {
            throw new IllegalStateException(String.format("Cannot stop <%s>, since it is already running", this.id));
        }
        this.running = true;
        this.currentTaskName = taskName;
        this.start = Instant.now();
    }

    private void stop() {
        if (!this.running) {
            throw new IllegalStateException(String.format("Cannot stop <%s>, since it is not running", this.id));
        }
        Instant stop = Instant.now();
        Duration runTime = Duration.between(this.start, stop);
        this.totalDuration = this.totalDuration.plus(runTime);
        TaskInfo lastTaskInfo = new TaskInfo(this.currentTaskName, runTime);
        this.tasks.add(lastTaskInfo);
        this.running = false;
        this.currentTaskName = null;
        this.start = null;
    }

    @FunctionalInterface
    public static interface Function {
        public void call() throws Exception;
    }

    private static final class TaskInfo {
        private final Duration duration;
        private final String taskName;

        TaskInfo(String taskName, Duration duration) {
            this.taskName = taskName;
            this.duration = duration;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public String toString() {
            LocalTime durationLocal = LocalTime.ofNanoOfDay(this.duration.toNanos());
            return String.format("%s - <%s>", durationLocal.format(df), this.taskName);
        }
    }
}

