/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import picocli.CommandLine;
import schemacrawler.tools.commandline.command.PasswordOptions;
import schemacrawler.tools.commandline.command.UserOptions;
import schemacrawler.tools.commandline.state.MultiUseUserCredentials;
import schemacrawler.tools.databaseconnector.UserCredentials;

public final class UserCredentialsOptions {
    @CommandLine.ArgGroup
    private UserOptions userOptions;
    @CommandLine.ArgGroup
    private PasswordOptions passwordOptions;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    public UserCredentials getUserCredentials() {
        return new MultiUseUserCredentials(this.getUser(), this.getPassword());
    }

    private String getPassword() {
        if (this.passwordOptions == null) {
            return null;
        }
        try {
            return this.passwordOptions.getPassword();
        }
        catch (Exception e) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "No password provided", (Throwable)e);
        }
    }

    private String getUser() {
        if (this.userOptions == null) {
            return null;
        }
        try {
            return this.userOptions.getUser();
        }
        catch (Exception e) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "No user provided", (Throwable)e);
        }
    }
}

