/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import picocli.CommandLine;
import us.fatehi.utility.Utility;

public final class UserOptions {
    @CommandLine.Option(names={"--user:env"}, description={"Database user, from an environmental variable value"}, paramLabel="<environment variable name>")
    private String userEnvironmentVariable;
    @CommandLine.Option(names={"--user:file"}, description={"Database user, read from a file"}, paramLabel="<path to user file>")
    private Path userFile;
    @CommandLine.Option(names={"--user:prompt"}, interactive=true, description={"Database user, prompted from the console"})
    private String userPrompted;
    @CommandLine.Option(names={"--user"}, description={"Database user"}, paramLabel="<user>")
    private String userProvided;

    String getUser() {
        String user = this.getUserProvided();
        if (user == null) {
            user = this.getUserPrompted();
        }
        if (user == null) {
            user = this.getUserFromFile();
        }
        if (user == null) {
            user = this.getUserFromEnvironment();
        }
        return user;
    }

    private String getUserFromEnvironment() {
        if (Utility.isBlank((CharSequence)this.userEnvironmentVariable)) {
            return null;
        }
        String userEnvironment = null;
        try {
            userEnvironment = System.getenv(this.userEnvironmentVariable);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("User could not be read from environmental variable <%s>", this.userEnvironmentVariable), e);
        }
        return userEnvironment;
    }

    private String getUserFromFile() {
        if (this.userFile == null) {
            return null;
        }
        String user = null;
        try {
            List<String> lines = Files.readAllLines(this.userFile);
            if (!lines.isEmpty()) {
                user = lines.get(0);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("User could not be read from file <%s>", this.userFile), e);
        }
        return user;
    }

    private String getUserPrompted() {
        return this.userPrompted;
    }

    private String getUserProvided() {
        return this.userProvided;
    }
}

