/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.testdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class SqlScript
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(SqlScript.class.getName());
    private static final boolean debug = Boolean.valueOf(System.getProperty("schemacrawler.testdb.SqlScript.debug", "false"));
    private final String scriptResource;
    private final String delimiter;
    private final Connection connection;

    public SqlScript(String scriptResourceLine, Connection connection) {
        Objects.requireNonNull(scriptResourceLine, "No script resource line provided");
        String[] split = scriptResourceLine.split(",");
        if (split.length == 1) {
            this.scriptResource = scriptResourceLine.trim();
            this.delimiter = this.scriptResource == null || this.scriptResource.isEmpty() ? "#" : ";";
        } else if (split.length == 2) {
            this.delimiter = split[0].trim();
            this.scriptResource = split[1].trim();
        } else {
            throw new RuntimeException("Too many fields in " + scriptResourceLine);
        }
        this.connection = Objects.requireNonNull(connection, "No database connection provided");
    }

    @Override
    public void run() {
        boolean skip = this.delimiter.equals("#");
        if (debug) {
            LOGGER.log(Level.INFO, String.format("%s -- delimiter %s -- %s", this.scriptResource, this.delimiter, skip ? "skip" : "execute"));
        }
        if (skip) {
            return;
        }
        try (BufferedReader lineReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.scriptResource), StandardCharsets.UTF_8));){
            List<String> sqlList = this.readSql(lineReader);
            for (String sql : sqlList) {
                Statement statement = this.connection.createStatement();
                try {
                    if (Pattern.matches("\\s+", sql)) continue;
                    if (debug) {
                        LOGGER.log(Level.INFO, "\n" + sql);
                    }
                    statement.execute(sql);
                    SQLWarning warnings = statement.getWarnings();
                    if (warnings != null && !warnings.getMessage().startsWith("Can't drop database")) {
                        throw warnings;
                    }
                    this.connection.commit();
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
        }
        catch (SQLWarning e) {
            int errorCode = e.getErrorCode();
            if (errorCode == 5701 || errorCode == 5703) {
                return;
            }
            Throwable throwable = this.getCause(e);
            String message = String.format("Script: %s -- [%d %s] %s", this.scriptResource, errorCode, e.getSQLState(), throwable.getMessage());
            System.err.println(message);
            LOGGER.log(Level.WARNING, message, throwable);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            Throwable throwable = this.getCause(e);
            String message = String.format("Script: %s -- %s", this.scriptResource, throwable.getMessage());
            System.err.println(message);
            LOGGER.log(Level.WARNING, message, throwable);
            throw new RuntimeException(e);
        }
    }

    private Throwable getCause(Throwable e) {
        Throwable cause = null;
        Throwable result = e;
        while (null != (cause = result.getCause()) && result != cause) {
            result = cause;
        }
        return result;
    }

    private List<String> readSql(BufferedReader lineReader) throws IOException {
        String line;
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        while ((line = lineReader.readLine()) != null) {
            boolean isComment;
            String trimmedLine = line.trim();
            boolean bl = isComment = trimmedLine.startsWith("--") || trimmedLine.startsWith("//");
            if (!isComment && trimmedLine.endsWith(this.delimiter)) {
                sql.append(line.substring(0, line.lastIndexOf(this.delimiter)));
                list.add(sql.toString());
                sql = new StringBuilder();
                continue;
            }
            sql.append(line);
            sql.append("\n");
        }
        if (sql.length() > 0) {
            list.add(sql.toString());
        }
        return list;
    }
}

