/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.jdbc;

import java.io.IOException;
import java.net.SocketException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedConnection;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedDatabase;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.jdbc.EmbeddedLanguage;
import nl.cwi.monetdb.embedded.jdbc.EmbeddedProtocol;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetStatement;
import nl.cwi.monetdb.mcl.connection.IMonetDBLanguage;
import nl.cwi.monetdb.mcl.connection.MCLException;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;

public final class EmbeddedConnection
extends MonetConnection {
    private final String directory;
    private final boolean silentFlag;
    private final boolean sequentialFlag;

    public EmbeddedConnection(Properties props, String hash, String language, String directory) {
        super(props, hash, (IMonetDBLanguage)EmbeddedLanguage.GetLanguageFromString(language), true, true);
        this.directory = directory;
        this.silentFlag = true;
        this.sequentialFlag = false;
    }

    public EmbeddedConnection(Properties props, String hash, String language, String directory, Boolean silentFlag, Boolean sequentialFlag) {
        super(props, hash, (IMonetDBLanguage)EmbeddedLanguage.GetLanguageFromString(language), true, true);
        this.directory = directory;
        this.silentFlag = silentFlag;
        this.sequentialFlag = sequentialFlag;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isRunningInMemory() {
        return this.directory == null;
    }

    public boolean isSilentFlag() {
        return this.silentFlag;
    }

    public boolean isSequentialFlag() {
        return this.sequentialFlag;
    }

    public MonetDBEmbeddedConnection getAsMonetDBEmbeddedConnection() {
        return ((EmbeddedProtocol)this.protocol).getEmbeddedConnection();
    }

    public List<String> connect(String user, String pass) throws IOException, ProtocolException, MCLException {
        try {
            this.protocol = new EmbeddedProtocol(MonetDBEmbeddedDatabase.createJDBCEmbeddedConnection(this.directory, this.silentFlag, this.sequentialFlag));
        }
        catch (MonetDBEmbeddedException ex) {
            throw new MCLException((Throwable)ex);
        }
        return null;
    }

    public String getJDBCURL() {
        if (this.directory != null) {
            return "jdbc:monetdb:embedded:" + this.directory;
        }
        return "jdbc:monetdb:embedded::memory:";
    }

    public int getBlockSize() {
        return Integer.MAX_VALUE;
    }

    public int getDefFetchsize() {
        return Integer.MAX_VALUE;
    }

    public int initialStringBuilderSize() {
        return 8192;
    }

    public int getSoTimeout() throws SocketException {
        throw new SocketException("Cannot get a timeout on a embedded connection");
    }

    public void setSoTimeout(int timeout) throws SocketException {
        throw new SocketException("Cannot set a timeout on a embedded connection");
    }

    public synchronized void closeUnderlyingConnection() throws IOException {
        ((EmbeddedProtocol)this.protocol).getEmbeddedConnection().close();
    }

    public void sendControlCommand(int commandID, int data) throws SQLException {
        switch (commandID) {
            case 1: {
                ((EmbeddedProtocol)this.protocol).getEmbeddedConnection().sendAutocommitCommand(data);
                break;
            }
            case 3: {
                ((EmbeddedProtocol)this.protocol).getEmbeddedConnection().sendReleaseCommand(data);
                break;
            }
            case 4: {
                ((EmbeddedProtocol)this.protocol).getEmbeddedConnection().sendCloseCommand(data);
            }
        }
    }

    protected boolean executeNextQueryBatch(MonetStatement statement, List<String> batch, int[] counts, BatchUpdateException e) throws SQLException {
        int i = 0;
        boolean error = false;
        for (String query : batch) {
            error |= statement.internalBatch(query, counts, i, i + 1, e);
            ++i;
        }
        return error;
    }
}

