/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.jdbc;

import java.io.IOException;
import java.util.Map;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.jdbc.EmbeddedDataBlockResponse;
import nl.cwi.monetdb.embedded.jdbc.JDBCEmbeddedConnection;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.mcl.protocol.AbstractProtocol;
import nl.cwi.monetdb.mcl.protocol.ProtocolException;
import nl.cwi.monetdb.mcl.responses.AbstractDataBlockResponse;
import nl.cwi.monetdb.mcl.responses.AutoCommitResponse;
import nl.cwi.monetdb.mcl.responses.ResultSetResponse;
import nl.cwi.monetdb.mcl.responses.UpdateResponse;

public final class EmbeddedProtocol
extends AbstractProtocol {
    private final JDBCEmbeddedConnection connection;

    EmbeddedProtocol(JDBCEmbeddedConnection con) {
        this.connection = con;
    }

    JDBCEmbeddedConnection getEmbeddedConnection() {
        return this.connection;
    }

    public int getCurrentServerResponse() {
        return this.connection.getNextServerResponse();
    }

    public void waitUntilPrompt() throws IOException {
    }

    public void fetchNextResponseData() throws IOException {
    }

    public int getNextStarterHeader() {
        return this.connection.getServerHeaderResponse();
    }

    public ResultSetResponse getNextResultSetResponse(MonetConnection con, MonetConnection.ResponseList list, int seqnr, int maxrows) throws ProtocolException {
        int[] array = this.connection.getLastServerResponseParameters();
        int id = array[0];
        int rowcount = array[1];
        int columncount = array[2];
        return new ResultSetResponse(con, list, id, seqnr, rowcount, rowcount, columncount);
    }

    public UpdateResponse getNextUpdateResponse() throws ProtocolException {
        return (UpdateResponse)this.connection.getLastServerResponse();
    }

    public AutoCommitResponse getNextAutoCommitResponse() throws ProtocolException {
        return (AutoCommitResponse)this.connection.getLastServerResponse();
    }

    public AbstractDataBlockResponse getAnEmptyDataBlockResponse(int rowcount, int columncount, AbstractProtocol protocol, int[] JdbcSQLTypes, String[] types) {
        return new EmbeddedDataBlockResponse(rowcount, protocol, JdbcSQLTypes, types);
    }

    public AbstractDataBlockResponse getNextDatablockResponse(Map<Integer, ResultSetResponse> rsresponses) throws ProtocolException {
        int[] array = this.connection.getLastServerResponseParameters();
        int id = array[0];
        int rowcount = array[1];
        ResultSetResponse rs = rsresponses.get(id);
        if (rs == null) {
            return null;
        }
        return rs.addDataBlockResponse(rowcount, rowcount);
    }

    public int getNextTableHeader(String[] columnNames, int[] columnLengths, String[] types, String[] tableNames) throws ProtocolException {
        try {
            return this.connection.fillTableHeaders(columnNames, columnLengths, types, tableNames);
        }
        catch (MonetDBEmbeddedException ex) {
            throw new ProtocolException(ex.getMessage(), 0);
        }
    }

    void initializePointers(EmbeddedDataBlockResponse response) throws ProtocolException {
        try {
            this.connection.initializePointers(response);
        }
        catch (MonetDBEmbeddedException ex) {
            throw new ProtocolException(ex.getMessage(), 0);
        }
    }

    public String getRemainingStringLine(int startIndex) {
        return this.connection.getLastError();
    }

    public void writeNextQuery(String prefix, String query, String suffix) throws IOException {
        try {
            this.connection.processNextQuery(query);
        }
        catch (MonetDBEmbeddedException ex) {
            throw new IOException(ex.getMessage());
        }
    }
}

