/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.jdbc;

import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedConnection;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedDatabase;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.jdbc.EmbeddedDataBlockResponse;
import nl.cwi.monetdb.mcl.responses.IResponse;

public final class JDBCEmbeddedConnection
extends MonetDBEmbeddedConnection {
    private volatile long lastResultSetPointer;
    private final int[] lineResponse = new int[4];
    private volatile int currentLineResponseState;
    private volatile int serverHeaderResponse;
    private final int[] lastServerResponseParameters = new int[4];
    private IResponse lastServerResponse;
    private String lastError;

    protected JDBCEmbeddedConnection(long connectionPointer) {
        super(connectionPointer);
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.closeConnectionImplementation();
            try {
                MonetDBEmbeddedDatabase.removeConnection(this, true);
            }
            catch (MonetDBEmbeddedException monetDBEmbeddedException) {
                // empty catch block
            }
        }
    }

    int getNextServerResponse() {
        return this.lineResponse[this.currentLineResponseState++];
    }

    int getServerHeaderResponse() {
        return this.serverHeaderResponse;
    }

    int[] getLastServerResponseParameters() {
        return this.lastServerResponseParameters;
    }

    IResponse getLastServerResponse() {
        return this.lastServerResponse;
    }

    int fillTableHeaders(String[] columnNames, int[] columnLengths, String[] types, String[] tableNames) throws MonetDBEmbeddedException {
        this.getNextTableHeaderInternal(this.connectionPointer, this.lastResultSetPointer, columnNames, columnLengths, types, tableNames);
        return 15;
    }

    void initializePointers(EmbeddedDataBlockResponse response) throws MonetDBEmbeddedException {
        this.initializePointersInternal(this.connectionPointer, this.lastResultSetPointer, response);
    }

    String getLastError() {
        return this.lastError;
    }

    void processNextQuery(String query) throws MonetDBEmbeddedException {
        if (!query.endsWith(";")) {
            query = query + ";";
        }
        this.currentLineResponseState = 0;
        this.sendQueryInternal(this.connectionPointer, query, true);
    }

    void sendAutocommitCommand(int flag) throws MonetDBEmbeddedException {
        this.sendAutocommitCommandInternal(this.connectionPointer, flag);
    }

    void sendReleaseCommand(int resultSetId) throws MonetDBEmbeddedException {
        this.sendReleaseCommandInternal(this.connectionPointer, resultSetId);
    }

    void sendCloseCommand(int queryId) throws MonetDBEmbeddedException {
        this.sendCloseCommandInternal(this.connectionPointer, queryId);
    }

    private native void getNextTableHeaderInternal(long var1, long var3, String[] var5, int[] var6, String[] var7, String[] var8) throws MonetDBEmbeddedException;

    private native void initializePointersInternal(long var1, long var3, EmbeddedDataBlockResponse var5) throws MonetDBEmbeddedException;

    private native void sendQueryInternal(long var1, String var3, boolean var4) throws MonetDBEmbeddedException;

    private native void sendAutocommitCommandInternal(long var1, int var3) throws MonetDBEmbeddedException;

    private native void sendReleaseCommandInternal(long var1, int var3) throws MonetDBEmbeddedException;

    private native void sendCloseCommandInternal(long var1, int var3) throws MonetDBEmbeddedException;
}

