/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ColumnPointer;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableIndex;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTrigger;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.crawl.TablePointer;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.plugin.EnumDataTypeInfo;
import schemacrawler.schema.ActionOrientationType;
import schemacrawler.schema.CheckOptionType;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.Table;
import schemacrawler.schema.TypedObject;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import us.fatehi.utility.string.StringFormat;

final class TableExtRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableExtRetriever.class.getName());

    TableExtRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveAdditionalColumnAttributes() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES)) {
            LOGGER.log(Level.INFO, "Not retrieving additional column attributes, since this was not requested");
            LOGGER.log(Level.FINE, "Additional column attributes SQL statement was not provided");
            return;
        }
        Query columnAttributesSql = informationSchemaViews.getQuery(InformationSchemaKey.ADDITIONAL_COLUMN_ATTRIBUTES);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(columnAttributesSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                String columnName = results.getString("COLUMN_NAME");
                LOGGER.log(Level.FINER, "Retrieving additional column attributes: " + columnName);
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableName}));
                    continue;
                }
                MutableTable table = tableOptional.get();
                Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
                if (!columnOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find column <%s.%s.%s.%s>", new Object[]{catalogName, schemaName, tableName, columnName}));
                    continue;
                }
                MutableColumn column = columnOptional.get();
                column.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional column attributes", e);
        }
    }

    void retrieveAdditionalColumnMetadata() {
        EnumDataTypeHelper enumDataTypeHelper = this.getRetrieverConnection().getEnumDataTypeHelper();
        NamedObjectList<MutableTable> tables = this.catalog.getAllTables();
        for (MutableTable table : tables) {
            NamedObjectList<MutableColumn> columns = table.getAllColumns();
            for (MutableColumn column : columns) {
                MutableColumnDataType columnDataType = (MutableColumnDataType)column.getColumnDataType();
                EnumDataTypeInfo enumDataTypeInfo = enumDataTypeHelper.getEnumDataTypeInfo(column, columnDataType, this.getRetrieverConnection().getConnection());
                switch (enumDataTypeInfo.getType()) {
                    case enumerated_column: {
                        MutableColumnDataType copiedColumnDataType;
                        columnDataType = copiedColumnDataType = new MutableColumnDataType(columnDataType);
                        columnDataType.setEnumValues(enumDataTypeInfo.getEnumValues());
                        break;
                    }
                    case enumerated_data_type: {
                        columnDataType.setEnumValues(enumDataTypeInfo.getEnumValues());
                        break;
                    }
                }
                column.setColumnDataType(columnDataType);
            }
        }
    }

    void retrieveAdditionalTableAttributes() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.ADDITIONAL_TABLE_ATTRIBUTES)) {
            LOGGER.log(Level.INFO, "Not retrieving additional table attributes, since this was not requested");
            LOGGER.log(Level.FINE, "Additional table attributes SQL statement was not provided");
            return;
        }
        Query tableAttributesSql = informationSchemaViews.getQuery(InformationSchemaKey.ADDITIONAL_TABLE_ATTRIBUTES);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableAttributesSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                LOGGER.log(Level.FINER, "Retrieving additional table attributes: " + tableName);
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableName}));
                    continue;
                }
                MutableTable table = tableOptional.get();
                table.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve additional table attributes", e);
        }
    }

    void retrieveIndexInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.EXT_INDEXES)) {
            LOGGER.log(Level.INFO, "Not retrieving additional index information, since this was not requested");
            LOGGER.log(Level.FINE, "Indexes information SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving additional index information");
        Query extIndexesInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.EXT_INDEXES);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(extIndexesInformationSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.normalizeCatalogName(results.getString("INDEX_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("INDEX_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                String indexName = results.getString("INDEX_NAME");
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, indexName}));
                    continue;
                }
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving index information <%s>", new Object[]{indexName}));
                MutableTable table = tableOptional.get();
                Optional<MutableIndex> indexOptional = table.lookupIndex(indexName);
                if (!indexOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find index <%s.%s.%s.%s>", new Object[]{catalogName, schemaName, tableName, indexName}));
                    continue;
                }
                MutableIndex index = indexOptional.get();
                String definition = results.getString("INDEX_DEFINITION");
                String remarks = results.getString("REMARKS");
                index.appendDefinition(definition);
                index.setRemarks(remarks);
                index.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve index information", e);
        }
    }

    void retrieveTableColumnPrivileges() throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getColumnPrivileges(null, null, null, null));){
            this.createPrivileges(results, true);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table column privileges:" + e.getMessage());
        }
    }

    void retrieveTableDefinitions() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.EXT_TABLES)) {
            LOGGER.log(Level.INFO, "Not retrieving table definitions, since this was not requested");
            LOGGER.log(Level.FINE, "Table definitions SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving table definitions");
        Query tableDefinitionsInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.EXT_TABLES);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableDefinitionsInformationSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String tableName;
                String schemaName;
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA")), tableName = results.getString("TABLE_NAME"));
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableName}));
                    continue;
                }
                MutableTable table = tableOptional.get();
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving table information <%s>", new Object[]{tableName}));
                String definition = results.getString("TABLE_DEFINITION");
                table.appendDefinition(definition);
                table.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table definitions", e);
        }
    }

    void retrieveTablePrivileges() throws SQLException {
        try (MetadataResultSet results = new MetadataResultSet(this.getMetaData().getTablePrivileges(null, null, null));){
            this.createPrivileges(results, false);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table privileges", e);
        }
    }

    void retrieveTriggerInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.TRIGGERS)) {
            LOGGER.log(Level.INFO, "Not retrieving trigger definitions, since this was not requested");
            LOGGER.log(Level.FINE, "Trigger definition SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving trigger definitions");
        Query triggerInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.TRIGGERS);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(triggerInformationSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.normalizeCatalogName(results.getString("TRIGGER_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("TRIGGER_SCHEMA"));
                String triggerName = results.getString("TRIGGER_NAME");
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving trigger <%s>", new Object[]{triggerName}));
                String tableName = results.getString("EVENT_OBJECT_TABLE");
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, tableName}));
                    continue;
                }
                MutableTable table = tableOptional.get();
                EventManipulationType eventManipulationType = results.getEnum("EVENT_MANIPULATION", EventManipulationType.unknown);
                int actionOrder = results.getInt("ACTION_ORDER", 0);
                String actionCondition = results.getString("ACTION_CONDITION");
                String actionStatement = results.getString("ACTION_STATEMENT");
                ActionOrientationType actionOrientation = results.getEnum("ACTION_ORIENTATION", ActionOrientationType.unknown);
                String conditionTimingString = results.getString("ACTION_TIMING");
                if (conditionTimingString == null) {
                    conditionTimingString = results.getString("CONDITION_TIMING");
                }
                ConditionTimingType conditionTiming = ConditionTimingType.valueOfFromValue(conditionTimingString);
                MutableTrigger trigger = table.lookupTrigger(triggerName).orElse(new MutableTrigger(table, triggerName));
                trigger.setEventManipulationType(eventManipulationType);
                trigger.setActionOrder(actionOrder);
                trigger.appendActionCondition(actionCondition);
                trigger.appendActionStatement(actionStatement);
                trigger.setActionOrientation(actionOrientation);
                trigger.setConditionTiming(conditionTiming);
                trigger.addAttributes(results.getAttributes());
                table.addTrigger(trigger);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve triggers", e);
        }
    }

    void retrieveViewInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.VIEWS)) {
            LOGGER.log(Level.INFO, "Not retrieving additional view information, since this was not requested");
            LOGGER.log(Level.FINE, "Views SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving additional view information");
        Query viewInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.VIEWS);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(viewInformationSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String viewName;
                String schemaName;
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                Optional<MutableTable> viewOptional = this.lookupTable(catalogName, schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA")), viewName = results.getString("TABLE_NAME"));
                if (!viewOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{catalogName, schemaName, viewName}));
                    continue;
                }
                MutableView view = (MutableView)viewOptional.get();
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving view information <%s>", new Object[]{viewName}));
                String definition = results.getString("VIEW_DEFINITION");
                CheckOptionType checkOption = results.getEnum("CHECK_OPTION", CheckOptionType.unknown);
                boolean updatable = results.getBoolean("IS_UPDATABLE");
                view.appendDefinition(definition);
                view.setCheckOption(checkOption);
                view.setUpdatable(updatable);
                view.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve views", e);
        }
    }

    void retrieveViewTableUsage() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.VIEW_TABLE_USAGE)) {
            LOGGER.log(Level.INFO, "Not retrieving additional view table usage, since this was not requested");
            LOGGER.log(Level.FINE, "View table usage SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving view table usage");
        Query viewTableUsageSql = informationSchemaViews.getQuery(InformationSchemaKey.VIEW_TABLE_USAGE);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(viewTableUsageSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String viewName;
                String schemaName;
                String catalogName = this.normalizeCatalogName(results.getString("VIEW_CATALOG"));
                Optional<MutableTable> viewOptional = this.lookupTable(catalogName, schemaName = this.normalizeSchemaName(results.getString("VIEW_SCHEMA")), viewName = results.getString("VIEW_NAME"));
                if (!viewOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find view <%s.%s.%s>", new Object[]{catalogName, schemaName, viewName}));
                    continue;
                }
                MutableView view = (MutableView)viewOptional.get();
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving view information <%s>", new Object[]{viewName}));
                String tableCatalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                String tableSchemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                Optional<MutableTable> tableOptional = this.lookupTable(tableCatalogName, tableSchemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Cannot find table <%s.%s.%s>", new Object[]{tableCatalogName, tableSchemaName, tableName}));
                    continue;
                }
                MutableTable table = tableOptional.get();
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving table information <%s>", new Object[]{tableName}));
                view.addTableUsage(table);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table usage for views", e);
        }
    }

    private void createPrivileges(MetadataResultSet results, boolean privilegesForColumn) throws SQLException {
        while (results.next()) {
            MutablePrivilege<TypedObject<ColumnDataType>> privilege;
            Optional<MutablePrivilege<TypedObject<ColumnDataType>>> privilegeOptional;
            MutableColumn column;
            String catalogName = this.normalizeCatalogName(results.getString("TABLE_CAT"));
            String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM"));
            String tableName = results.getString("TABLE_NAME");
            String columnName = privilegesForColumn ? results.getString("COLUMN_NAME") : null;
            Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
            if (!tableOptional.isPresent()) continue;
            MutableTable table = tableOptional.get();
            if (privilegesForColumn) {
                Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
                if (!columnOptional.isPresent()) continue;
                column = columnOptional.get();
            } else {
                column = null;
            }
            String privilegeName = results.getString("PRIVILEGE");
            String grantor = results.getString("GRANTOR");
            String grantee = results.getString("GRANTEE");
            boolean isGrantable = results.getBoolean("IS_GRANTABLE");
            if (privilegesForColumn) {
                privilegeOptional = column.lookupPrivilege(privilegeName);
                privilege = privilegeOptional.orElse(new MutablePrivilege<Column>(new ColumnPointer(column), privilegeName));
            } else {
                privilegeOptional = table.lookupPrivilege(privilegeName);
                privilege = privilegeOptional.orElse(new MutablePrivilege<Table>(new TablePointer(table), privilegeName));
            }
            privilege.addGrant(grantor, grantee, isGrantable);
            if (privilegesForColumn) {
                column.addPrivilege(privilege);
                continue;
            }
            table.addPrivilege(privilege);
        }
    }
}

