/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.mapping;

import java.util.Arrays;
import java.util.ListIterator;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.mapping.AbstractRowSet;

public final class MonetDBRow
implements Iterable {
    private final AbstractRowSet originalSet;
    private Object[] columns;

    MonetDBRow(AbstractRowSet originalSet, Object[] columns) {
        this.originalSet = originalSet;
        this.columns = columns;
    }

    public AbstractRowSet getRowSet() {
        return this.originalSet;
    }

    public Object[] getAllColumns() {
        return this.columns;
    }

    public void setAllColumns(Object[] values) {
        if (values.length != this.columns.length) {
            throw new ArrayStoreException("The values array and the columns length differ");
        }
        this.columns = values;
    }

    public int getNumberOfColumns() {
        return this.columns.length;
    }

    public <T> T getColumnByIndex(int index, Class<T> javaClass) {
        return javaClass.cast(this.columns[index - 1]);
    }

    public <T> T getColumnByIndex(int index) {
        Class javaClass = this.originalSet.mappings[index - 1].getJavaClass();
        return javaClass.cast(this.columns[index - 1]);
    }

    public <T> T getColumnByName(String columnName, Class<T> javaClass) throws MonetDBEmbeddedException {
        int index = this.getRowSet().getColumnIndexByName(columnName);
        return javaClass.cast(this.columns[index - 1]);
    }

    public <T> T getColumnByName(String columnName) throws MonetDBEmbeddedException {
        int index = this.getRowSet().getColumnIndexByName(columnName);
        Class javaClass = this.originalSet.mappings[index - 1].getJavaClass();
        return javaClass.cast(this.columns[index - 1]);
    }

    public <T> void setColumnByIndex(int index, T value) {
        this.columns[index - 1] = this.originalSet.mappings[index - 1].getJavaClass().cast(value);
    }

    public <T> void setColumnByIndex(int index, Class<T> javaClass, T value) {
        this.columns[index - 1] = javaClass.cast(value);
    }

    public <T> void setColumnByName(String columnName, T value) throws MonetDBEmbeddedException {
        int index = this.getRowSet().getColumnIndexByName(columnName);
        this.columns[index - 1] = this.originalSet.mappings[index - 1].getJavaClass().cast(value);
    }

    public <T> void setColumnByName(String columnName, Class<T> javaClass, T value) throws MonetDBEmbeddedException {
        int index = this.getRowSet().getColumnIndexByName(columnName);
        this.columns[index - 1] = javaClass.cast(value);
    }

    public ListIterator<Object> iterator() {
        return Arrays.asList(this.columns).listIterator();
    }
}

